/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.completion.keyword;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.RubyCompletionProviderUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RCondition;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RForStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RUntilStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RWhileStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RGroupedExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RListOfExpressions;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.methodCall.RCallNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RDoBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;

public class RubyDoCompletionFilter
implements ElementFilter {
    private static boolean isDoAfterCallWithNoArgs(@NotNull PsiElement element) {
        RListOfExpressions list;
        if (element == null) {
            RubyDoCompletionFilter.$$$reportNull$$$0(0);
        }
        if ((list = (RListOfExpressions)PsiTreeUtil.getParentOfType((PsiElement)element, RListOfExpressions.class)) == null) {
            return false;
        }
        RPsiElement argument = (RPsiElement)list.getElements().get(0);
        if (!PsiTreeUtil.isAncestor((PsiElement)argument, (PsiElement)element, (boolean)false)) {
            return false;
        }
        PsiElement firstInArgument = PsiTreeUtil.getDeepestFirst((PsiElement)argument);
        if (firstInArgument.getParent() != element) {
            return false;
        }
        if (PsiTreeUtil.getDeepestFirst((PsiElement)list).getParent() instanceof RGroupedExpression) {
            return false;
        }
        RCall rCall = RCallNavigator.getByRListOfExpressions((RListOfExpressions)list);
        return rCall != null;
    }

    public boolean isAcceptable(Object element, @Nullable PsiElement context) {
        PsiElement prevSibling;
        RPsiElement rContext = RubyPsiUtilCore.getCoveringRPsiElement((PsiElement)context);
        if (rContext == null) {
            return false;
        }
        RPsiElement statement = RubyPsiUtilCore.getStatement((PsiElement)context);
        if (statement != null && !(statement instanceof RDoBlockCall) && PsiTreeUtil.getDeepestFirst((PsiElement)statement) == context && (prevSibling = RubyPsiUtilCore.getPrevSignificantSibling((PsiElement)statement)) instanceof RPossibleCall) {
            return true;
        }
        prevSibling = RubyPsiUtilCore.getPrevSignificantSibling((PsiElement)rContext);
        if (prevSibling instanceof RPossibleCall) {
            return true;
        }
        if (RubyDoCompletionFilter.isDoAfterCallWithNoArgs((PsiElement)rContext)) {
            return true;
        }
        RPsiElement parent = rContext;
        do {
            if ((parent = parent.getParent()) instanceof RContainer) {
                return false;
            }
            RCompoundStatement compoundStatement = (RCompoundStatement)PsiTreeUtil.getParentOfType((PsiElement)rContext, RCompoundStatement.class);
            if (compoundStatement == null) {
                return false;
            }
            PsiElement sibling = RubyCompletionProviderUtil.getPrevNotWhitespaceSibling((PsiElement)compoundStatement);
            if (sibling instanceof PsiErrorElement) {
                sibling = RubyCompletionProviderUtil.getPrevNotWhitespaceSibling(sibling);
            }
            if (parent instanceof RWhileStatement || parent instanceof RUntilStatement) {
                RCondition condition = (RCondition)PsiTreeUtil.getParentOfType((PsiElement)rContext, RCondition.class);
                if (condition != null && condition.getFirstChild() != rContext && PsiTreeUtil.getDeepestLast((PsiElement)condition) == context) {
                    return true;
                }
                return sibling instanceof RCondition && PsiTreeUtil.getDeepestFirst((PsiElement)compoundStatement) == context;
            }
            if (!(parent instanceof RForStatement)) continue;
            RPsiElement expression = ((RForStatement)parent).getExpression();
            if (expression == null) {
                return false;
            }
            if (PsiTreeUtil.getDeepestLast((PsiElement)expression) == context) {
                return true;
            }
            return sibling instanceof RExpression && PsiTreeUtil.getDeepestFirst((PsiElement)compoundStatement) == context;
        } while (parent != null && !(parent instanceof PsiFile));
        return false;
    }

    public boolean isClassAcceptable(Class hintClass) {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/ruby/ruby/codeInsight/completion/keyword/RubyDoCompletionFilter", "isDoAfterCallWithNoArgs"));
    }
}

