/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.completion.exception;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.icons.AllIcons;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopes;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.codeInsight.ExceptionCachingFilter;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.RubyCompletionGrouping;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.RubyCompletionProviderUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.RubyLookupElement;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.RubyTrackedCompletionProvider;
import org.jetbrains.plugins.ruby.ruby.lang.RubyLanguage;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.indexes.RubyConstantDeclarationFqnIndex;
import org.jetbrains.plugins.ruby.ruby.lang.psi.indexes.RubyInheritanceResolutionIndex;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RConstant;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;
import org.jetbrains.plugins.ruby.utils.SmartCancellationChecker;

public class RubyExceptionCompletionProvider
extends RubyTrackedCompletionProvider {
    public static final RubyExceptionCompletionProvider INSTANCE = new RubyExceptionCompletionProvider();

    private RubyExceptionCompletionProvider() {
        super((Language)RubyLanguage.INSTANCE);
    }

    @Override
    protected void addCompletionsTracked(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            RubyExceptionCompletionProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            RubyExceptionCompletionProvider.$$$reportNull$$$0(1);
        }
        if (result == null) {
            RubyExceptionCompletionProvider.$$$reportNull$$$0(2);
        }
        Project project = parameters.getPosition().getProject();
        SearchScope searchScope = RubyExceptionCompletionProvider.getSearchScope(project, parameters.getPosition(), result);
        PsiElement invocationPoint = parameters.getPosition();
        int priority = RubyCompletionGrouping.EXCEPTION.getValue();
        result.addElement(PrioritizedLookupElement.withPriority((LookupElement)new RubyLookupElement("Exception", null, null, true, AllIcons.Nodes.ExceptionClass, null), (double)priority));
        SmartCancellationChecker checker = new SmartCancellationChecker();
        RubyInheritanceResolutionIndex.ForSuperClasses.getInstance().processAllKeys(project, key -> {
            checker.checkCancelled();
            if (!RubyCompletionProviderUtil.lookupStringShouldBeProcessed(key, result)) {
                return true;
            }
            RClass declaration = (RClass)RubyInheritanceResolutionIndex.ForSuperClasses.getInstance().findElement(project, searchScope, key);
            if (declaration == null || !ExceptionCachingFilter.isAcceptedClass((PsiElement)declaration)) {
                return true;
            }
            LookupElement lookupElement = PrioritizedLookupElement.withPriority((LookupElement)new RubyLookupElement(declaration.getFQN().getShortName(), null, null, true, AllIcons.Nodes.ExceptionClass, null), (double)priority);
            result.addElement(lookupElement);
            return true;
        });
        RubyConstantDeclarationFqnIndex.getInstance().processAllKeys(project, key -> {
            checker.checkCancelled();
            if (!RubyCompletionProviderUtil.lookupStringShouldBeProcessed(key, result)) {
                return true;
            }
            String name = (String)ObjectUtils.coalesce((Object)StringUtil.substringAfterLast((String)key, (String)"::"), (Object)key);
            if (!StringUtil.hasLowerCaseChar((String)name)) {
                return true;
            }
            RConstant declaration = (RConstant)RubyConstantDeclarationFqnIndex.getInstance().findElement(project, searchScope, key);
            if (declaration == null || !ExceptionCachingFilter.isAcceptedConstant((PsiElement)declaration, invocationPoint)) {
                return true;
            }
            LookupElement lookupElement = PrioritizedLookupElement.withPriority((LookupElement)new RubyLookupElement(declaration.getFQN().getShortName(), null, null, true, AllIcons.Nodes.ExceptionClass, null), (double)priority);
            result.addElement(lookupElement);
            return true;
        });
    }

    @NotNull
    private static SearchScope getSearchScope(@NotNull Project project, @NotNull PsiElement element, @NotNull CompletionResultSet result) {
        if (project == null) {
            RubyExceptionCompletionProvider.$$$reportNull$$$0(3);
        }
        if (element == null) {
            RubyExceptionCompletionProvider.$$$reportNull$$$0(4);
        }
        if (result == null) {
            RubyExceptionCompletionProvider.$$$reportNull$$$0(5);
        }
        GlobalSearchScope resolveScope = element.getResolveScope();
        if (!result.getPrefixMatcher().getPrefix().isEmpty()) {
            GlobalSearchScope globalSearchScope = resolveScope;
            if (globalSearchScope == null) {
                RubyExceptionCompletionProvider.$$$reportNull$$$0(6);
            }
            return globalSearchScope;
        }
        result.restartCompletionWhenNothingMatches();
        SearchScope searchScope = resolveScope.intersectWith(RubyExceptionCompletionProvider.getStdlibLibraryScope(project)).union((SearchScope)GlobalSearchScope.fileScope((Project)project, (VirtualFile)PsiUtilCore.getVirtualFile((PsiElement)element)));
        if (searchScope == null) {
            RubyExceptionCompletionProvider.$$$reportNull$$$0(7);
        }
        return searchScope;
    }

    @NotNull
    private static SearchScope getStdlibLibraryScope(@NotNull Project project) {
        VirtualFile rubystubsDir;
        if (project == null) {
            RubyExceptionCompletionProvider.$$$reportNull$$$0(8);
        }
        if ((rubystubsDir = VirtualFileManager.getInstance().findFileByNioPath(RubySdkUtil.getRubystubsRoot())) == null) {
            GlobalSearchScope globalSearchScope = GlobalSearchScope.EMPTY_SCOPE;
            if (globalSearchScope == null) {
                RubyExceptionCompletionProvider.$$$reportNull$$$0(9);
            }
            return globalSearchScope;
        }
        GlobalSearchScope globalSearchScope = GlobalSearchScopes.directoryScope((Project)project, (VirtualFile)rubystubsDir, (boolean)true);
        if (globalSearchScope == null) {
            RubyExceptionCompletionProvider.$$$reportNull$$$0(10);
        }
        return globalSearchScope;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/completion/exception/RubyExceptionCompletionProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/completion/exception/RubyExceptionCompletionProvider";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSearchScope";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getStdlibLibraryScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addCompletionsTracked";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getSearchScope";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getStdlibLibraryScope";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 9, 10 -> new IllegalStateException(string);
        };
    }
}

