/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.completion;

import com.intellij.codeInsight.completion.AddSpaceInsertHandler;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.RubyCompletionGrouping;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.RubyDoBlockInsertHandler;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypesCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementType;

public final class RubyCompletionProviderUtil {
    private static final TokenSet KEYWORDS_NOT_FOLLOWED_BY_SPACE = TokenSet.create((IElementType[])new IElementType[]{RubyTokenTypes.kBEGIN, RubyTokenTypes.kEND, RubyTokenTypesCore.kFALSE, RubyTokenTypes.kFILE, RubyTokenTypes.kLINE, RubyTokenTypesCore.kNIL, RubyTokenTypes.kSELF, RubyTokenTypes.kSUPER, RubyTokenTypesCore.kTRUE, RubyTokenTypes.kYIELD});

    private RubyCompletionProviderUtil() {
    }

    public static void addKeywords(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result, @NotNull TokenSet tokens) {
        String prefix;
        if (parameters == null) {
            RubyCompletionProviderUtil.$$$reportNull$$$0(0);
        }
        if (result == null) {
            RubyCompletionProviderUtil.$$$reportNull$$$0(1);
        }
        if (tokens == null) {
            RubyCompletionProviderUtil.$$$reportNull$$$0(2);
        }
        if ((prefix = CompletionUtil.findReferencePrefix((CompletionParameters)parameters)) == null) {
            prefix = CompletionUtil.findJavaIdentifierPrefix((CompletionParameters)parameters);
        }
        CompletionResultSet keywordCollector = result.withPrefixMatcher(prefix);
        for (IElementType type : tokens.getTypes()) {
            String lookupText = ((RubyElementType)type).getRealText();
            if (!RubyCompletionProviderUtil.lookupStringShouldBeProcessed(lookupText, keywordCollector)) continue;
            LookupElementBuilder elementBuilder = LookupElementBuilder.create((String)lookupText);
            if (type == RubyTokenTypes.kDO) {
                elementBuilder = elementBuilder.withInsertHandler((InsertHandler)RubyDoBlockInsertHandler.INSTANCE);
            } else if (!KEYWORDS_NOT_FOLLOWED_BY_SPACE.contains(type)) {
                elementBuilder = elementBuilder.withInsertHandler(AddSpaceInsertHandler.INSTANCE);
            }
            keywordCollector.addElement(PrioritizedLookupElement.withPriority((LookupElement)elementBuilder.bold(), (double)RubyCompletionGrouping.RUBY_KEYWORDS.getValue()));
        }
    }

    @Nullable
    public static PsiElement getPrevNotWhitespaceSibling(@NotNull PsiElement context) {
        if (context == null) {
            RubyCompletionProviderUtil.$$$reportNull$$$0(3);
        }
        PsiElement notWhiteSpaceSibling = context;
        while ((notWhiteSpaceSibling = notWhiteSpaceSibling.getPrevSibling()) instanceof PsiWhiteSpace) {
        }
        return notWhiteSpaceSibling;
    }

    public static boolean lookupStringShouldBeProcessed(@Nullable String string, @NotNull CompletionResultSet resultSet) {
        if (resultSet == null) {
            RubyCompletionProviderUtil.$$$reportNull$$$0(4);
        }
        return string != null && resultSet.getPrefixMatcher().prefixMatches(string);
    }

    public static Predicate<String> lookupStringPrefixFilter(@NotNull CompletionResultSet resultSet) {
        if (resultSet == null) {
            RubyCompletionProviderUtil.$$$reportNull$$$0(5);
        }
        return string -> RubyCompletionProviderUtil.lookupStringShouldBeProcessed(string, resultSet);
    }

    public static Predicate<Symbol> symbolNamePrefixFilter(@NotNull CompletionResultSet resultSet) {
        if (resultSet == null) {
            RubyCompletionProviderUtil.$$$reportNull$$$0(6);
        }
        return symbol -> RubyCompletionProviderUtil.lookupStringShouldBeProcessed(symbol.getName(), resultSet);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokens";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultSet";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/completion/RubyCompletionProviderUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addKeywords";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getPrevNotWhitespaceSibling";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "lookupStringShouldBeProcessed";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "lookupStringPrefixFilter";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "symbolNamePrefixFilter";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

