/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.LegacyCompletionContributor;
import com.intellij.lang.Language;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.position.FilterPattern;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.exception.RubyExceptionCompletionFilter;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.globalVariable.RubyGlobalVariablesCompletionProvider;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.keyword.RubyAttrCompletionProvider;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.keyword.RubyCommonKeywordCompletionFilter;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.keyword.RubyCommonKeywordsCompletionProvider;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.keyword.RubyDoCompletionFilter;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.keyword.RubyDoCompletionProvider;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.keyword.RubyDoKeywordAvailableCompletionFilter;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.keyword.RubyElseCompletionProvider;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.keyword.RubyElseElsifCompletionFilter;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.keyword.RubyElseElsifCompletionProvider;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.keyword.RubyEndCompletionFilter;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.keyword.RubyEndCompletionProvider;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.keyword.RubyEnsureCompletionProvider;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.keyword.RubyForInCompletionFilter;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.keyword.RubyForInCompletionProvider;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.keyword.RubyKeywordInCaseCompletionFilter;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.keyword.RubyKeywordInCaseCompletionProvider;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.keyword.RubyKeywordInCycleCompletionFilter;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.keyword.RubyKeywordInCyclesCompletionProvider;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.keyword.RubyModKeywordAndOrCompletionFilter;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.keyword.RubyModKeywordAndOrCompletionProvider;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.keyword.RubyOrderedKeywordCompletionFilter;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.keyword.RubyPseudoConstantsCompletionProvider;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.keyword.RubyRescueCompletionProvider;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.keyword.RubyRetryCompletionFilter;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.keyword.RubyRetryCompletionProvider;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.keyword.RubyThenCompletionFilter;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.keyword.RubyThenCompletionProvider;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.method.RubyMethodNameCompletionProvider;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.namedArguments.RubyNamedArgumentCompletionFilter;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.namedArguments.RubyNamedArgumentCompletionProvider;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.smalltalk.RubySmallTalkCompletion;
import org.jetbrains.plugins.ruby.ruby.codeInsight.references.PsiReferenceWithCompletion;
import org.jetbrains.plugins.ruby.ruby.lang.RubyLanguage;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyCommonPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.RSymbol;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RStringLiteral;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RBeginEndBlockStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RFieldHolder;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RFName;
import org.jetbrains.plugins.ruby.statistic.RubyTrackedCompletionProviderStatCollector;

public final class RubyCompletionContributor
extends CompletionContributor
implements DumbAware,
RubyTokenTypes {
    private static final PsiElementPattern.Capture<PsiElement> AFTER_QUALIFIED_REFERENCE_PATTERN = (PsiElementPattern.Capture)PlatformPatterns.psiElement().afterLeaf((ElementPattern)PlatformPatterns.psiElement().andOr(new ElementPattern[]{PlatformPatterns.psiElement().withText("."), PlatformPatterns.psiElement().withText("::")}));
    private static final FilterPattern KEYWORD_AVAILABLE_FILTER_PATTERN = new FilterPattern((ElementFilter)new RubyDoKeywordAvailableCompletionFilter());
    private static final FilterPattern DO_KEYWORD_AVAILABLE_FILTER_PATTERN = new FilterPattern((ElementFilter)new RubyDoKeywordAvailableCompletionFilter());
    private static final FilterPattern MOD_KEYWORD_AND_OR_FILTER_PATTERN = new FilterPattern((ElementFilter)new RubyModKeywordAndOrCompletionFilter());
    private static final FilterPattern COMMON_KEYWORD_FILTER_PATTERN = new FilterPattern((ElementFilter)new RubyCommonKeywordCompletionFilter());
    private static final FilterPattern KEYWORD_IN_CYCLE_FILTER_PATTERN = new FilterPattern((ElementFilter)new RubyKeywordInCycleCompletionFilter());
    private static final FilterPattern KEYWORDS_IN_CASE_FILTER_PATTERN = new FilterPattern((ElementFilter)new RubyKeywordInCaseCompletionFilter());
    private static final FilterPattern ELSE_ELSIF_FILTER_PATTERN = new FilterPattern((ElementFilter)new RubyElseElsifCompletionFilter());
    private static final FilterPattern FOR_IN_FILTER_PATTERN = new FilterPattern((ElementFilter)new RubyForInCompletionFilter());
    private static final FilterPattern THEN_FILTER_PATTERN = new FilterPattern((ElementFilter)new RubyThenCompletionFilter());
    private static final FilterPattern DO_FILTER_PATTERN = new FilterPattern((ElementFilter)new RubyDoCompletionFilter());
    private static final FilterPattern END_FILTER_PATTERN = new FilterPattern((ElementFilter)new RubyEndCompletionFilter());
    private static final FilterPattern RETRY_FILTER_PATTERN = new FilterPattern((ElementFilter)new RubyRetryCompletionFilter());
    private static final FilterPattern NAMED_ARGUMENT_FILTER_PATTERN = new FilterPattern((ElementFilter)new RubyNamedArgumentCompletionFilter());

    public RubyCompletionContributor() {
        this.addBasicContributors();
        this.addSmartContributors();
    }

    private void addBasicContributors() {
        this.addElseCompletion();
        this.addEnsureCompletion();
        this.addRescueCompletion();
        this.addSmallTalkCompletion();
        this.addThenCompletion();
        this.addRetryCompletion();
        this.addForInCompletion();
        this.addKeywordsInCaseCompletion();
        this.addGlobalVariablesCompletion();
        this.addEndCompletion();
        this.addElseElsifCompletion();
        this.addKeywordsInCyclesCompletion();
        this.addPseudoConstantsCompletion();
        this.addModKeywordAndOrCompletion();
        this.addDoCompletion();
        this.addCommonKeywordCompletion();
        this.addNamedArgumentsCompletion();
        this.addAttrCompletion();
    }

    private void addSmartContributors() {
        this.addMethodNameCompletion();
    }

    public void beforeCompletion(@NotNull CompletionInitializationContext context) {
        char c;
        CharSequence text;
        int offset;
        PsiFile file;
        if (context == null) {
            RubyCompletionContributor.$$$reportNull$$$0(0);
        }
        if ((file = context.getFile()) instanceof RFile && (offset = context.getStartOffset()) < (text = context.getEditor().getDocument().getCharsSequence()).length() && (Character.isLetterOrDigit(c = text.charAt(offset)) || c == '_')) {
            context.setDummyIdentifier("IntellijIdeaRulezzz");
        }
    }

    public boolean invokeAutoPopup(@NotNull PsiElement position, char typeChar) {
        if (position == null) {
            RubyCompletionContributor.$$$reportNull$$$0(1);
        }
        if (StringUtil.containsChar((String)"$@:", (char)typeChar)) {
            return true;
        }
        return super.invokeAutoPopup(position, typeChar);
    }

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet originalResult) {
        PsiElement element;
        if (parameters == null) {
            RubyCompletionContributor.$$$reportNull$$$0(2);
        }
        if (originalResult == null) {
            RubyCompletionContributor.$$$reportNull$$$0(3);
        }
        if (RubyPsiUtil.isPsiAfterNumberLiteral(element = parameters.getPosition())) {
            return;
        }
        if (RubyPsiUtil.isInArgumentDeclaration(element)) {
            return;
        }
        if (RubyExceptionCompletionFilter.isInRescue(element) && !RubyExceptionCompletionFilter.isInRescueBody(element)) {
            return;
        }
        super.fillCompletionVariants(parameters, originalResult);
        LegacyCompletionContributor.processReferences((CompletionParameters)parameters, (CompletionResultSet)originalResult, (reference, result) -> {
            if (reference instanceof PsiReferenceWithCompletion) {
                PsiReferenceWithCompletion rwc = (PsiReferenceWithCompletion)reference;
                long startTime = System.currentTimeMillis();
                rwc.addCompletions(parameters, new ProcessingContext(), (CompletionResultSet)result);
                RubyTrackedCompletionProviderStatCollector.logReferenceWithCompletionFinished((Language)RubyLanguage.INSTANCE, rwc, startTime);
            }
        });
    }

    private void addCommonKeywordCompletion() {
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withLanguage((Language)RubyLanguage.INSTANCE)).and((ElementPattern)KEYWORD_AVAILABLE_FILTER_PATTERN)).andNot(AFTER_QUALIFIED_REFERENCE_PATTERN)).andNot((ElementPattern)MOD_KEYWORD_AND_OR_FILTER_PATTERN)).and((ElementPattern)COMMON_KEYWORD_FILTER_PATTERN), RubyCommonKeywordsCompletionProvider.INSTANCE);
    }

    private void addPseudoConstantsCompletion() {
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withLanguage((Language)RubyLanguage.INSTANCE)).and((ElementPattern)KEYWORD_AVAILABLE_FILTER_PATTERN)).andNot(AFTER_QUALIFIED_REFERENCE_PATTERN)).and((ElementPattern)COMMON_KEYWORD_FILTER_PATTERN), RubyPseudoConstantsCompletionProvider.INSTANCE);
    }

    private void addModKeywordAndOrCompletion() {
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withLanguage((Language)RubyLanguage.INSTANCE)).and((ElementPattern)KEYWORD_AVAILABLE_FILTER_PATTERN)).andNot(AFTER_QUALIFIED_REFERENCE_PATTERN)).and((ElementPattern)MOD_KEYWORD_AND_OR_FILTER_PATTERN), RubyModKeywordAndOrCompletionProvider.INSTANCE);
    }

    private void addSmallTalkCompletion() {
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withLanguage((Language)RubyLanguage.INSTANCE), RubySmallTalkCompletion.INSTANCE);
    }

    private void addRescueCompletion() {
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withLanguage((Language)RubyLanguage.INSTANCE)).and((ElementPattern)KEYWORD_AVAILABLE_FILTER_PATTERN)).andNot(AFTER_QUALIFIED_REFERENCE_PATTERN)).andNot((ElementPattern)MOD_KEYWORD_AND_OR_FILTER_PATTERN)).and((ElementPattern)new FilterPattern((ElementFilter)new RubyOrderedKeywordCompletionFilter(RBeginEndBlockStatement.class, RubyCommonPsiUtil.RESCUE_CONTAINERS, TokenSet.create((IElementType[])new IElementType[0]), TokenSet.create((IElementType[])new IElementType[]{kELSE, kENSURE}), true))), RubyRescueCompletionProvider.INSTANCE);
    }

    private void addElseCompletion() {
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withLanguage((Language)RubyLanguage.INSTANCE)).and((ElementPattern)KEYWORD_AVAILABLE_FILTER_PATTERN)).andNot(AFTER_QUALIFIED_REFERENCE_PATTERN)).andNot((ElementPattern)MOD_KEYWORD_AND_OR_FILTER_PATTERN)).and((ElementPattern)new FilterPattern((ElementFilter)new RubyOrderedKeywordCompletionFilter(RBeginEndBlockStatement.class, RubyCommonPsiUtil.RESCUE_CONTAINERS, TokenSet.create((IElementType[])new IElementType[]{kRESCUE, kELSE}), TokenSet.create((IElementType[])new IElementType[]{kELSE, kENSURE}), false))), RubyElseCompletionProvider.INSTANCE);
    }

    private void addEnsureCompletion() {
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withLanguage((Language)RubyLanguage.INSTANCE)).and((ElementPattern)KEYWORD_AVAILABLE_FILTER_PATTERN)).andNot(AFTER_QUALIFIED_REFERENCE_PATTERN)).andNot((ElementPattern)MOD_KEYWORD_AND_OR_FILTER_PATTERN)).and((ElementPattern)new FilterPattern((ElementFilter)new RubyOrderedKeywordCompletionFilter(RBeginEndBlockStatement.class, RubyCommonPsiUtil.RESCUE_CONTAINERS, TokenSet.create((IElementType[])new IElementType[]{kRESCUE, kELSE, kENSURE}), TokenSet.create((IElementType[])new IElementType[]{kENSURE}), true))), RubyEnsureCompletionProvider.INSTANCE);
    }

    private void addKeywordsInCyclesCompletion() {
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withLanguage((Language)RubyLanguage.INSTANCE)).and((ElementPattern)KEYWORD_AVAILABLE_FILTER_PATTERN)).andNot(AFTER_QUALIFIED_REFERENCE_PATTERN)).andNot((ElementPattern)MOD_KEYWORD_AND_OR_FILTER_PATTERN)).and((ElementPattern)KEYWORD_IN_CYCLE_FILTER_PATTERN), RubyKeywordInCyclesCompletionProvider.INSTANCE);
    }

    private void addKeywordsInCaseCompletion() {
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withLanguage((Language)RubyLanguage.INSTANCE)).and((ElementPattern)KEYWORD_AVAILABLE_FILTER_PATTERN)).andNot(AFTER_QUALIFIED_REFERENCE_PATTERN)).andNot((ElementPattern)MOD_KEYWORD_AND_OR_FILTER_PATTERN)).and((ElementPattern)KEYWORDS_IN_CASE_FILTER_PATTERN), RubyKeywordInCaseCompletionProvider.INSTANCE);
    }

    private void addElseElsifCompletion() {
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withLanguage((Language)RubyLanguage.INSTANCE)).and((ElementPattern)KEYWORD_AVAILABLE_FILTER_PATTERN)).andNot(AFTER_QUALIFIED_REFERENCE_PATTERN)).and((ElementPattern)ELSE_ELSIF_FILTER_PATTERN), RubyElseElsifCompletionProvider.INSTANCE);
    }

    private void addForInCompletion() {
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withLanguage((Language)RubyLanguage.INSTANCE)).and((ElementPattern)KEYWORD_AVAILABLE_FILTER_PATTERN)).andNot(AFTER_QUALIFIED_REFERENCE_PATTERN)).and((ElementPattern)FOR_IN_FILTER_PATTERN), RubyForInCompletionProvider.INSTANCE);
    }

    private void addRetryCompletion() {
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withLanguage((Language)RubyLanguage.INSTANCE)).and((ElementPattern)KEYWORD_AVAILABLE_FILTER_PATTERN)).andNot(AFTER_QUALIFIED_REFERENCE_PATTERN)).and((ElementPattern)RETRY_FILTER_PATTERN), RubyRetryCompletionProvider.INSTANCE);
    }

    private void addThenCompletion() {
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withLanguage((Language)RubyLanguage.INSTANCE)).and((ElementPattern)KEYWORD_AVAILABLE_FILTER_PATTERN)).andNot(AFTER_QUALIFIED_REFERENCE_PATTERN)).and((ElementPattern)THEN_FILTER_PATTERN), RubyThenCompletionProvider.INSTANCE);
    }

    private void addDoCompletion() {
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withLanguage((Language)RubyLanguage.INSTANCE)).and((ElementPattern)DO_KEYWORD_AVAILABLE_FILTER_PATTERN)).andNot(AFTER_QUALIFIED_REFERENCE_PATTERN)).and((ElementPattern)DO_FILTER_PATTERN), RubyDoCompletionProvider.INSTANCE);
    }

    private void addEndCompletion() {
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withLanguage((Language)RubyLanguage.INSTANCE)).and((ElementPattern)KEYWORD_AVAILABLE_FILTER_PATTERN)).andNot(AFTER_QUALIFIED_REFERENCE_PATTERN)).and((ElementPattern)END_FILTER_PATTERN), RubyEndCompletionProvider.INSTANCE);
    }

    private void addAttrCompletion() {
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withLanguage((Language)RubyLanguage.INSTANCE)).inside(RFieldHolder.class)).andOr(new ElementPattern[]{PlatformPatterns.psiElement().inside(RStringLiteral.class), PlatformPatterns.psiElement().afterLeaf(new String[]{":"})}), RubyAttrCompletionProvider.INSTANCE);
    }

    private void addMethodNameCompletion() {
        this.extend(CompletionType.SMART, StandardPatterns.or((ElementPattern[])new ElementPattern[]{((PsiElementPattern.Capture)PlatformPatterns.psiElement().withLanguage((Language)RubyLanguage.INSTANCE)).afterLeaf(new String[]{"def"}), ((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withLanguage((Language)RubyLanguage.INSTANCE)).inside(RFName.class)).andNot((ElementPattern)PlatformPatterns.psiElement().inside(RSymbol.class))}), RubyMethodNameCompletionProvider.INSTANCE);
    }

    private void addGlobalVariablesCompletion() {
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withLanguage((Language)RubyLanguage.INSTANCE)).inside(RExpression.class), RubyGlobalVariablesCompletionProvider.INSTANCE);
    }

    private void addNamedArgumentsCompletion() {
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withLanguage((Language)RubyLanguage.INSTANCE)).and((ElementPattern)NAMED_ARGUMENT_FILTER_PATTERN), RubyNamedArgumentCompletionProvider.INSTANCE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalResult";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/completion/RubyCompletionContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeCompletion";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "invokeAutoPopup";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "fillCompletionVariants";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

