/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Predicates;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.MultiMap;
import icons.RubyIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rdoc.RDocSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.CompletionResolveContext;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.ReferenceCompletionUtilCore;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.RubyCompletionGrouping;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.RubyLookupElement;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.RubyPsiLookupElement;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.ScopeUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.ScopeVariable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.TypeSet;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Types;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.FieldSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.PsiElementSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.util.ResolveAncestor;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.util.SymbolHierarchy;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.ClassModuleSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.SingletonClassSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.Access;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.ContextImpl;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RSymbolType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeFactory;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeUtilCore;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.impl.RDelegatedType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.impl.REmptyType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.impl.RModuleType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.controlStructures.classes.RSuperClassNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.methodCall.RCallNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.indexes.RubyAllInstanceVariablesIndex;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyAttrCallTypeImpl;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallTypesCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyIncludeExtendCallTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RColonReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RTopConstReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RConstant;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.fields.RField;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.fields.RInstanceVariable;
import org.jetbrains.plugins.ruby.ruby.presentation.RContainerPresentationUtil;
import org.jetbrains.plugins.ruby.ruby.presentation.RFieldPresentationUtil;
import org.jetbrains.plugins.ruby.ruby.presentation.SymbolLookupUtil;

public final class ReferenceCompletionUtil {
    private ReferenceCompletionUtil() {
    }

    public static void doWithReferenceCompletion(@Nullable PsiElement psiElement, @NotNull Runnable runnable) {
        if (runnable == null) {
            ReferenceCompletionUtil.$$$reportNull$$$0(0);
        }
        ReferenceCompletionUtilCore.REFERENCE_BEING_COMPLETED.set((UserDataHolder)psiElement, (Object)Boolean.TRUE);
        try {
            runnable.run();
        }
        finally {
            ReferenceCompletionUtilCore.REFERENCE_BEING_COMPLETED.set((UserDataHolder)psiElement, null);
        }
    }

    public static void addLookupItems(PsiElement element, @NotNull Predicate<Symbol> filter, @NotNull Consumer<? super LookupElement> elementConsumer) {
        RType type;
        if (filter == null) {
            ReferenceCompletionUtil.$$$reportNull$$$0(1);
        }
        if (elementConsumer == null) {
            ReferenceCompletionUtil.$$$reportNull$$$0(2);
        }
        if ((type = RTypeUtil.getTypeForSelf(element)) != REmptyType.INSTANCE) {
            boolean showModulesFirst = element instanceof RColonReference || element instanceof RTopConstReference;
            ReferenceCompletionUtil.addLookupItemsByType(type, filter, null, showModulesFirst, element, elementConsumer);
        }
        ReferenceCompletionUtil.addScopeVariables(element, filter, elementConsumer);
    }

    private static void addScopeVariables(PsiElement element, @NotNull Predicate<Symbol> filter, @NotNull Consumer<? super LookupElement> elementConsumer) {
        Icon icon;
        if (filter == null) {
            ReferenceCompletionUtil.$$$reportNull$$$0(3);
        }
        if (elementConsumer == null) {
            ReferenceCompletionUtil.$$$reportNull$$$0(4);
        }
        element = CompletionUtil.getOriginalOrSelf((PsiElement)element);
        HashSet<String> names = new HashSet<String>();
        for (ScopeVariable scopeVariable : ScopeUtil.collectScopeVariables(element)) {
            String newName;
            Symbol variableSymbol;
            if (element == scopeVariable.getFirstDeclaration() || Types.FIELDS.contains((variableSymbol = SymbolUtil.createSymbolByScopeVariable(scopeVariable, newName = scopeVariable.getName(), element.getProject())).getType()) || !filter.test(variableSymbol) || names.contains(newName)) continue;
            names.add(newName);
            Type type = scopeVariable.getType();
            icon = type == Type.METHOD_PARAMETER ? AllIcons.Nodes.Parameter : (type == Type.LOCAL_VARIABLE ? AllIcons.Nodes.Variable : (type == Type.INSTANCE_FIELD ? RubyIcons.Ruby.Nodes.Variable : AllIcons.Nodes.StaticMark));
            String typeText = type.getPresentableName();
            RubyCompletionGrouping grouping = SymbolLookupUtil.determineGroupingByType(type);
            RubyPsiLookupElement lookupElement = new RubyPsiLookupElement(newName, null, typeText, (PsiElement)scopeVariable.getFirstDeclaration(), true, icon);
            int groupingValue = (grouping != null ? grouping : RubyCompletionGrouping.GENERAL).getValue();
            elementConsumer.consume((Object)PrioritizedLookupElement.withPriority((LookupElement)lookupElement, (double)groupingValue));
        }
        for (PsiElement variable : ScopeUtil.collectLocalVariables(element)) {
            PsiNamedElement namedElement;
            String newName;
            if (!(variable instanceof PsiNamedElement) || (newName = (namedElement = (PsiNamedElement)variable).getName()) == null || names.contains(newName) || namedElement.getUserData(ReferenceCompletionUtilCore.REFERENCE_BEING_COMPLETED) != null) continue;
            names.add(newName);
            icon = AllIcons.Nodes.Variable;
            String typeText = Type.LOCAL_VARIABLE.getPresentableName();
            RubyCompletionGrouping grouping = RubyCompletionGrouping.LOCAL_OR_PARAMETER;
            RubyPsiLookupElement lookupElement = new RubyPsiLookupElement(newName, null, typeText, (PsiElement)namedElement, true, icon);
            elementConsumer.consume((Object)PrioritizedLookupElement.withPriority((LookupElement)lookupElement, (double)grouping.getValue()));
        }
    }

    public static void addLookupItemsByType(@NotNull RType type, @NotNull Predicate<Symbol> filter, @Nullable String prefixText, boolean showModulesFirst, @NotNull PsiElement position, @NotNull Consumer<? super LookupElement> lookupConsumer) {
        if (type == null) {
            ReferenceCompletionUtil.$$$reportNull$$$0(5);
        }
        if (filter == null) {
            ReferenceCompletionUtil.$$$reportNull$$$0(6);
        }
        if (position == null) {
            ReferenceCompletionUtil.$$$reportNull$$$0(7);
        }
        if (lookupConsumer == null) {
            ReferenceCompletionUtil.$$$reportNull$$$0(8);
        }
        Symbol birthTypeSymbol = RTypeUtilCore.getBirthTypeSymbol((RType)type);
        Consumer symbolConsumer = symbol -> {
            Symbol parentSymbol = symbol.getParentSymbol();
            Symbol parentSymbolNormalized = parentSymbol instanceof SingletonClassSymbol ? ((SingletonClassSymbol)parentSymbol).getOriginSymbol() : parentSymbol;
            Symbol birthTypeSymbolNormalized = birthTypeSymbol instanceof SingletonClassSymbol ? ((SingletonClassSymbol)birthTypeSymbol).getOriginSymbol() : birthTypeSymbol;
            boolean showBold = type.isTyped() && !Types.MODULE_OR_CLASS.contains(symbol.getType()) && parentSymbolNormalized != null && parentSymbolNormalized.equals(birthTypeSymbolNormalized);
            LookupElement lookupElement = SymbolLookupUtil.createLookupItemBySymbol(symbol, birthTypeSymbol, type, Objects.requireNonNull(symbol.getName()), showBold, showModulesFirst, true);
            if (lookupElement != null) {
                lookupConsumer.consume((Object)lookupElement);
            }
        };
        ReferenceCompletionUtil.addCompletionSymbols(type, filter, prefixText, position, (Consumer<? super Symbol>)symbolConsumer);
    }

    public static void addCompletionSymbols(@NotNull RType type, @NotNull Predicate<Symbol> filter, @Nullable String prefixText, @NotNull PsiElement position, @NotNull Consumer<? super Symbol> consumer) {
        if (type == null) {
            ReferenceCompletionUtil.$$$reportNull$$$0(9);
        }
        if (filter == null) {
            ReferenceCompletionUtil.$$$reportNull$$$0(10);
        }
        if (position == null) {
            ReferenceCompletionUtil.$$$reportNull$$$0(11);
        }
        if (consumer == null) {
            ReferenceCompletionUtil.$$$reportNull$$$0(12);
        }
        boolean colonLookup = RTypeUtil.getBirthTypeAccess(type) == Access.CLASS;
        Symbol.Filter classModuleConstantFilter = Symbol.Filter.byTypes((TypeSet)SymbolUtil.getClassModuleConstantTypes());
        Predicate<Symbol> commonFilter = ReferenceCompletionUtil.createOverriddenFilter(type).and(filter);
        Predicate<Symbol> methodLookupFilter = colonLookup ? classModuleConstantFilter.negate().and(commonFilter) : commonFilter;
        HashSet processedSymbols = new HashSet();
        HashSet processedConstantSymbols = new HashSet();
        HashSet processedMethodSymbols = new HashSet();
        ArrayList docSymbols = new ArrayList();
        HashSet psiElementsProcessedSymbols = new HashSet();
        java.util.function.Consumer<Symbol> processor = symbol -> {
            String symbolName = symbol.getName();
            if (symbolName == null) {
                return;
            }
            if (!processedSymbols.add(symbol)) {
                return;
            }
            if (symbol.getType() == Type.CONSTANT && !processedConstantSymbols.add(symbolName)) {
                return;
            }
            if (SymbolUtil.getMethodTypes().contains(symbol.getType()) && !processedMethodSymbols.add(symbolName)) {
                return;
            }
            if (symbol instanceof RDocSymbol) {
                docSymbols.add(symbol);
            } else {
                if (symbol instanceof PsiElementSymbol) {
                    psiElementsProcessedSymbols.add(Trinity.create((Object)symbolName, (Object)symbol.getType(), (Object)symbol.getParentSymbol()));
                }
                consumer.consume(symbol);
            }
        };
        if (prefixText != null) {
            type.processMembersForPrefix(prefixText, methodLookupFilter, position, processor);
        } else {
            type.processMembers(methodLookupFilter, position, processor);
        }
        if (position instanceof RConstant) {
            RConstant rConst = (RConstant)position;
            SymbolUtil.processMembersInNesting((RPsiElement)rConst, SymbolUtil.createSymbolProcessor((Predicate<? super Symbol>)classModuleConstantFilter.and(commonFilter), processor));
        }
        if (colonLookup && type instanceof RModuleType) {
            RModuleType rModule = (RModuleType)type;
            rModule.getGenericType().processMembers(classModuleConstantFilter.and(commonFilter), position, processor);
        }
        for (Symbol dosSymbol : docSymbols) {
            if (psiElementsProcessedSymbols.contains(Trinity.create((Object)dosSymbol.getName(), (Object)dosSymbol.getType(), (Object)dosSymbol.getParentSymbol()))) continue;
            consumer.consume((Object)dosSymbol);
        }
    }

    @Nullable
    public static CompletionResolveContext getContextType(@NotNull PsiElement element) {
        if (element == null) {
            ReferenceCompletionUtil.$$$reportNull$$$0(13);
        }
        if (RSuperClassNavigator.getByPsiElement((PsiElement)element) != null) {
            return CompletionResolveContext.CLASS_OR_MODULE_REQUIRED;
        }
        RCall rCall = RCallNavigator.getByRArgument((PsiElement)element);
        if (rCall != null) {
            RubyCallType type = rCall.getCallType();
            if (type == RubyIncludeExtendCallTypes.INCLUDE_CALL || type == RubyIncludeExtendCallTypes.EXTEND_CALL) {
                return CompletionResolveContext.MODULE_REQUIRED;
            }
            if (type == RubyCallTypesCore.RAISE_CALL || type == RubyCallTypesCore.FAIL_CALL) {
                return CompletionResolveContext.EXCEPTION_REQUIRED;
            }
        }
        return null;
    }

    public static void collectCompletionForAttrArgs(@NotNull PsiElement positionElement, @NotNull Consumer<? super LookupElement> elementConsumer) {
        if (positionElement == null) {
            ReferenceCompletionUtil.$$$reportNull$$$0(14);
        }
        if (elementConsumer == null) {
            ReferenceCompletionUtil.$$$reportNull$$$0(15);
        }
        Predicate filter = Symbol.Filter.byTypes((TypeSet)Types.FIELDS).or(Symbol.Filter.byTypes((TypeSet)Types.ATTR_METHODS).and(symbol -> symbol instanceof RDocSymbol));
        BiConsumer<Symbol, Boolean> symbolConsumer = (fieldSymbol, bold) -> {
            String fieldName = fieldSymbol.getName();
            if (fieldName == null) {
                return;
            }
            fieldName = StringUtil.trimEnd((String)fieldName, (char)'=');
            PsiElement declaration = fieldSymbol.getPsiElement();
            if (declaration instanceof RField) {
                RField field = (RField)declaration;
                RubyCompletionGrouping group = ReferenceCompletionUtil.getGroupingByFieldSymbol(fieldSymbol, bold);
                LookupElement lookupElement = PrioritizedLookupElement.withPriority((LookupElement)new RubyLookupElement(fieldName, null, null, (boolean)bold, RFieldPresentationUtil.getIcon((RField)field), null), (double)group.getValue());
                elementConsumer.consume((Object)lookupElement);
            } else {
                elementConsumer.consume((Object)new RubyLookupElement(fieldName, null, null, false, RubyIcons.Ruby.Nodes.Variable, null));
            }
        };
        ReferenceCompletionUtil.collectFieldsInfo(positionElement, filter, symbolConsumer, false);
    }

    public static void collectFieldsCompletion(@NotNull PsiElement positionElement, @NotNull Consumer<? super LookupElement> elementConsumer) {
        if (positionElement == null) {
            ReferenceCompletionUtil.$$$reportNull$$$0(16);
        }
        if (elementConsumer == null) {
            ReferenceCompletionUtil.$$$reportNull$$$0(17);
        }
        Symbol.Filter filter = Symbol.Filter.byTypes((TypeSet)Types.FIELDS_OR_ATTRS);
        BiConsumer<Symbol, Boolean> symbolConsumer = (fieldSymbol, bold) -> {
            String fieldName = fieldSymbol.getName();
            if (fieldName == null) {
                return;
            }
            fieldName = StringUtil.trimEnd((String)fieldName, (char)'=');
            Type type = fieldSymbol.getType();
            String typeText = RContainerPresentationUtil.getPresentableSymbolName((Symbol)fieldSymbol.getParentSymbol(), (PsiElement)positionElement);
            String prefix = Types.CLASS_FIELD_OR_ATTRS.contains(fieldSymbol.getType()) ? "@@" : "@";
            RubyCompletionGrouping grouping = ReferenceCompletionUtil.getGroupingByFieldSymbol(fieldSymbol, bold);
            RubyLookupElement element = new RubyLookupElement(prefix + fieldName, null, typeText, (boolean)bold, SymbolLookupUtil.getLookupItemIcon(type, null), null);
            elementConsumer.consume((Object)PrioritizedLookupElement.withPriority((LookupElement)element, (double)grouping.getValue()));
        };
        ReferenceCompletionUtil.collectFieldsInfo(positionElement, (Predicate<Symbol>)filter, symbolConsumer, true);
    }

    private static void collectFieldsInfo(@NotNull PsiElement positionElement, @NotNull Predicate<Symbol> filter, @NotNull BiConsumer<? super Symbol, ? super Boolean> symbolConsumer, boolean excludeSameUndefFields) {
        if (positionElement == null) {
            ReferenceCompletionUtil.$$$reportNull$$$0(18);
        }
        if (filter == null) {
            ReferenceCompletionUtil.$$$reportNull$$$0(19);
        }
        if (symbolConsumer == null) {
            ReferenceCompletionUtil.$$$reportNull$$$0(20);
        }
        String psiName = positionElement instanceof PsiNamedElement ? StringUtil.trimEnd((String)Objects.requireNonNull(((PsiNamedElement)positionElement).getName()), (String)"IntellijIdeaRulezzz") : null;
        ContextImpl context = ContextImpl.getContext(positionElement);
        Symbol symbol = SymbolUtil.getSymbolRepresentingContext(SymbolUtil.getScopeContextWithCaching(positionElement), context);
        if (symbol == null) {
            return;
        }
        RType type = RTypeFactory.createTypeBySymbol(symbol);
        Consumer adapter = fieldSymbol -> symbolConsumer.accept((Symbol)fieldSymbol, (Boolean)symbol.equals(fieldSymbol.getParentSymbol()));
        ReferenceCompletionUtil.addCompletionSymbols(type, filter, null, positionElement, (Consumer<? super Symbol>)adapter);
        Project project = symbol.getProject();
        GlobalSearchScope searchScope = positionElement.getResolveScope();
        for (ResolveAncestor ancestor : SymbolHierarchy.getAncestorsCaching(symbol, positionElement)) {
            Symbol symbolInHierarchy = ancestor.getSymbol();
            FQN fqn = symbolInHierarchy.getFQNWithNesting();
            Collection elements = (Collection)ReadAction.compute(() -> ReferenceCompletionUtil.lambda$collectFieldsInfo$6(project, (SearchScope)searchScope, fqn));
            for (RPsiElement element : elements) {
                RPossibleCall call;
                Object object;
                if (element instanceof RInstanceVariable) {
                    FieldSymbol fieldSymbol2;
                    RInstanceVariable variable = (RInstanceVariable)element;
                    String name = variable.getName();
                    if (psiName != null && excludeSameUndefFields && psiName.equals(name) || !filter.test((Symbol)(fieldSymbol2 = new FieldSymbol(variable, name, symbolInHierarchy)))) continue;
                    adapter.consume((Object)fieldSymbol2);
                    continue;
                }
                if (!(element instanceof RPossibleCall) || !((object = (call = (RPossibleCall)element).getCallType()) instanceof RubyAttrCallTypeImpl)) continue;
                RubyAttrCallTypeImpl callType = (RubyAttrCallTypeImpl)((Object)object);
                object = ((List)call.getData(new RubyCallType[]{callType})).iterator();
                while (object.hasNext()) {
                    PsiElementSymbol<RPossibleCall> fieldSymbol3;
                    Pair pair = (Pair)object.next();
                    String name = (String)pair.getFirst();
                    if (name.isBlank() || psiName != null && excludeSameUndefFields && psiName.equals(name) || !filter.test((Symbol)(fieldSymbol3 = new PsiElementSymbol<RPossibleCall>(call, name, Type.INSTANCE_FIELD, symbolInHierarchy)))) continue;
                    adapter.consume(fieldSymbol3);
                }
            }
        }
    }

    @Nullable
    private static String getPresentableName(@NotNull Symbol symbol) {
        String name;
        if (symbol == null) {
            ReferenceCompletionUtil.$$$reportNull$$$0(21);
        }
        if ((name = symbol.getName()) == null) {
            return null;
        }
        if (symbol.getType() == Type.INSTANCE_FIELD) {
            return "@" + name;
        }
        if (symbol.getType() == Type.CLASS_FIELD) {
            return "@@" + name;
        }
        return name;
    }

    @NotNull
    private static Predicate<Symbol> createOverriddenFilter(@NotNull RType type) {
        if (type == null) {
            ReferenceCompletionUtil.$$$reportNull$$$0(22);
        }
        RType originalType = type;
        while (originalType instanceof RDelegatedType) {
            originalType = ((RDelegatedType)originalType).getOriginalType();
        }
        if (ObjectUtils.doIfCast((Object)originalType, RSymbolType.class, RSymbolType::getSymbol) instanceof ClassModuleSymbol) {
            return new Predicate<Symbol>(){
                @NotNull
                private final MultiMap<String, Type> myVisitedNames = MultiMap.createSet();

                @Override
                public boolean test(Symbol symbol) {
                    String name = ReferenceCompletionUtil.getPresentableName(symbol);
                    if (this.myVisitedNames.get((Object)name).contains(symbol.getType())) {
                        return false;
                    }
                    this.myVisitedNames.putValue((Object)name, (Object)symbol.getType());
                    return true;
                }
            };
        }
        Predicate predicate = Predicates.alwaysTrue();
        if (predicate == null) {
            ReferenceCompletionUtil.$$$reportNull$$$0(23);
        }
        return predicate;
    }

    @NotNull
    private static RubyCompletionGrouping getGroupingByFieldSymbol(@NotNull Symbol fieldSymbol, boolean bold) {
        if (fieldSymbol == null) {
            ReferenceCompletionUtil.$$$reportNull$$$0(24);
        }
        String parentFQN = (String)ObjectUtils.doIfNotNull((Object)fieldSymbol.getParentSymbol(), s -> s.getFQNWithNesting().getFullPath());
        if (!bold && ("Kernel".equals(parentFQN) || "Object".equals(parentFQN))) {
            RubyCompletionGrouping rubyCompletionGrouping = RubyCompletionGrouping.KERNEL_OR_OBJECT_CHILDREN;
            if (rubyCompletionGrouping == null) {
                ReferenceCompletionUtil.$$$reportNull$$$0(25);
            }
            return rubyCompletionGrouping;
        }
        if (Types.CLASS_FIELD_OR_ATTRS.contains(fieldSymbol.getType())) {
            RubyCompletionGrouping rubyCompletionGrouping = bold ? RubyCompletionGrouping.CLASS_FIELDS_BOLD : RubyCompletionGrouping.CLASS_FIELDS;
            if (rubyCompletionGrouping == null) {
                ReferenceCompletionUtil.$$$reportNull$$$0(26);
            }
            return rubyCompletionGrouping;
        }
        RubyCompletionGrouping rubyCompletionGrouping = bold ? RubyCompletionGrouping.INSTANCE_FIELDS_BOLD : RubyCompletionGrouping.INSTANCE_FIELDS;
        if (rubyCompletionGrouping == null) {
            ReferenceCompletionUtil.$$$reportNull$$$0(27);
        }
        return rubyCompletionGrouping;
    }

    private static /* synthetic */ Collection lambda$collectFieldsInfo$6(Project project, SearchScope searchScope, FQN fqn) throws RuntimeException {
        return RubyAllInstanceVariablesIndex.getInstance().getElements(project, searchScope, fqn);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 23, 25, 26, 27 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 10: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 2: 
            case 4: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementConsumer";
                break;
            }
            case 5: 
            case 9: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookupConsumer";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 14: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "positionElement";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbolConsumer";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 23: 
            case 25: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/completion/ReferenceCompletionUtil";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldSymbol";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/completion/ReferenceCompletionUtil";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "createOverriddenFilter";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupingByFieldSymbol";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doWithReferenceCompletion";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addLookupItems";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addScopeVariables";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addLookupItemsByType";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addCompletionSymbols";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getContextType";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "collectCompletionForAttrArgs";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "collectFieldsCompletion";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "collectFieldsInfo";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableName";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createOverriddenFilter";
                break;
            }
            case 23: 
            case 25: 
            case 26: 
            case 27: {
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getGroupingByFieldSymbol";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 23, 25, 26, 27 -> new IllegalStateException(string);
        };
    }
}

