/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.codeFragment;

import com.intellij.codeInsight.codeFragment.CodeFragment;
import com.intellij.codeInsight.codeFragment.CodeFragmentUtil;
import com.intellij.codeInsight.codeFragment.Position;
import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.codeInsight.controlflow.TransparentInstruction;
import com.intellij.codeInsight.controlflow.impl.ConditionalInstructionImpl;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.codeInsight.codeFragment.RCodeFragmentBuilder;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.ScopeHolder;
import org.jetbrains.plugins.ruby.ruby.codeInsight.usages.BlockParameterAccess;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlFlow.RControlFlowUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlFlow.impl.instructions.ReturnInstructionImpl;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlFlow.instructions.ReadWriteInstruction;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RBreakStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RNextStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RRedoStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RRetryStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.REnsureBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RRescueBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RSingletonMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modules.RModule;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.expressions.RBinaryExpressionNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RCodeBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.visitors.RubyRecursiveElementVisitor;

public final class RubyExtractMethodUtil {
    private RubyExtractMethodUtil() {
    }

    public static Object createCodeFragment(@NotNull ScopeHolder holder, @NotNull PsiElement startInScope, @NotNull PsiElement endInScope) {
        Instruction[] flow;
        if (holder == null) {
            RubyExtractMethodUtil.$$$reportNull$$$0(0);
        }
        if (startInScope == null) {
            RubyExtractMethodUtil.$$$reportNull$$$0(1);
        }
        if (endInScope == null) {
            RubyExtractMethodUtil.$$$reportNull$$$0(2);
        }
        final int start = startInScope.getTextRange().getStartOffset();
        final int end = endInScope.getTextRange().getEndOffset();
        final Ref errorMessage = new Ref();
        holder.acceptChildren((PsiElementVisitor)new RubyRecursiveElementVisitor(){

            public void visitRClass(@NotNull RClass rClass) {
                if (rClass == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (CodeFragmentUtil.getPosition((PsiElement)rClass, (int)start, (int)end) == Position.INSIDE) {
                    errorMessage.set((Object)RBundle.message((String)"refactoring.extract.method.error.cannot.perform.refactoring.when.class.declaration.inside"));
                }
            }

            public void visitRModule(@NotNull RModule rModule) {
                if (rModule == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (CodeFragmentUtil.getPosition((PsiElement)rModule, (int)start, (int)end) == Position.INSIDE) {
                    errorMessage.set((Object)RBundle.message((String)"refactoring.extract.method.error.cannot.perform.refactoring.when.module.declaration.inside"));
                }
            }

            public void visitRMethod(@NotNull RMethod rMethod) {
                if (rMethod == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (CodeFragmentUtil.getPosition((PsiElement)rMethod, (int)start, (int)end) == Position.INSIDE) {
                    errorMessage.set((Object)RBundle.message((String)"refactoring.extract.method.error.cannot.perform.refactoring.when.method.declaration.inside"));
                }
            }

            public void visitRSingletonMethod(@NotNull RSingletonMethod rsMethod) {
                if (rsMethod == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (CodeFragmentUtil.getPosition((PsiElement)rsMethod, (int)start, (int)end) == Position.INSIDE) {
                    errorMessage.set((Object)RBundle.message((String)"refactoring.extract.method.error.cannot.perform.refactoring.when.method.declaration.inside"));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "rClass";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "rModule";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "rMethod";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "rsMethod";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/codeFragment/RubyExtractMethodUtil$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitRClass";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitRModule";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitRMethod";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitRSingletonMethod";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        if (errorMessage.get() != null) {
            return errorMessage.get();
        }
        HashSet<Instruction> outerInstructions = new HashSet<Instruction>();
        boolean returnInstructionInside = false;
        for (Instruction instruction : flow = holder.getControlFlow().getInstructions()) {
            RPsiElement element = (RPsiElement)instruction.getElement();
            if (element == null || !CodeFragmentUtil.elementFit((PsiElement)element, (int)start, (int)end)) continue;
            if (element instanceof RBreakStatement && !CodeFragmentUtil.elementFit((PsiElement)((RBreakStatement)element).getLoop(), (int)start, (int)end)) {
                return RBundle.message((String)"refactoring.extract.method.error.cannot.perform.refactoring.no.corresponding.loop.for.break");
            }
            if (element instanceof RNextStatement && !CodeFragmentUtil.elementFit((PsiElement)((RNextStatement)element).getLoop(), (int)start, (int)end)) {
                return RBundle.message((String)"refactoring.extract.method.error.cannot.perform.refactoring.no.corresponding.loop.for.next");
            }
            if (element instanceof RRedoStatement && !CodeFragmentUtil.elementFit((PsiElement)((RRedoStatement)element).getLoop(), (int)start, (int)end)) {
                return RBundle.message((String)"refactoring.extract.method.error.cannot.perform.refactoring.no.corresponding.loop.for.redo");
            }
            if (element instanceof RRetryStatement && !CodeFragmentUtil.elementFit((PsiElement)((RRetryStatement)element).getRetryContext(), (int)start, (int)end)) {
                return RBundle.message((String)"refactoring.extract.method.error.cannot.perform.refactoring.no.corresponding.context.for.retry");
            }
            if (instruction instanceof ReturnInstructionImpl) {
                returnInstructionInside = true;
            }
            if (RControlFlowUtil.collectPredecessorsWithoutCompoundAndBlockStatements((Instruction[])flow, (Instruction)instruction).isEmpty()) continue;
            for (Instruction next : instruction.allSucc()) {
                RPsiElement nextElement;
                if (next instanceof ConditionalInstructionImpl || next instanceof TransparentInstruction || (nextElement = (RPsiElement)next.getElement()) != null && RBinaryExpressionNavigator.getBinaryExpressionByOperand((PsiElement)nextElement) != null || nextElement instanceof RRescueBlock || nextElement instanceof REnsureBlock || nextElement == null && RubyPsiUtil.isInRaiseCall((PsiElement)element) || CodeFragmentUtil.elementFit((PsiElement)nextElement, (int)start, (int)end)) continue;
                outerInstructions.add(next);
            }
        }
        if (outerInstructions.size() > 2) {
            return RBundle.message((String)"refactoring.extract.method.error.cannot.perform.refactoring.when.execution.flow.is.interrupted");
        }
        if (outerInstructions.size() == 2) {
            boolean errorFound = true;
            for (Instruction outerInstruction : outerInstructions) {
                if ((!(outerInstruction instanceof ReadWriteInstruction) || !(((ReadWriteInstruction)outerInstruction).getAccess() instanceof BlockParameterAccess)) && !(outerInstruction.getElement() instanceof RCodeBlock) || returnInstructionInside) continue;
                errorFound = false;
                break;
            }
            if (errorFound) {
                return RBundle.message((String)"refactoring.extract.method.error.cannot.perform.refactoring.when.execution.flow.is.interrupted");
            }
        }
        RCodeFragmentBuilder builder2 = new RCodeFragmentBuilder(start, end, (RPsiElement)holder);
        if (holder instanceof RContainer) {
            holder.acceptChildren((PsiElementVisitor)builder2);
        } else {
            holder.accept((PsiElementVisitor)builder2);
        }
        return new CodeFragment(builder2.getInElements(), builder2.getOutElements(), returnInstructionInside);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "startInScope";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "endInScope";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/codeFragment/RubyExtractMethodUtil";
        objectArray[2] = "createCodeFragment";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

