/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.plugins.ruby.gem.GemDependency;
import org.jetbrains.plugins.ruby.rails.codeInsight.RailsTypeUtil;
import org.jetbrains.plugins.ruby.ruby.RubyUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.ResolveTargetDescriptor;
import org.jetbrains.plugins.ruby.ruby.codeInsight.RubyDynamicExtensionsManager;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.computable.OrSymbolTypeComputable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.computable.RSymbolBasedTypeComputable;

@Service
public final class YamlDynamicExtensionsLoader {
    private static final Logger LOG = Logger.getInstance(YamlDynamicExtensionsLoader.class);
    private boolean myInitialized;
    private final RubyDynamicExtensionsManager myManager = RubyDynamicExtensionsManager.getInstance();

    public YamlDynamicExtensionsLoader() {
        this.init();
    }

    private void init() {
        if (this.myInitialized) {
            return;
        }
        for (String s : RubyUtil.getBuiltinScriptFolders()) {
            File rootFile = new File(s);
            if (!rootFile.exists() || !rootFile.isDirectory()) continue;
            FileUtil.processFilesRecursively((File)rootFile, file -> {
                String path;
                if (!file.isDirectory() && ((path = file.getPath()).endsWith(".yaml") || path.endsWith(".yml"))) {
                    this.load((File)file);
                }
                return true;
            });
        }
        this.myInitialized = true;
    }

    public static YamlDynamicExtensionsLoader getInstance() {
        return (YamlDynamicExtensionsLoader)ApplicationManager.getApplication().getService(YamlDynamicExtensionsLoader.class);
    }

    private void load(File file) {
        Map map = YamlDynamicExtensionsLoader.loadYaml(file);
        if (map == null) {
            return;
        }
        this.loadFromMap(map);
    }

    private void loadFromMap(Object map) {
        this.loadDynamicMembers(map);
        this.loadMethodReturnTypes(map);
        this.loadBlockVariableTypes(map);
        this.loadClassTypes(map);
    }

    private void loadClassTypes(Object map) {
        Object types = YamlDynamicExtensionsLoader.get(map, "class_types");
        if (types instanceof Map) {
            Map typeMap = (Map)types;
            for (Object key : typeMap.keySet()) {
                Object value = typeMap.get(key);
                if (value instanceof String) {
                    String stringValue = value.toString();
                    String stringKey = key.toString();
                    if (stringValue.equals(":recursive")) {
                        this.myManager.addRecursiveDynamicClassType(stringKey);
                        continue;
                    }
                    if (stringValue.equals(":empty")) {
                        this.myManager.addDynamicClassType(stringKey);
                        continue;
                    }
                    this.myManager.addDynamicClassType(stringKey, RTypeUtil.createTypeByNameComputable(stringValue));
                    continue;
                }
                LOG.error("unsupported dynamic class type: " + String.valueOf(value.getClass()));
            }
        }
    }

    private void loadBlockVariableTypes(Object map) {
        Object types = YamlDynamicExtensionsLoader.get(map, "block_variable_types");
        if (types instanceof Map) {
            Map typeMap = (Map)types;
            for (Object key : typeMap.keySet()) {
                Object value = typeMap.get(key);
                if (value instanceof String) {
                    this.myManager.addBlockVariableType(key.toString(), value.toString());
                    continue;
                }
                LOG.error("unsupported block variable type: " + String.valueOf(value.getClass()));
            }
        }
    }

    private void loadMethodReturnTypes(Object map) {
        Object types = YamlDynamicExtensionsLoader.get(map, "method_types");
        if (types == null) {
            return;
        }
        this.loadMethodReturnTypesRec(types, "");
    }

    private void loadMethodReturnTypesRec(Object types, String prefix) {
        if (types instanceof String) {
            String type = types.toString();
            if (type.equals(":same_as_receiver")) {
                this.myManager.addImplicitMethodReturnComputableType(YamlDynamicExtensionsLoader.toMethodName(prefix), RTypeUtil.createReceiverTypeComputable());
            } else {
                this.myManager.addImplicitMethodReturnComputableType(YamlDynamicExtensionsLoader.toMethodName(prefix), RTypeUtil.createTypeByNameComputable(type));
            }
        } else if (types instanceof List) {
            this.loadOrType((List)types, prefix);
        } else if (types instanceof Map) {
            if (YamlDynamicExtensionsLoader.hasGemDependentNodes(types)) {
                RailsTypeUtil.RailsVersionDependentTypeComputable computable = YamlDynamicExtensionsLoader.loadRailsVersionTypes((Map)types);
                this.myManager.addImplicitMethodReturnComputableType(YamlDynamicExtensionsLoader.toMethodName(prefix), computable);
            } else {
                for (Object key : ((Map)types).keySet()) {
                    String keyString = key.toString();
                    Object value = YamlDynamicExtensionsLoader.get(types, keyString);
                    if ("variants".equals(keyString) || value instanceof List) {
                        this.loadOrType((List)value, prefix);
                        continue;
                    }
                    this.loadMethodReturnTypesRec(value, prefix + (!prefix.isEmpty() ? "::" : "") + keyString);
                }
            }
        } else {
            LOG.error("unsupported method return type: " + String.valueOf(types.getClass()));
        }
    }

    private static String toMethodName(String prefix) {
        int index = prefix.lastIndexOf("::");
        return StringUtil.replaceSubstring((String)prefix, (TextRange)new TextRange(index, index + 2), (String)".");
    }

    private static RailsTypeUtil.RailsVersionDependentTypeComputable loadRailsVersionTypes(Map types) {
        Object o = YamlDynamicExtensionsLoader.get(types, "rails 4.2");
        String rails42Type = o != null ? o.toString() : null;
        return new RailsTypeUtil.RailsVersionDependentTypeComputable(rails42Type);
    }

    private void loadOrType(List types, String prefix) {
        Object first = types.remove(0);
        RSymbolBasedTypeComputable prev = RTypeUtil.createTypeByNameComputable(first.toString());
        for (Object type : types) {
            RSymbolBasedTypeComputable current = RTypeUtil.createTypeByNameComputable(type.toString());
            prev = new OrSymbolTypeComputable(prev, current);
        }
        this.myManager.addImplicitMethodReturnComputableType(YamlDynamicExtensionsLoader.toMethodName(prefix), prev);
    }

    private void loadDynamicMembers(Object map) {
        Object members = YamlDynamicExtensionsLoader.get(map, "dynamic_members");
        if (members == null) {
            return;
        }
        this.loadDynamicMembersRec(members, "", null);
    }

    private void loadDynamicMembersRec(Object types, String prefix, @Nullable GemDependency dependency) {
        block6: {
            if (!(types instanceof Map)) break block6;
            Object instanceMethods = YamlDynamicExtensionsLoader.get(types, "instance_methods");
            Object classMethods = YamlDynamicExtensionsLoader.get(types, "class_methods");
            Object attrReaders = YamlDynamicExtensionsLoader.get(types, "attr_reader");
            Object attrWriters = YamlDynamicExtensionsLoader.get(types, "attr_writer");
            Object classes = YamlDynamicExtensionsLoader.get(types, "classes");
            if (instanceMethods != null || classMethods != null || attrReaders != null || attrWriters != null || classes != null) {
                this.loadMethods(prefix, instanceMethods, Type.INSTANCE_METHOD, dependency);
                this.loadMethods(prefix + "::$$SINGLETON$$", classMethods, Type.CLASS_METHOD, dependency);
                this.loadMethods(prefix, attrReaders, Type.FIELD_READER, dependency);
                this.loadMethods(prefix, attrWriters, Type.FIELD_WRITER, dependency);
                this.loadMethods(prefix, classes, Type.CLASS, dependency);
            } else if (YamlDynamicExtensionsLoader.hasGemDependentNodes(types)) {
                for (Object key : ((Map)types).keySet()) {
                    String keyString = key.toString();
                    this.loadDynamicMembersRec(YamlDynamicExtensionsLoader.get(types, keyString), prefix, YamlDynamicExtensionsLoader.loadGemDependency(key));
                }
            } else {
                for (Object key : ((Map)types).keySet()) {
                    String keyString = key.toString();
                    this.loadDynamicMembersRec(YamlDynamicExtensionsLoader.get(types, keyString), prefix + (!prefix.isEmpty() ? "::" : "") + keyString, dependency);
                }
            }
        }
    }

    @Nullable
    private static GemDependency loadGemDependency(Object key) {
        String[] nameAndOptions = key.toString().split("\\s+", 2);
        return GemDependency.create(nameAndOptions[0], nameAndOptions[1].split("&&"));
    }

    private void loadMethods(String prefix, Object methods, Type type, GemDependency dependency) {
        if (methods instanceof String) {
            String[] methodNames = methods.toString().split(",\\s*");
            this.myManager.registerDynamicMethods(prefix, type, null, dependency, methodNames);
        } else if (methods instanceof Map) {
            Object methodList = YamlDynamicExtensionsLoader.get(methods, "methods");
            Object targetNode = YamlDynamicExtensionsLoader.get(methods, "target");
            if (methodList != null && targetNode != null) {
                String[] methodNames = methodList.toString().split(",\\s*");
                this.myManager.registerDynamicMethods(prefix, type, YamlDynamicExtensionsLoader.loadTarget(targetNode), dependency, methodNames);
            } else {
                for (Object key : ((Map)methods).keySet()) {
                    String keyString = key.toString();
                    this.myManager.registerDynamicMethods(prefix, type, YamlDynamicExtensionsLoader.loadTarget(YamlDynamicExtensionsLoader.get(methods, keyString)), dependency, keyString);
                }
            }
        }
    }

    private static ResolveTargetDescriptor loadTarget(Object node) {
        if (node instanceof String) {
            return new ResolveTargetDescriptor(node.toString());
        }
        LOG.error("target is not supported " + String.valueOf(node));
        return null;
    }

    private static boolean hasGemDependentNodes(Object types) {
        if (types instanceof Map) {
            for (Object key : ((Map)types).keySet()) {
                if (!(key instanceof String) || !key.toString().contains(" ")) continue;
                return true;
            }
        }
        return false;
    }

    private static Map loadYaml(File file) {
        Map map;
        FileInputStream stream = new FileInputStream(file);
        try {
            map = RubyUtil.loadYaml(stream);
        }
        catch (Throwable throwable) {
            try {
                try {
                    stream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
                return null;
            }
        }
        stream.close();
        return map;
    }

    @TestOnly
    public void loadForTests(String text) {
        Map map = null;
        try (ByteArrayInputStream stream = new ByteArrayInputStream(text.getBytes(StandardCharsets.UTF_8));){
            map = RubyUtil.loadYaml(stream);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        if (map == null) {
            return;
        }
        this.loadFromMap(map);
    }

    @Nullable
    private static Object get(Object map, String key) {
        return map instanceof Map ? ((Map)map).get(key) : null;
    }
}

