/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.RubyInsertHandlerProvider;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.MethodInsertHandlerCreator;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.RubyMethodInsertHandlerCreator;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.presentation.SymbolLookupUtil;

public abstract class RubyStaticInsertHandlersProvider
implements RubyInsertHandlerProvider {
    private final Map<FQN, MethodInsertHandlerCreator> myFqnToHandler = new HashMap<FQN, MethodInsertHandlerCreator>();

    protected static MethodInsertHandlerCreator blockCallWithoutArgs() {
        return RubyStaticInsertHandlersProvider.simpleAfterMethod(" <caret> do\n\nend", RubyMethodInsertHandlerCreator.MyAdditionalWhiteSpaceInsertHandler.class);
    }

    protected static MethodInsertHandlerCreator blockCall() {
        return RubyStaticInsertHandlersProvider.simpleAfterMethod("(<caret>) do\n\nend");
    }

    protected static MethodInsertHandlerCreator simpleAfterMethod(String text) {
        return RubyStaticInsertHandlersProvider.simpleAfterMethod(text, RubyMethodInsertHandlerCreator.MyRubyMethodInsertHandler.class);
    }

    protected static MethodInsertHandlerCreator simpleAfterMethod(String text, Class<? extends RubyMethodInsertHandlerCreator.MyRubyMethodInsertHandler> handlerClass) {
        int lineNo = 0;
        int column = 0;
        String[] lines = text.split("\n");
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            column = line.indexOf("<caret>");
            if (column < 0) continue;
            lineNo = i;
            lines[i] = line.replace("<caret>", "");
            break;
        }
        return new RubyMethodInsertHandlerCreator(lines, lineNo, column, handlerClass);
    }

    protected void describe(String classFQN, MethodInsertHandlerCreator creator, String ... methods) {
        FQN fqn = FQN.Builder.create(Collections.singletonList(classFQN), (boolean)false);
        for (String method : methods) {
            FQN methodFQN = FQN.Builder.concat((FQN)fqn, (String)method);
            this.myFqnToHandler.put(methodFQN, creator != null ? creator : SymbolLookupUtil.createNoSignatureHandlerCreator());
        }
    }

    @Override
    @Nullable
    public MethodInsertHandlerCreator getHandlerFor(@NotNull Symbol symbol) {
        if (symbol == null) {
            RubyStaticInsertHandlersProvider.$$$reportNull$$$0(0);
        }
        return this.myFqnToHandler.get(symbol.getFQNWithNesting());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbol", "org/jetbrains/plugins/ruby/ruby/codeInsight/RubyStaticInsertHandlersProvider", "getHandlerFor"));
    }
}

