/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight;

import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import org.jetbrains.plugins.ruby.erb.ErbFileType;
import org.jetbrains.plugins.ruby.rails.nameConventions.ViewsConventions;
import org.jetbrains.plugins.ruby.ruby.lang.RubyFileType;
import org.jetbrains.plugins.ruby.ruby.lang.RubyLanguage;

public final class RubyProblemFileHighlightFilter
implements Condition<VirtualFile> {
    private final Project myProject;

    public RubyProblemFileHighlightFilter(Project project) {
        this.myProject = project;
    }

    public boolean value(VirtualFile virtualFile) {
        FileType fileType = virtualFile.getFileType();
        if (fileType == RubyFileType.RUBY || fileType == ErbFileType.ERB || ViewsConventions.isTemplateFileType(fileType) || fileType.getName().equals("YAML")) {
            return true;
        }
        Ref canProcessRef = new Ref((Object)false);
        ApplicationManager.getApplication().runReadAction(() -> {
            PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(virtualFile);
            canProcessRef.set((Object)(psiFile != null && psiFile.getViewProvider().getPsi((Language)RubyLanguage.INSTANCE) != null ? 1 : 0));
        });
        return (Boolean)canProcessRef.get();
    }
}

