/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight;

import com.intellij.codeInsight.generation.ClassMember;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.RElementWithFQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.TypeSet;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Types;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.PsiElementSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolProcessor;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.util.SymbolHierarchy;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.ClassModuleSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.SingletonClassSymbol;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RubyClassResolveUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.indexes.RubyInheritanceIndex;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallTypesCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RConstant;

public final class RubyOverrideImplementUtil {
    private RubyOverrideImplementUtil() {
    }

    @NotNull
    public static List<PsiElement> getOverriddenMethods(@NotNull RMethod method) {
        Symbol symbol;
        if (method == null) {
            RubyOverrideImplementUtil.$$$reportNull$$$0(0);
        }
        if ((symbol = SymbolUtil.getSymbolByContainer((RElementWithFQN)method)) == null || StringUtil.isEmpty((String)symbol.getName())) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                RubyOverrideImplementUtil.$$$reportNull$$$0(1);
            }
            return list;
        }
        return RubyOverrideImplementUtil.getOverriddenMethods(symbol, symbol.getName(), SymbolUtil.getMethodTypes(), false);
    }

    @NotNull
    public static List<PsiElement> getOverriddenMethods(@NotNull Symbol methodSymbol, @NotNull String name, @NotNull TypeSet types, boolean isNearest) {
        Type type;
        if (methodSymbol == null) {
            RubyOverrideImplementUtil.$$$reportNull$$$0(2);
        }
        if (name == null) {
            RubyOverrideImplementUtil.$$$reportNull$$$0(3);
        }
        if (types == null) {
            RubyOverrideImplementUtil.$$$reportNull$$$0(4);
        }
        if (!Types.METHODS_LIKE.contains(type = methodSymbol.getType())) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                RubyOverrideImplementUtil.$$$reportNull$$$0(5);
            }
            return list;
        }
        Symbol parent = methodSymbol.getParentSymbol();
        PsiElement element = methodSymbol.getPsiElement();
        if (parent != null && element != null) {
            ArrayList<PsiElement> result = new ArrayList<PsiElement>();
            RubyOverrideImplementUtil.processOverriddenSymbols(methodSymbol, name, element, (Processor<? super Symbol>)((Processor)symbol -> {
                if (types.contains(symbol.getType())) {
                    ContainerUtil.addIfNotNull((Collection)result, (Object)symbol.getPsiElement());
                    return !isNearest;
                }
                return true;
            }));
            ArrayList<PsiElement> arrayList = result;
            if (arrayList == null) {
                RubyOverrideImplementUtil.$$$reportNull$$$0(6);
            }
            return arrayList;
        }
        List<PsiElement> list = Collections.emptyList();
        if (list == null) {
            RubyOverrideImplementUtil.$$$reportNull$$$0(7);
        }
        return list;
    }

    public static boolean processSuperSymbols(@NotNull Symbol method, @NotNull String name, @Nullable PsiElement invocationPoint, @NotNull Processor<? super Symbol> processor) {
        Symbol methodParent;
        if (method == null) {
            RubyOverrideImplementUtil.$$$reportNull$$$0(8);
        }
        if (name == null) {
            RubyOverrideImplementUtil.$$$reportNull$$$0(9);
        }
        if (processor == null) {
            RubyOverrideImplementUtil.$$$reportNull$$$0(10);
        }
        FQN methodParentFqn = (methodParent = method.getParentSymbol()) != null ? methodParent.getFQNWithNesting() : FQN.INVALID;
        Processor filteringProcessor = symbol -> {
            Symbol parent = symbol.getParentSymbol();
            FQN parentFqn = parent != null ? parent.getFQNWithNesting() : FQN.INVALID;
            return methodParentFqn.equals(parentFqn) || processor.process(symbol);
        };
        return RubyOverrideImplementUtil.processOverriddenSymbols(method, name, invocationPoint, (Processor<? super Symbol>)filteringProcessor);
    }

    public static boolean processOverriddenSymbols(@NotNull Symbol method, final @NotNull String name, final @Nullable PsiElement invocationPoint, final @NotNull Processor<? super Symbol> processor) {
        if (method == null) {
            RubyOverrideImplementUtil.$$$reportNull$$$0(11);
        }
        if (name == null) {
            RubyOverrideImplementUtil.$$$reportNull$$$0(12);
        }
        if (processor == null) {
            RubyOverrideImplementUtil.$$$reportNull$$$0(13);
        }
        if (!Types.METHODS_LIKE.contains(method.getType())) {
            return true;
        }
        Symbol parent = method.getParentSymbol();
        PsiElement methodElement = method.getPsiElement();
        if (parent == null || methodElement == null) {
            return true;
        }
        final PsiElement originalMethodElement = PsiUtilCore.getOriginalElement((PsiElement)methodElement, RMethod.class);
        final Ref methodSeen = new Ref((Object)false);
        return SymbolHierarchy.processSymbolChildren(parent, new SymbolProcessor(){

            @Override
            public boolean process(@NotNull Symbol symbol) {
                if (symbol == null) {
                    1.$$$reportNull$$$0(0);
                }
                ProgressManager.checkCanceled();
                if (!name.equals(symbol.getName())) {
                    return true;
                }
                if (symbol.getPsiElement() == originalMethodElement) {
                    methodSeen.set((Object)true);
                } else if (((Boolean)methodSeen.get()).booleanValue()) {
                    return processor.process((Object)symbol);
                }
                return true;
            }

            @Override
            public String getName() {
                return name;
            }

            @Override
            @Nullable
            public PsiElement getInvocationPoint() {
                return invocationPoint;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbol", "org/jetbrains/plugins/ruby/ruby/codeInsight/RubyOverrideImplementUtil$1", "process"));
            }
        });
    }

    public static String classMembersToString(@NotNull List<? extends ClassMember> list) {
        if (list == null) {
            RubyOverrideImplementUtil.$$$reportNull$$$0(14);
        }
        StringBuilder builder2 = new StringBuilder();
        for (ClassMember classMember : list) {
            builder2.append(classMember.getText()).append("\n");
        }
        return builder2.toString().trim();
    }

    public static Collection<RContainer> getOverridingElements(RContainer container) {
        return RubyOverrideImplementUtil.getOverridingElementsImpl(container, false);
    }

    @NotNull
    public static Collection<RConstant> getOverridingElements(@NotNull RConstant constant) {
        if (constant == null) {
            RubyOverrideImplementUtil.$$$reportNull$$$0(15);
        }
        PsiElementSymbol<RConstant> symbol = new PsiElementSymbol<RConstant>(constant, constant.getName(), Type.CONSTANT);
        List list = ContainerUtil.mapNotNull(RubyOverrideImplementUtil.getOverridingSymbols(symbol), child -> (RConstant)ObjectUtils.tryCast((Object)child.getPsiElement(), RConstant.class));
        if (list == null) {
            RubyOverrideImplementUtil.$$$reportNull$$$0(16);
        }
        return list;
    }

    @NotNull
    public static Collection<? extends Symbol> getOverridingSymbols(@NotNull Symbol symbol) {
        if (symbol == null) {
            RubyOverrideImplementUtil.$$$reportNull$$$0(17);
        }
        Set<? extends Symbol> set = RubyOverrideImplementUtil.getOverridingSymbolsImpl(symbol, false, symbol.getPsiElement());
        if (set == null) {
            RubyOverrideImplementUtil.$$$reportNull$$$0(18);
        }
        return set;
    }

    public static Collection<RContainer> getNearestOverridingElements(RContainer container) {
        return RubyOverrideImplementUtil.getOverridingElementsImpl(container, true);
    }

    @NotNull
    private static Collection<RContainer> getOverridingElementsImpl(@Nullable RContainer container, boolean isNearest) {
        Symbol symbol = SymbolUtil.getSymbolByContainer((RElementWithFQN)container);
        if (symbol == null) {
            List<RContainer> list = Collections.emptyList();
            if (list == null) {
                RubyOverrideImplementUtil.$$$reportNull$$$0(19);
            }
            return list;
        }
        List list = ContainerUtil.mapNotNull(RubyOverrideImplementUtil.getOverridingSymbolsImpl(symbol, isNearest, (PsiElement)container), child -> (RContainer)ObjectUtils.tryCast((Object)child.getPsiElement(), RContainer.class));
        if (list == null) {
            RubyOverrideImplementUtil.$$$reportNull$$$0(20);
        }
        return list;
    }

    private static Set<? extends Symbol> getOverridingSymbolsImpl(@NotNull Symbol symbol, boolean isNearest, final @Nullable PsiElement invocationPoint) {
        if (symbol == null) {
            RubyOverrideImplementUtil.$$$reportNull$$$0(21);
        }
        final LinkedHashSet result = new LinkedHashSet();
        if (symbol instanceof ClassModuleSymbol) {
            RubyOverrideImplementUtil.addAllDerived((ClassModuleSymbol)symbol, result, invocationPoint, isNearest);
        } else if (symbol.getPsiElement() instanceof RMethod || symbol.getType() == Type.CONSTANT) {
            Symbol parentSymbol = symbol.getParentSymbol();
            if (!(parentSymbol instanceof ClassModuleSymbol)) {
                return Collections.emptySet();
            }
            final String name = symbol.getFQNWithNesting().getShortName();
            final PsiElement declaration = symbol.getPsiElement();
            SymbolProcessor processor = new SymbolProcessor(){

                @Override
                public String getName() {
                    return name;
                }

                @Override
                @Nullable
                public PsiElement getInvocationPoint() {
                    return invocationPoint;
                }

                @Override
                public boolean process(@NotNull Symbol symbol) {
                    if (symbol == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (symbol.getPsiElement() == declaration) {
                        return false;
                    }
                    if (declaration instanceof RMethod) {
                        if (Types.METHODS_LIKE.contains(symbol.getType()) && symbol.getPsiElement() instanceof RMethod && name.equals(symbol.getName())) {
                            result.add(symbol);
                        }
                    } else if (symbol.getType() == Type.CONSTANT) {
                        result.add(symbol);
                    }
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbol", "org/jetbrains/plugins/ruby/ruby/codeInsight/RubyOverrideImplementUtil$2", "process"));
                }
            };
            LinkedHashSet subclassSymbols = new LinkedHashSet();
            RubyOverrideImplementUtil.addAllDerived((ClassModuleSymbol)parentSymbol, subclassSymbols, invocationPoint, isNearest);
            for (ClassModuleSymbol subclass : subclassSymbols) {
                SymbolHierarchy.processSymbolChildren((Symbol)subclass, processor);
            }
        }
        return result;
    }

    public static void addDerivedClasses(@NotNull RContainer rClass, Set<? super RContainer> overridingElements) {
        Symbol symbol;
        if (rClass == null) {
            RubyOverrideImplementUtil.$$$reportNull$$$0(22);
        }
        if (!((symbol = SymbolUtil.getSymbolByContainer((RElementWithFQN)rClass)) instanceof ClassModuleSymbol) || symbol.getType() != Type.CLASS) {
            return;
        }
        LinkedHashSet overridingSymbols = new LinkedHashSet();
        RubyOverrideImplementUtil.addAllDerived((ClassModuleSymbol)symbol, overridingSymbols, (PsiElement)rClass, false);
        for (ClassModuleSymbol overridingSymbol : overridingSymbols) {
            PsiElement element = overridingSymbol.getPsiElement();
            if (!(element instanceof RContainer)) continue;
            overridingElements.add((RContainer)((RContainer)element));
        }
    }

    private static void addAllDerived(@NotNull ClassModuleSymbol symbol, @NotNull Set<? super ClassModuleSymbol> overridingSymbols, @Nullable PsiElement invocationPint, boolean isNearest) {
        if (symbol == null) {
            RubyOverrideImplementUtil.$$$reportNull$$$0(23);
        }
        if (overridingSymbols == null) {
            RubyOverrideImplementUtil.$$$reportNull$$$0(24);
        }
        ArrayDeque<ClassModuleSymbol> queue = new ArrayDeque<ClassModuleSymbol>(4);
        queue.addLast(symbol);
        while (!queue.isEmpty()) {
            LinkedHashSet derivedSymbols = new LinkedHashSet();
            ClassModuleSymbol classModuleSymbol = (ClassModuleSymbol)((Object)queue.removeFirst());
            RubyOverrideImplementUtil.addDerivedSymbols(classModuleSymbol, derivedSymbols, invocationPint);
            for (ClassModuleSymbol derivedSymbol : derivedSymbols) {
                if (!overridingSymbols.add(derivedSymbol)) continue;
                queue.addLast(derivedSymbol);
            }
            if (!isNearest) continue;
            return;
        }
    }

    private static void addDerivedSymbols(@NotNull ClassModuleSymbol symbol, @NotNull Set<? super ClassModuleSymbol> overridingSymbols, @Nullable PsiElement invocationPint) {
        if (symbol == null) {
            RubyOverrideImplementUtil.$$$reportNull$$$0(25);
        }
        if (overridingSymbols == null) {
            RubyOverrideImplementUtil.$$$reportNull$$$0(26);
        }
        if (symbol.getType() == Type.CLASS) {
            RubyOverrideImplementUtil.addDerivedSymbolsByClass(symbol, overridingSymbols, invocationPint);
        } else if (symbol.getType() == Type.MODULE) {
            RubyOverrideImplementUtil.addDerivedSymbolsByModule(symbol, overridingSymbols, invocationPint);
        }
    }

    private static void addDerivedSymbolsByClass(@NotNull ClassModuleSymbol classSymbol, @NotNull Set<? super ClassModuleSymbol> overridingSymbols, @Nullable PsiElement invocationPoint) {
        if (classSymbol == null) {
            RubyOverrideImplementUtil.$$$reportNull$$$0(27);
        }
        if (overridingSymbols == null) {
            RubyOverrideImplementUtil.$$$reportNull$$$0(28);
        }
        if (!(classSymbol instanceof SingletonClassSymbol)) {
            RubyOverrideImplementUtil.addDerivedSymbolsByClassImpl(classSymbol, overridingSymbols, invocationPoint);
            return;
        }
        Symbol originalSymbol = ((SingletonClassSymbol)classSymbol).getOriginSymbol();
        if (!(originalSymbol instanceof ClassModuleSymbol)) {
            return;
        }
        LinkedHashSet classes = new LinkedHashSet();
        RubyOverrideImplementUtil.addDerivedSymbolsByClassImpl((ClassModuleSymbol)originalSymbol, classes, invocationPoint);
        for (ClassModuleSymbol derivedClassSymbol : classes) {
            ClassModuleSymbol singletonClassSymbol = (ClassModuleSymbol)derivedClassSymbol.getSingletonClassSymbol();
            overridingSymbols.add(singletonClassSymbol);
        }
    }

    private static void addDerivedSymbolsByClassImpl(@NotNull ClassModuleSymbol classSymbol, @NotNull Set<? super ClassModuleSymbol> overridingSymbols, @Nullable PsiElement invocationPoint) {
        if (classSymbol == null) {
            RubyOverrideImplementUtil.$$$reportNull$$$0(29);
        }
        if (overridingSymbols == null) {
            RubyOverrideImplementUtil.$$$reportNull$$$0(30);
        }
        FQN fqn = classSymbol.getFQN();
        String name = fqn.getShortName();
        Project project = classSymbol.getProject();
        Collection elements = (Collection)ReadAction.compute(() -> RubyInheritanceIndex.getInstance().getElements(project, (SearchScope)GlobalSearchScope.allScope((Project)project), name));
        for (RPsiElement candidate : elements) {
            Symbol container;
            Symbol symbol;
            ProgressManager.checkCanceled();
            if (!(candidate instanceof RClass) || (symbol = RubyClassResolveUtil.resolveSuperClassSymbol((RClass)candidate, invocationPoint)) == null || !symbol.getFQNWithNesting().equals(fqn) || !((container = SymbolUtil.getSymbolByContainer((RElementWithFQN)((RClass)candidate))) instanceof ClassModuleSymbol)) continue;
            overridingSymbols.add((ClassModuleSymbol)container);
        }
    }

    private static void addDerivedSymbolsByModule(@NotNull ClassModuleSymbol moduleSymbol, @NotNull Set<? super ClassModuleSymbol> overridingSymbols, @Nullable PsiElement invocationPoint) {
        if (moduleSymbol == null) {
            RubyOverrideImplementUtil.$$$reportNull$$$0(31);
        }
        if (overridingSymbols == null) {
            RubyOverrideImplementUtil.$$$reportNull$$$0(32);
        }
        FQN fqn = moduleSymbol.getFQNWithNesting();
        String name = fqn.getShortName();
        Project project = moduleSymbol.getProject();
        Collection elements = (Collection)ReadAction.compute(() -> RubyInheritanceIndex.getInstance().getElements(project, (SearchScope)GlobalSearchScope.allScope((Project)project), name));
        block0: for (PsiElement candidate : elements) {
            RCall rCall;
            Symbol context;
            ProgressManager.checkCanceled();
            if (!(candidate instanceof RCall) || (context = SymbolUtil.getScopeContextWithCaching((PsiElement)(rCall = (RCall)candidate))) == null) continue;
            boolean isInclude = RubyCallTypesCore.isIncludeOrPrependCall((RPossibleCall)rCall);
            boolean isExtend = RubyCallTypesCore.isExtendCall((RPossibleCall)rCall);
            if (!isInclude && !isExtend) continue;
            List data = (List)rCall.getData(RubyCallTypes.INCLUDE_EXTEND_CALLS);
            for (FQN callFQN : data) {
                Symbol symbol;
                if (!callFQN.getShortName().equals(name) || !((symbol = SymbolUtil.lookupConstant(context, (RPsiElement)rCall, callFQN, Type.MODULE.asSet(), invocationPoint)) instanceof ClassModuleSymbol) || !symbol.getFQNWithNesting().equals(fqn)) continue;
                FQN callerFQN = FQN.of((String)rCall.getCommand()).getCallerFQN();
                if (!callerFQN.equals(FQN.INVALID)) {
                    context = SymbolUtil.lookupConstant(context, (RPsiElement)rCall, callerFQN, Types.MODULE_OR_CLASS, invocationPoint);
                }
                if (!(context instanceof ClassModuleSymbol)) continue block0;
                if (isExtend) {
                    Symbol singletonClassSymbol = context.getSingletonClassSymbol();
                    if (!(singletonClassSymbol instanceof ClassModuleSymbol)) continue block0;
                    overridingSymbols.add((ClassModuleSymbol)singletonClassSymbol);
                    continue block0;
                }
                overridingSymbols.add((ClassModuleSymbol)context);
                continue block0;
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 5, 6, 7, 16, 18, 19, 20 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 16: 
            case 18: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/RubyOverrideImplementUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodSymbol";
                break;
            }
            case 3: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constant";
                break;
            }
            case 17: 
            case 21: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rClass";
                break;
            }
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "overridingSymbols";
                break;
            }
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classSymbol";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleSymbol";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/RubyOverrideImplementUtil";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getOverriddenMethods";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getOverridingElements";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getOverridingSymbols";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getOverridingElementsImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getOverriddenMethods";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 16: 
            case 18: 
            case 19: 
            case 20: {
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processSuperSymbols";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "processOverriddenSymbols";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "classMembersToString";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getOverridingElements";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getOverridingSymbols";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getOverridingSymbolsImpl";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "addDerivedClasses";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "addAllDerived";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "addDerivedSymbols";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "addDerivedSymbolsByClass";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "addDerivedSymbolsByClassImpl";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "addDerivedSymbolsByModule";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 5, 6, 7, 16, 18, 19, 20 -> new IllegalStateException(string);
        };
    }
}

