/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.plugins.ruby.gem.util.RubyProjectGemSearchService;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.ImplicitRequireProvider;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.TypeSet;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.cache.FQNCache;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.cache.FileRequireCache;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.LoadPathUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.RubyProcessedFilesMap;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modules.RModule;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RTopLevelContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.AnonymousDefiningCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RConstant;

public final class RubyFQNUtil {
    public static boolean isConstantFqn(@NotNull FQN fqn) {
        if (fqn == null) {
            RubyFQNUtil.$$$reportNull$$$0(0);
        }
        return StringUtil.isCapitalized((String)fqn.getShortName()) || AnonymousDefiningCallType.isAnonymousFQN((FQN)fqn) || fqn.getShortName().equals("$$SINGLETON$$");
    }

    public static @Unmodifiable List<RContainer> getFQNBasedPartialDeclarations(@NotNull RContainer classOrModule, boolean addContainerItself, @Nullable PsiElement invocationPoint) {
        if (classOrModule == null) {
            RubyFQNUtil.$$$reportNull$$$0(1);
        }
        List<RContainer> containers = RubyFQNUtil.findContainersByFQN(classOrModule.getProject(), classOrModule instanceof RClass ? Type.CLASS.asSet() : Type.MODULE.asSet(), classOrModule.getFQNWithNesting(), invocationPoint);
        if (addContainerItself) {
            return containers;
        }
        return ContainerUtil.filter(containers, container -> classOrModule != container);
    }

    @Nullable
    public static RContainer findContainerByFQN(@NotNull Project project, @NotNull TypeSet types, @NotNull FQN fqn, @Nullable PsiElement invocationPoint) {
        if (project == null) {
            RubyFQNUtil.$$$reportNull$$$0(2);
        }
        if (types == null) {
            RubyFQNUtil.$$$reportNull$$$0(3);
        }
        if (fqn == null) {
            RubyFQNUtil.$$$reportNull$$$0(4);
        }
        if (types.contains(Type.CLASS) || types.contains(Type.MODULE)) {
            return FQNCache.getInstance(project).getAnyClassModule(project, fqn, element -> element instanceof RClass && types.contains(Type.CLASS) || element instanceof RModule && types.contains(Type.MODULE));
        }
        List<RContainer> containers = RubyFQNUtil.findContainersByFQN(project, types, fqn, invocationPoint);
        if (containers.isEmpty()) {
            return null;
        }
        return containers.iterator().next();
    }

    @Nullable
    public static RPsiElement findConstantByFQN(@NotNull Project project, @NotNull FQN fqn, @Nullable PsiElement invocationPoint) {
        if (project == null) {
            RubyFQNUtil.$$$reportNull$$$0(5);
        }
        if (fqn == null) {
            RubyFQNUtil.$$$reportNull$$$0(6);
        }
        RPsiElement constant = FQNCache.getInstance(project).getAnyConstant(project, fqn, invocationPoint);
        assert (constant == null || constant instanceof RModule || constant instanceof RClass || constant instanceof RConstant);
        return constant;
    }

    @NotNull
    public static List<RContainer> findContainersByFQN(@NotNull Project project, @NotNull TypeSet types, @NotNull FQN fqn, @Nullable PsiElement invocationPoint) {
        if (project == null) {
            RubyFQNUtil.$$$reportNull$$$0(7);
        }
        if (types == null) {
            RubyFQNUtil.$$$reportNull$$$0(8);
        }
        if (fqn == null) {
            RubyFQNUtil.$$$reportNull$$$0(9);
        }
        if (fqn == FQN.INVALID) {
            List<RContainer> list = Collections.emptyList();
            if (list == null) {
                RubyFQNUtil.$$$reportNull$$$0(10);
            }
            return list;
        }
        Pair<Collection<RContainer>, Collection<RContainer>> result = FQNCache.getInstance(project).get(project, types, fqn);
        if (Registry.is((String)"ruby.disable.require.processing", (boolean)true)) {
            return RubyFQNUtil.passContainers(result);
        }
        List<RContainer> list = RubyFQNUtil.filterContainers(project, types, invocationPoint, result);
        if (list == null) {
            RubyFQNUtil.$$$reportNull$$$0(11);
        }
        return list;
    }

    private static void filterContainersForFQN(@NotNull List<RContainer> accumulator, @NotNull Project project, @Nullable Module module, @NotNull TypeSet types, @NotNull Collection<RContainer> containersForFQN, @Nullable RubyProcessedFilesMap map, boolean isInLib) {
        if (accumulator == null) {
            RubyFQNUtil.$$$reportNull$$$0(12);
        }
        if (project == null) {
            RubyFQNUtil.$$$reportNull$$$0(13);
        }
        if (types == null) {
            RubyFQNUtil.$$$reportNull$$$0(14);
        }
        if (containersForFQN == null) {
            RubyFQNUtil.$$$reportNull$$$0(15);
        }
        for (RContainer container : containersForFQN) {
            Set<VirtualFile> files;
            Set<Object> set = files = map != null ? map.getFiles() : Collections.emptySet();
            if (!types.contains(container.getSymbolType()) || map != null && !RubyFQNUtil.isInProcessedFiles(project, container, module, files, isInLib)) continue;
            accumulator.add(container);
        }
    }

    public static <T extends RPsiElement> boolean isInProcessedFiles(@NotNull Project project, @NotNull T element, @Nullable Module module, @NotNull Collection<VirtualFile> files) {
        if (project == null) {
            RubyFQNUtil.$$$reportNull$$$0(16);
        }
        if (element == null) {
            RubyFQNUtil.$$$reportNull$$$0(17);
        }
        if (files == null) {
            RubyFQNUtil.$$$reportNull$$$0(18);
        }
        return RubyFQNUtil.isInProcessedFiles(project, element, module, files, false) || RubyFQNUtil.isInProcessedFiles(project, element, module, files, true);
    }

    private static <T extends RPsiElement> boolean isInProcessedFiles(@NotNull Project project, @NotNull T element, @Nullable Module module, @NotNull Collection<VirtualFile> files, boolean isInLib) {
        if (project == null) {
            RubyFQNUtil.$$$reportNull$$$0(19);
        }
        if (element == null) {
            RubyFQNUtil.$$$reportNull$$$0(20);
        }
        if (files == null) {
            RubyFQNUtil.$$$reportNull$$$0(21);
        }
        if (module == null) {
            return true;
        }
        if (!element.isValid()) {
            return false;
        }
        VirtualFile location = element.getContainingFile().getVirtualFile();
        if (location == null) {
            return true;
        }
        if (files.contains(location)) {
            return true;
        }
        if (!isInLib) {
            return false;
        }
        for (ImplicitRequireProvider provider : (ImplicitRequireProvider[])ImplicitRequireProvider.EP_NAME.getExtensions()) {
            if (!provider.gemAutoRequireSuppressedFor(project, location, location)) continue;
            return false;
        }
        return !RubyProjectGemSearchService.Companion.getAllGems(module).isEmpty();
    }

    @NotNull
    private static List<RContainer> passContainers(@NotNull Pair<Collection<RContainer>, Collection<RContainer>> containersForFQN) {
        if (containersForFQN == null) {
            RubyFQNUtil.$$$reportNull$$$0(22);
        }
        if (containersForFQN.equals((Object)Pair.empty())) {
            List<RContainer> list = Collections.emptyList();
            if (list == null) {
                RubyFQNUtil.$$$reportNull$$$0(23);
            }
            return list;
        }
        ArrayList<RContainer> containers = new ArrayList<RContainer>((Collection)containersForFQN.getSecond());
        containers.addAll((Collection)containersForFQN.getFirst());
        ArrayList<RContainer> arrayList = containers;
        if (arrayList == null) {
            RubyFQNUtil.$$$reportNull$$$0(24);
        }
        return arrayList;
    }

    private static List<RContainer> filterContainers(@NotNull Project project, @NotNull TypeSet types, @Nullable PsiElement invocationPoint, @NotNull Pair<Collection<RContainer>, Collection<RContainer>> containersForFQN) {
        if (project == null) {
            RubyFQNUtil.$$$reportNull$$$0(25);
        }
        if (types == null) {
            RubyFQNUtil.$$$reportNull$$$0(26);
        }
        if (containersForFQN == null) {
            RubyFQNUtil.$$$reportNull$$$0(27);
        }
        if (containersForFQN.equals((Object)Pair.empty())) {
            return Collections.emptyList();
        }
        Collection libContainersForFQN = (Collection)containersForFQN.getFirst();
        Collection contentContainersForFQN = (Collection)containersForFQN.getSecond();
        if (libContainersForFQN.isEmpty() && contentContainersForFQN.isEmpty()) {
            return Collections.emptyList();
        }
        Module module = invocationPoint != null ? ModuleUtilCore.findModuleForPsiElement((PsiElement)invocationPoint) : null;
        RTopLevelContainer topLevelContainer = invocationPoint instanceof RTopLevelContainer ? (RTopLevelContainer)invocationPoint : (RTopLevelContainer)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)invocationPoint, RTopLevelContainer.class);
        RubyProcessedFilesMap map = topLevelContainer != null ? FileRequireCache.getInstance(project).getProcessedFilesMap(topLevelContainer) : null;
        ArrayList<RContainer> filteredFqns = new ArrayList<RContainer>();
        RubyFQNUtil.filterContainersForFQN(filteredFqns, project, module, types, libContainersForFQN, map, true);
        RubyFQNUtil.filterContainersForFQN(filteredFqns, project, module, types, contentContainersForFQN, map, false);
        return map == null ? filteredFqns : LoadPathUtil.sortByProcessingOrder(filteredFqns, map.getComparator());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 11, 23, 24 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classOrModule";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 13: 
            case 16: 
            case 19: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 8: 
            case 14: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 10: 
            case 11: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/RubyFQNUtil";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accumulator";
                break;
            }
            case 15: 
            case 22: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containersForFQN";
                break;
            }
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/RubyFQNUtil";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "findContainersByFQN";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "passContainers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isConstantFqn";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getFQNBasedPartialDeclarations";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findContainerByFQN";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findConstantByFQN";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findContainersByFQN";
                break;
            }
            case 10: 
            case 11: 
            case 23: 
            case 24: {
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "filterContainersForFQN";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isInProcessedFiles";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "passContainers";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "filterContainers";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 11, 23, 24 -> new IllegalStateException(string);
        };
    }
}

