/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight;

import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.gem.GemDependency;
import org.jetbrains.plugins.ruby.ruby.codeInsight.DynamicMethod;
import org.jetbrains.plugins.ruby.ruby.codeInsight.DynamicMethodList;
import org.jetbrains.plugins.ruby.ruby.codeInsight.ResolveTargetDescriptor;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;

public class DynamicMethodsTable {
    private final Map<FQN, DynamicMethodList> myDynamicMethods = new HashMap<FQN, DynamicMethodList>();

    public void registerDynamicMethods(@NonNls String moduleName, @NotNull Type methodType, @Nullable ResolveTargetDescriptor resolveTarget, @Nullable GemDependency requiredGem, String ... methodNames) {
        if (methodType == null) {
            DynamicMethodsTable.$$$reportNull$$$0(0);
        }
        FQN moduleFQN = FQN.Builder.fromString((String)moduleName);
        this.myDynamicMethods.computeIfAbsent(moduleFQN, s -> new DynamicMethodList(moduleFQN, new ArrayList<DynamicMethod>())).getMethods().addAll(ContainerUtil.map((Object[])methodNames, name -> new DynamicMethod((String)name, methodType, resolveTarget, requiredGem)));
    }

    @Nullable
    public DynamicMethodList getMethodListsBy(@NotNull FQN fqn) {
        if (fqn == null) {
            DynamicMethodsTable.$$$reportNull$$$0(1);
        }
        return this.myDynamicMethods.get(fqn);
    }

    public void clear() {
        this.myDynamicMethods.clear();
    }

    public String dumpDynamicMethods() {
        StringBuilder builder2 = new StringBuilder();
        for (FQN fqn : this.myDynamicMethods.keySet()) {
            builder2.append(fqn.getFullPath()).append("\n");
            DynamicMethodList value = this.myDynamicMethods.get(fqn);
            builder2.append("  ").append(value.getQualifiedModuleName()).append("\n");
            for (DynamicMethod method : value.getMethods()) {
                builder2.append("    ").append(method.getName()).append(":").append(method.getType()).append("\n");
            }
        }
        return builder2.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/DynamicMethodsTable";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "registerDynamicMethods";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getMethodListsBy";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

