/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.actions.setup;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.runAnything.RunAnythingChooseContextAction;
import com.intellij.ide.actions.runAnything.RunAnythingContext;
import com.intellij.ide.actions.runAnything.RunAnythingUtil;
import com.intellij.ide.actions.runAnything.activity.RunAnythingNotifiableProvider;
import com.intellij.ide.actions.runAnything.activity.RunAnythingProvider;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.Messages;
import java.util.List;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J$\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u0002H&J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0002H\u0014J\u0010\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0002H\u0016J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/plugins/ruby/ruby/actions/setup/SelectSdkNotifiableProvider;", "Lcom/intellij/ide/actions/runAnything/activity/RunAnythingNotifiableProvider;", "", "<init>", "()V", "oldSdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "findSdk", "project", "Lcom/intellij/openapi/project/Project;", "module", "Lcom/intellij/openapi/module/Module;", "commandLine", "run", "", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "value", "getCommand", "getExecutionContexts", "", "Lcom/intellij/ide/actions/runAnything/RunAnythingContext;", "intellij.ruby.backend"})
public abstract class SelectSdkNotifiableProvider
extends RunAnythingNotifiableProvider<String> {
    @Nullable
    private Sdk oldSdk;

    public SelectSdkNotifiableProvider() {
        RunAnythingNotifiableProvider.notification$default((RunAnythingNotifiableProvider)this, null, arg_0 -> SelectSdkNotifiableProvider._init_$lambda$1(this, arg_0), (int)1, null);
    }

    @Nullable
    public abstract Sdk findSdk(@NotNull Project var1, @Nullable Module var2, @NotNull String var3);

    protected boolean run(@NotNull DataContext dataContext, @NotNull String value) {
        Module module;
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        RunAnythingContext context = (RunAnythingContext)RunAnythingProvider.EXECUTING_CONTEXT.getData(dataContext);
        if (context instanceof RunAnythingContext.ModuleContext) {
            module = ((RunAnythingContext.ModuleContext)context).getModule();
        } else {
            module = (Module)PlatformCoreDataKeys.MODULE.getData(dataContext);
            if (module == null) {
                return false;
            }
        }
        Module module2 = module;
        Project project2 = Objects.requireNonNull(project);
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"requireNonNull(...)");
        Sdk sdk = this.findSdk(project2, module2, value);
        if (sdk == null) {
            return false;
        }
        Sdk sdk2 = sdk;
        this.oldSdk = RModuleUtil.getInstance().findRubySdkForModule(module2);
        boolean isChanged = RModuleUtil.getInstance().changeModuleSdk(sdk2, module2);
        if (!isChanged) {
            Messages.showWarningDialog((Project)RunAnythingUtil.fetchProject((DataContext)dataContext), (String)RBundle.message((String)"run.anything.sdk.notification.warning.content"), (String)RBundle.message((String)"run.anything.sdk.notification.warning.title"));
        }
        return true;
    }

    @NotNull
    public String getCommand(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.getHelpCommand() + " " + value;
    }

    @NotNull
    public List<RunAnythingContext> getExecutionContexts(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        Project project = RunAnythingUtil.fetchProject((DataContext)dataContext);
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"fetchProject(...)");
        return RunAnythingChooseContextAction.Companion.projectAndModulesContexts(project);
    }

    private static final Unit lambda$1$lambda$0(SelectSdkNotifiableProvider this$0, Module $module) {
        RModuleUtil.getInstance().changeModuleSdk(this$0.oldSdk, $module);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(SelectSdkNotifiableProvider this$0, RunAnythingNotifiableProvider.NotificationBuilder $this$notification) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$notification, (String)"$this$notification");
        $this$notification.setTitle(RBundle.message((String)"run.anything.custom.activity.sdk.title"));
        Module module = (Module)PlatformCoreDataKeys.MODULE.getData($this$notification.getDataContext());
        Sdk sdk = RModuleUtil.getInstance().findRubySdkForModule(module);
        if (sdk != null) {
            Object[] objectArray = new Object[]{sdk.getName()};
            String string2 = RBundle.message((String)"run.anything.custom.activity.sdk.message", (Object[])objectArray);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        } else {
            String string3 = RBundle.message((String)"run.anything.custom.activity.no.sdk");
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        }
        $this$notification.setContent(string);
        if (module != null) {
            String string4 = IdeBundle.message((String)"run.anything.custom.activity.rollback.action", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
            $this$notification.action(string4, () -> SelectSdkNotifiableProvider.lambda$1$lambda$0(this$0, module));
        }
        return Unit.INSTANCE;
    }
}

