/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.actions.setup;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.util.ObjectUtils;
import icons.RubyIcons;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.actions.setup.SelectSdkNotifiableProvider;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;
import org.jetbrains.plugins.ruby.version.management.rbenv.gemsets.RbenvGemsetManager;

public final class RbenvSdkNotifiableProvider
extends SelectSdkNotifiableProvider {
    private static final Pattern RBENV_USE_SDK_PATTERN = Pattern.compile("([\\w-.]+)");

    @Override
    @Nullable
    public Sdk findSdk(@NotNull Project project, @Nullable Module module, @NotNull String commandLine) {
        Matcher matcher;
        if (project == null) {
            RbenvSdkNotifiableProvider.$$$reportNull$$$0(0);
        }
        if (commandLine == null) {
            RbenvSdkNotifiableProvider.$$$reportNull$$$0(1);
        }
        String version = (matcher = RBENV_USE_SDK_PATTERN.matcher(commandLine)).matches() ? matcher.group(1) : null;
        return version == null ? null : RbenvGemsetManager.findRootRbenvSdk(version);
    }

    @NonNls
    @NotNull
    public String getHelpCommandPlaceholder() {
        return "rbenv shell <version>";
    }

    @NotNull
    public String getHelpCommand() {
        return "rbenv shell";
    }

    @Nullable
    public String getHelpDescription() {
        return RBundle.message((String)"run.anything.select.rbenv.shell.help.description");
    }

    @Nullable
    public String getHelpGroupTitle() {
        return RBundle.message((String)"run.anything.ruby.help.group.title");
    }

    @NotNull
    public Icon getHelpIcon() {
        Icon icon = RubyIcons.Ruby.Ruby;
        if (icon == null) {
            RbenvSdkNotifiableProvider.$$$reportNull$$$0(2);
        }
        return icon;
    }

    @NotNull
    public Collection<String> getValues(@NotNull DataContext dataContext, @NotNull String pattern) {
        if (dataContext == null) {
            RbenvSdkNotifiableProvider.$$$reportNull$$$0(3);
        }
        if (pattern == null) {
            RbenvSdkNotifiableProvider.$$$reportNull$$$0(4);
        }
        List<String> list = RubySdkUtil.getAllRubySdks().stream().filter(RbenvGemsetManager::isRootRbenvSdk).map(sdk -> (String)ObjectUtils.coalesce((Object)RbenvGemsetManager.getSdkVersion(sdk), (Object)"<undefined>")).toList();
        if (list == null) {
            RbenvSdkNotifiableProvider.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    public String getCompletionGroupTitle() {
        String string = RBundle.message((String)"run.anything.select.rbenv.shell.completion.group");
        if (string == null) {
            RbenvSdkNotifiableProvider.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/actions/setup/RbenvSdkNotifiableProvider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/actions/setup/RbenvSdkNotifiableProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getHelpIcon";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getValues";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompletionGroupTitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findSdk";
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getValues";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 5, 6 -> new IllegalStateException(string);
        };
    }
}

