/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.actions.setup;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import icons.RubyIcons;
import java.util.Arrays;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.actions.setup.SelectSdkNotifiableProvider;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkAdditionalData;
import org.jetbrains.plugins.ruby.version.management.RubyVersionManagerSdkData;
import org.jetbrains.plugins.ruby.version.management.rvm.RVMSupportUtil;
import org.jetbrains.plugins.ruby.version.management.rvm.RvmSdkData;

public final class RVMSdkNotifiableProvider
extends SelectSdkNotifiableProvider {
    private static final Pattern RVM_USE_SDK_PATTERN = Pattern.compile("([\\w-.]+)(?:@([\\w-.]+))?");

    @NotNull
    public Collection<String> getValues(@NotNull DataContext dataContext, @NotNull String pattern) {
        if (dataContext == null) {
            RVMSdkNotifiableProvider.$$$reportNull$$$0(0);
        }
        if (pattern == null) {
            RVMSdkNotifiableProvider.$$$reportNull$$$0(1);
        }
        Collection collection = Arrays.stream(ProjectJdkTable.getInstance().getAllJdks()).filter(sdk -> RVMSupportUtil.isRVMInterpreter(sdk)).map(sdk -> this.getSdkPresentation((Sdk)sdk)).collect(Collectors.toList());
        if (collection == null) {
            RVMSdkNotifiableProvider.$$$reportNull$$$0(2);
        }
        return collection;
    }

    public String getSdkPresentation(@NotNull Sdk sdk) {
        String version;
        if (sdk == null) {
            RVMSdkNotifiableProvider.$$$reportNull$$$0(3);
        }
        if ((version = RVMSupportUtil.getRVMSdkVersion(sdk)) == null) {
            return RBundle.message((String)"run.anything.rvm.use.undefined");
        }
        RubyVersionManagerSdkData versionManagerSdkAdditionalData = ((RubySdkAdditionalData)sdk.getSdkAdditionalData()).getVersionManagerSdkAdditionalData();
        assert (versionManagerSdkAdditionalData instanceof RvmSdkData);
        String gemset = ((RvmSdkData)versionManagerSdkAdditionalData).getGemsetName();
        return gemset != null ? version + "@" + gemset : version;
    }

    @NotNull
    public String getCompletionGroupTitle() {
        String string = RBundle.message((String)"run.anything.rvm.use.group.title");
        if (string == null) {
            RVMSdkNotifiableProvider.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    @Nullable
    public Sdk findSdk(@NotNull Project project, @Nullable Module module, @NotNull String commandLine) {
        if (project == null) {
            RVMSdkNotifiableProvider.$$$reportNull$$$0(5);
        }
        if (commandLine == null) {
            RVMSdkNotifiableProvider.$$$reportNull$$$0(6);
        }
        Matcher matcher = RVM_USE_SDK_PATTERN.matcher(commandLine);
        Object version = null;
        String gemset = null;
        if (matcher.matches()) {
            version = matcher.group(1);
            gemset = matcher.group(2);
        }
        if (version == null) {
            return null;
        }
        if (!((String)version).startsWith("ruby")) {
            version = "ruby-" + (String)version;
        }
        return RVMSupportUtil.findSdkBy((String)version, gemset);
    }

    @NonNls
    @NotNull
    public String getHelpCommandPlaceholder() {
        return "rvm use <version>";
    }

    @NotNull
    public String getHelpCommand() {
        return "rvm use";
    }

    @Nullable
    public String getHelpDescription() {
        return RBundle.message((String)"run.anything.rvm.sdk");
    }

    @Nullable
    public String getHelpGroupTitle() {
        return RBundle.message((String)"run.anything.ruby.help.group.title");
    }

    @NotNull
    public Icon getHelpIcon() {
        Icon icon = RubyIcons.Ruby.Ruby;
        if (icon == null) {
            RVMSdkNotifiableProvider.$$$reportNull$$$0(7);
        }
        return icon;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/actions/setup/RVMSdkNotifiableProvider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/actions/setup/RVMSdkNotifiableProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getValues";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompletionGroupTitle";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getHelpIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getValues";
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSdkPresentation";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findSdk";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 7 -> new IllegalStateException(string);
        };
    }
}

