/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.actions.providers.runConfigurations;

import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.run.configuration.server.RailsServerRunConfiguration;
import org.jetbrains.plugins.ruby.rails.run.configuration.server.RailsServerRunConfigurationType;
import org.jetbrains.plugins.ruby.ruby.actions.providers.runConfigurations.RubyMatchedRunConfigurationProvider;

public final class RailsServerRunAnythingProvider
extends RubyMatchedRunConfigurationProvider<RailsServerRunConfiguration> {
    private static final Pattern EXEC_COMMAND_PATTERN = Pattern.compile("rails s(?:erver)?(\\s+.*)?");

    @Nullable
    public String getHelpCommand() {
        return "rails server";
    }

    @NotNull
    public ConfigurationFactory getConfigurationFactory() {
        ConfigurationFactory configurationFactory = RailsServerRunConfigurationType.getInstance().getConfigurationFactories()[0];
        if (configurationFactory == null) {
            RailsServerRunAnythingProvider.$$$reportNull$$$0(0);
        }
        return configurationFactory;
    }

    @Override
    @NotNull
    protected Pattern getExecCommandPattern() {
        Pattern pattern = EXEC_COMMAND_PATTERN;
        if (pattern == null) {
            RailsServerRunAnythingProvider.$$$reportNull$$$0(1);
        }
        return pattern;
    }

    @Override
    protected void extendConfiguration(@NotNull RailsServerRunConfiguration configuration, @Nullable VirtualFile baseDirectory, @NotNull String commandLine) {
        if (configuration == null) {
            RailsServerRunAnythingProvider.$$$reportNull$$$0(2);
        }
        if (commandLine == null) {
            RailsServerRunAnythingProvider.$$$reportNull$$$0(3);
        }
        ArrayList<String> serverOptions = new ArrayList<String>();
        State state = State.SERVER;
        for (String argument : this.getArguments(commandLine)) {
            if (!StringUtil.startsWith((CharSequence)argument, (CharSequence)"-")) {
                switch (state) {
                    case SERVER: {
                        configuration.setServerType(argument);
                        break;
                    }
                    case PORT: {
                        configuration.setPort(argument);
                        break;
                    }
                    case IP: {
                        configuration.setIPAddr(argument);
                        break;
                    }
                    case ENV: {
                        configuration.setRailsEnvironmentType(argument);
                    }
                }
                continue;
            }
            if (argument.equals("-p") || argument.equals("--port")) {
                state = State.PORT;
                continue;
            }
            if (argument.equals("-b") || argument.equals("--binding")) {
                state = State.IP;
                continue;
            }
            if (argument.equals("-e") || argument.equals("--environment")) {
                state = State.ENV;
                continue;
            }
            if (!argument.startsWith("-") || argument.length() <= 1) continue;
            serverOptions.add(argument);
        }
        RailsServerRunAnythingProvider.appendParameters((Consumer<? super String>)((Consumer)parameter -> configuration.setScriptArgs((String)parameter)), (Computable<String>)((Computable)() -> configuration.getScriptArgs()), serverOptions);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/actions/providers/runConfigurations/RailsServerRunAnythingProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationFactory";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getExecCommandPattern";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/actions/providers/runConfigurations/RailsServerRunAnythingProvider";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "extendConfiguration";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3 -> new IllegalArgumentException(string);
        };
    }

    static enum State {
        SERVER,
        PORT,
        IP,
        ENV;

    }
}

