/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.actions.providers.runConfigurations;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Computable;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.console.config.IrbConsoleType;
import org.jetbrains.plugins.ruby.console.config.IrbRunConfiguration;
import org.jetbrains.plugins.ruby.rails.RailsUtil;
import org.jetbrains.plugins.ruby.rails.run.configuration.RailsRunConfigurationUtil;
import org.jetbrains.plugins.ruby.ruby.actions.providers.runConfigurations.IrbConsoleRunAnythingProvider;

public final class RailsConsoleRunAnythingProvider
extends IrbConsoleRunAnythingProvider {
    private static final Logger LOG = Logger.getInstance(RailsConsoleRunAnythingProvider.class);
    private static final String EXEC_COMMAND = "rails console";
    private static final String EXEC_COMMAND_SHORT = "rails c";
    private static final Pattern EXEC_COMMAND_PATTERN = Pattern.compile("rails c(?:onsole)?(\\s+.*)?");

    @Override
    @NotNull
    public String getHelpCommand() {
        return EXEC_COMMAND;
    }

    @Override
    @NotNull
    protected Pattern getExecCommandPattern() {
        Pattern pattern = EXEC_COMMAND_PATTERN;
        if (pattern == null) {
            RailsConsoleRunAnythingProvider.$$$reportNull$$$0(0);
        }
        return pattern;
    }

    @Override
    @Nullable
    protected String getExecutablePath(@NotNull Sdk sdk, @NotNull Module module) {
        if (sdk == null) {
            RailsConsoleRunAnythingProvider.$$$reportNull$$$0(1);
        }
        if (module == null) {
            RailsConsoleRunAnythingProvider.$$$reportNull$$$0(2);
        }
        if (!RailsUtil.hasRailsSupportInSDKOrModule(sdk, module)) {
            LOG.debug("No Rails support found");
            return null;
        }
        return RailsRunConfigurationUtil.getConsoleExecutablePath(module, false);
    }

    @Override
    @NotNull
    protected IrbConsoleType getConsoleType() {
        IrbConsoleType irbConsoleType = IrbConsoleType.RAILS;
        if (irbConsoleType == null) {
            RailsConsoleRunAnythingProvider.$$$reportNull$$$0(3);
        }
        return irbConsoleType;
    }

    @Override
    protected void setDirectoryAndCommandLine(@NotNull IrbRunConfiguration configuration, @NotNull String commandLine, @NotNull Sdk sdk, @NotNull Module module) {
        if (configuration == null) {
            RailsConsoleRunAnythingProvider.$$$reportNull$$$0(4);
        }
        if (commandLine == null) {
            RailsConsoleRunAnythingProvider.$$$reportNull$$$0(5);
        }
        if (sdk == null) {
            RailsConsoleRunAnythingProvider.$$$reportNull$$$0(6);
        }
        if (module == null) {
            RailsConsoleRunAnythingProvider.$$$reportNull$$$0(7);
        }
        if (!((String)commandLine).startsWith(EXEC_COMMAND)) {
            commandLine = EXEC_COMMAND + ((String)commandLine).substring(EXEC_COMMAND_SHORT.length());
            configuration.setName((String)commandLine);
        }
        RailsRunConfigurationUtil.setWorkingDirectory(module, configuration);
        RailsConsoleRunAnythingProvider.appendParameters((Consumer<? super String>)((Consumer)configuration::setScriptArgs), (Computable<String>)((Computable)configuration::getScriptArgs), ContainerUtil.prepend(List.of(this.getArguments((String)commandLine)), (Object[])new String[]{"console"}));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 4, 5, 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/actions/providers/runConfigurations/RailsConsoleRunAnythingProvider";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getExecCommandPattern";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/actions/providers/runConfigurations/RailsConsoleRunAnythingProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getConsoleType";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getExecutablePath";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setDirectoryAndCommandLine";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 4, 5, 6, 7 -> new IllegalArgumentException(string);
        };
    }
}

