/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.actions.intention.stringsSymbols;

import com.intellij.codeInsight.intention.BaseElementAtCaretIntentionAction;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.parser.RubyElementTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactoryCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.basicTypes.stringLiterals.RBaseStringImpl;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.expressions.RMathBinExpressionImpl;

public final class StringSumToSubstitutionIntention
extends BaseElementAtCaretIntentionAction
implements DumbAware {
    private static final char[] ESCAPED_CHARS = new char[]{'\u0007', '\b', '\u001b', '\u001b', '\n', '\r', '\t', '\u000b'};

    @NotNull
    public String getText() {
        String string = RBundle.message((String)"ruby.intentions.string.sum.to.substitution");
        if (string == null) {
            StringSumToSubstitutionIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    @IntentionFamilyName
    public String getFamilyName() {
        String string = RBundle.message((String)"ruby.intentions.string.sum.to.substitution");
        if (string == null) {
            StringSumToSubstitutionIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) {
        RMathBinExpressionImpl binExpression;
        if (project == null) {
            StringSumToSubstitutionIntention.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            StringSumToSubstitutionIntention.$$$reportNull$$$0(3);
        }
        if (element == null) {
            StringSumToSubstitutionIntention.$$$reportNull$$$0(4);
        }
        if ((binExpression = (RMathBinExpressionImpl)PsiTreeUtil.getParentOfType((PsiElement)element, RMathBinExpressionImpl.class)) == null) {
            return false;
        }
        return ContainerUtil.or(StringSumToSubstitutionIntention.getSumArguments((RPsiElement)binExpression), argument -> argument instanceof RBaseStringImpl);
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        RMathBinExpressionImpl mathBinExpression;
        if (project == null) {
            StringSumToSubstitutionIntention.$$$reportNull$$$0(5);
        }
        if (editor == null) {
            StringSumToSubstitutionIntention.$$$reportNull$$$0(6);
        }
        if (element == null) {
            StringSumToSubstitutionIntention.$$$reportNull$$$0(7);
        }
        if ((mathBinExpression = (RMathBinExpressionImpl)PsiTreeUtil.getParentOfType((PsiElement)element, RMathBinExpressionImpl.class)) == null) {
            return;
        }
        PsiElement parent = mathBinExpression.getParent();
        while (parent instanceof RMathBinExpressionImpl) {
            mathBinExpression = (RMathBinExpressionImpl)parent;
            parent = parent.getParent();
        }
        Object replacementText = StringSumToSubstitutionIntention.calculateReplacement(mathBinExpression);
        replacementText = "\"" + (String)replacementText + "\"";
        RExpression generated = RubyElementFactoryCore.createExpressionFromText((PsiElement)element, (String)replacementText);
        mathBinExpression.replace((PsiElement)generated);
    }

    @NotNull
    private static String escapeReplacementString(@NotNull String replacementText) {
        if (replacementText == null) {
            StringSumToSubstitutionIntention.$$$reportNull$$$0(8);
        }
        replacementText = replacementText.replaceAll("\\\\'", "'");
        replacementText = StringSumToSubstitutionIntention.escapeBackslashes(replacementText);
        replacementText = StringUtil.escapeQuotes((String)replacementText);
        String string = StringUtil.escapeChars((String)replacementText, (char[])ESCAPED_CHARS);
        if (string == null) {
            StringSumToSubstitutionIntention.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    private static String escapeBackslashes(@NotNull String replacementText) {
        if (replacementText == null) {
            StringSumToSubstitutionIntention.$$$reportNull$$$0(10);
        }
        Pattern p = Pattern.compile("((?:\\\\\\\\)*)[\\\\]([^\\\\])");
        Matcher m = p.matcher(replacementText);
        StringBuilder sb = new StringBuilder();
        while (m.find()) {
            m.appendReplacement(sb, "$1\\\\\\\\$2");
        }
        m.appendTail(sb);
        String string = sb.toString();
        if (string == null) {
            StringSumToSubstitutionIntention.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    private static String calculateReplacement(@NotNull RMathBinExpressionImpl expression) {
        if (expression == null) {
            StringSumToSubstitutionIntention.$$$reportNull$$$0(12);
        }
        StringBuilder replacement = new StringBuilder();
        List<PsiElement> args = StringSumToSubstitutionIntention.getSumArguments((RPsiElement)expression);
        for (PsiElement arg : args) {
            replacement.append(StringSumToSubstitutionIntention.processArgument(arg));
        }
        String string = replacement.toString();
        if (string == null) {
            StringSumToSubstitutionIntention.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    private static List<PsiElement> getSumArguments(@NotNull RPsiElement expression) {
        if (expression == null) {
            StringSumToSubstitutionIntention.$$$reportNull$$$0(14);
        }
        if (expression instanceof RMathBinExpressionImpl && ((RMathBinExpressionImpl)expression).getOperationType() == RubyTokenTypes.tPLUS) {
            RPsiElement left = ((RMathBinExpressionImpl)expression).getLeftOperand();
            RPsiElement right = ((RMathBinExpressionImpl)expression).getRightOperand();
            if (right != null) {
                LinkedList<PsiElement> result = new LinkedList<PsiElement>();
                result.addAll(StringSumToSubstitutionIntention.getSumArguments(left));
                result.addAll(StringSumToSubstitutionIntention.getSumArguments(right));
                LinkedList<PsiElement> linkedList = result;
                if (linkedList == null) {
                    StringSumToSubstitutionIntention.$$$reportNull$$$0(15);
                }
                return linkedList;
            }
        }
        LinkedList<PsiElement> result = new LinkedList<PsiElement>();
        result.add((PsiElement)expression);
        LinkedList<PsiElement> linkedList = result;
        if (linkedList == null) {
            StringSumToSubstitutionIntention.$$$reportNull$$$0(16);
        }
        return linkedList;
    }

    @NotNull
    private static String processArgument(@NotNull PsiElement arg) {
        if (arg == null) {
            StringSumToSubstitutionIntention.$$$reportNull$$$0(17);
        }
        StringBuilder content = new StringBuilder();
        if (arg instanceof RBaseStringImpl) {
            RBaseStringImpl rBaseString = (RBaseStringImpl)arg;
            for (PsiElement element : rBaseString.getPsiContent()) {
                content.append(element.getText());
            }
            if (rBaseString.getNode().getElementType() == RubyElementTypes.NI_STRING) {
                return StringSumToSubstitutionIntention.escapeReplacementString(content.toString());
            }
            String string = content.toString();
            if (string == null) {
                StringSumToSubstitutionIntention.$$$reportNull$$$0(18);
            }
            return string;
        }
        String string = content.append("#{").append(arg.getText()).append("}").toString();
        if (string == null) {
            StringSumToSubstitutionIntention.$$$reportNull$$$0(19);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6, 7, 8, 10, 12, 14, 17 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/actions/intention/stringsSymbols/StringSumToSubstitutionIntention";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacementText";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arg";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/actions/intention/stringsSymbols/StringSumToSubstitutionIntention";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeReplacementString";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeBackslashes";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateReplacement";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getSumArguments";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "processArgument";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "escapeReplacementString";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "escapeBackslashes";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "calculateReplacement";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getSumArguments";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "processArgument";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6, 7, 8, 10, 12, 14, 17 -> new IllegalArgumentException(string);
        };
    }
}

