/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.actions.intention.stringsSymbols;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyHeredocUtil;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactoryCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.heredocs.RHeredocId;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.heredocs.RHeredocValue;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.basicTypes.stringLiterals.heredocs.RHeredocValueImpl;
import org.jetbrains.plugins.ruby.ruby.sdk.LanguageLevel;

public final class HeredocToSquigglyIntention
extends PsiElementBaseIntentionAction
implements DumbAware {
    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        RHeredocId id;
        if (project == null) {
            HeredocToSquigglyIntention.$$$reportNull$$$0(0);
        }
        if (element == null) {
            HeredocToSquigglyIntention.$$$reportNull$$$0(1);
        }
        if ((id = HeredocToSquigglyIntention.findHeredocId(element)) == null) {
            return;
        }
        RHeredocValue value = id.getHeredocValue();
        if (value == null) {
            return;
        }
        String dummyHeredoc = "<<~" + id.getId() + "\n" + id.getId();
        RFile file = RubyElementFactoryCore.createRubyFile((Project)project, (String)dummyHeredoc, (LanguageLevel)LanguageLevel.RUBY23);
        if (file == null) {
            throw new IncorrectOperationException("Dummy ruby file is null");
        }
        RHeredocId newId = (RHeredocId)PsiTreeUtil.findChildOfType((PsiElement)file, RHeredocId.class);
        PsiElement newHeredocEnd = PsiTreeUtil.getDeepestLast((PsiElement)file);
        if (newId == null || newHeredocEnd.getNode().getElementType() != RubyTokenTypes.tHEREDOC_INDENTED_END) {
            throw new IncorrectOperationException("Could not construct dummy id");
        }
        PsiFile containingFile = value.getContainingFile();
        PsiElement actualHeredocEnd = HeredocToSquigglyIntention.findHeredocEnd(value);
        id.replace((PsiElement)newId);
        if (actualHeredocEnd != null) {
            actualHeredocEnd = actualHeredocEnd.replace(newHeredocEnd);
        }
        PsiElement endElement = actualHeredocEnd != null ? actualHeredocEnd : value;
        CodeStyleManager.getInstance((Project)project).reformatText(containingFile, value.getTextRange().getStartOffset(), endElement.getTextRange().getEndOffset());
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            HeredocToSquigglyIntention.$$$reportNull$$$0(2);
        }
        if (element == null) {
            HeredocToSquigglyIntention.$$$reportNull$$$0(3);
        }
        if (RubyPsiUtilCore.getLanguageLevel((PsiElement)element).isLessThan(LanguageLevel.RUBY23)) {
            return false;
        }
        RHeredocId id = HeredocToSquigglyIntention.findHeredocId(element);
        if (id == null || RubyHeredocUtil.isSquiggly((String)id.getIdPrefix())) {
            return false;
        }
        RHeredocValue value = id.getHeredocValue();
        if (value == null) {
            return false;
        }
        String text = value.getText();
        if (text.isEmpty()) {
            return true;
        }
        if (StringUtil.isEmptyOrSpaces((String)text) && StringUtil.containsAnyChar((String)text, (String)" \t")) {
            return false;
        }
        return RHeredocValueImpl.getIndentForLines((List)StringUtil.split((CharSequence)text, (CharSequence)"\n")) == 0;
    }

    @NotNull
    @Nls
    public String getFamilyName() {
        String string = RBundle.message((String)"ruby.intentions.heredoc.to.squiggly.name");
        if (string == null) {
            HeredocToSquigglyIntention.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = RBundle.message((String)"ruby.intentions.heredoc.to.squiggly.name");
        if (string == null) {
            HeredocToSquigglyIntention.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Nullable
    private static RHeredocId findHeredocId(@NotNull PsiElement element) {
        if (element == null) {
            HeredocToSquigglyIntention.$$$reportNull$$$0(6);
        }
        PsiElement parent = element.getParent();
        if (element instanceof RHeredocId) {
            return (RHeredocId)element;
        }
        if (parent instanceof RHeredocId) {
            return (RHeredocId)parent;
        }
        if (element instanceof RHeredocValue) {
            return ((RHeredocValue)element).getIdElement();
        }
        if (parent instanceof RHeredocValue) {
            return ((RHeredocValue)parent).getIdElement();
        }
        return null;
    }

    @Nullable
    private static PsiElement findHeredocEnd(@NotNull RHeredocValue value) {
        PsiElement sibling;
        if (value == null) {
            HeredocToSquigglyIntention.$$$reportNull$$$0(7);
        }
        if ((sibling = PsiTreeUtil.nextVisibleLeaf((PsiElement)value)) == null) {
            return null;
        }
        IElementType type = sibling.getNode().getElementType();
        if (type == RubyTokenTypes.tHEREDOC_INDENTED_END || type == RubyTokenTypes.tHEREDOC_END) {
            return sibling;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/actions/intention/stringsSymbols/HeredocToSquigglyIntention";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/actions/intention/stringsSymbols/HeredocToSquigglyIntention";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findHeredocId";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findHeredocEnd";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5 -> new IllegalStateException(string);
        };
    }
}

