/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.actions.intention.operators;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.text.UniqueNameGenerator;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.actions.intention.operators.AbstractSafeNavigationToPlainCheckIntention;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.ScopeUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactoryCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlFlow.impl.RControlFlowBuilder;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RCondition;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RIfStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RDotReference;

final class SafeNavigationToMultipleIfsIntention
extends AbstractSafeNavigationToPlainCheckIntention
implements DumbAware {
    SafeNavigationToMultipleIfsIntention() {
    }

    @NotNull
    @Nls
    public String getText() {
        String string = RBundle.message((String)"inspection.ruby.safe.nav.to.multiple.ifs.intention.name");
        if (string == null) {
            SafeNavigationToMultipleIfsIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    @Nls
    public String getFamilyName() {
        String string = RBundle.message((String)"inspection.ruby.safe.nav.to.multiple.ifs.intention.name");
        if (string == null) {
            SafeNavigationToMultipleIfsIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static String createExpressionString(@NotNull RDotReference deepest, @NotNull RDotReference topmost, @NotNull Function<String, String> producerForInternals) {
        if (deepest == null) {
            SafeNavigationToMultipleIfsIntention.$$$reportNull$$$0(2);
        }
        if (topmost == null) {
            SafeNavigationToMultipleIfsIntention.$$$reportNull$$$0(3);
        }
        if (producerForInternals == null) {
            SafeNavigationToMultipleIfsIntention.$$$reportNull$$$0(4);
        }
        if (!PsiTreeUtil.isAncestor((PsiElement)topmost, (PsiElement)deepest, (boolean)false)) {
            throw new AssertionError((Object)(String.valueOf(deepest) + "\n" + String.valueOf(topmost)));
        }
        Collection scopeVariableNames = (Collection)ObjectUtils.doIfNotNull((Object)RControlFlowBuilder.getControlFlowNodeElement((PsiElement)topmost), ScopeUtil::collectScopeVariableNames);
        if (scopeVariableNames == null) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        StringBuilder variableName = new StringBuilder();
        int ifs = 0;
        String lastVarName = "";
        if (deepest.getReceiver() != null) {
            String receiverText = deepest.getReceiver().getText();
            String varNameStart = StringUtil.trimTrailing((String)receiverText.replaceAll("[^a-zA-Z0-9]", "_"), (char)'_');
            variableName.append(varNameStart);
            if (!receiverText.equals(varNameStart)) {
                lastVarName = SafeNavigationToMultipleIfsIntention.getUniqueVarName(scopeVariableNames, varNameStart.replaceAll("[!?]", ""));
                result.append(lastVarName).append(" = ").append(receiverText).append("\n");
            } else {
                lastVarName = varNameStart;
            }
            result.append("if ").append(lastVarName).append(" != nil").append("\n");
            ++ifs;
        }
        RDotReference current = deepest;
        while (true) {
            String qualifier = current.getValue() != null ? current.getValue().getText() : "";
            variableName.append('_').append(qualifier);
            String realVarName = SafeNavigationToMultipleIfsIntention.getUniqueVarName(scopeVariableNames, variableName.toString().replaceAll("[!?]", ""));
            result.append(realVarName).append(" = ").append(lastVarName).append(".").append(qualifier).append("\n");
            if (current != topmost) {
                result.append("if ").append(realVarName).append(" != nil").append("\n");
                ++ifs;
            }
            lastVarName = realVarName;
            if (current == topmost) {
                result.append((String)producerForInternals.fun((Object)realVarName));
                break;
            }
            current = (RDotReference)current.getParent();
        }
        while (ifs-- > 0) {
            result.append("end\n");
        }
        return result.toString();
    }

    @NotNull
    private static String getUniqueVarName(@NotNull Collection<String> reservedNames, @NotNull String desiredName) {
        if (reservedNames == null) {
            SafeNavigationToMultipleIfsIntention.$$$reportNull$$$0(5);
        }
        if (desiredName == null) {
            SafeNavigationToMultipleIfsIntention.$$$reportNull$$$0(6);
        }
        String string = UniqueNameGenerator.generateUniqueName((String)desiredName, candidate -> !reservedNames.contains(candidate));
        if (string == null) {
            SafeNavigationToMultipleIfsIntention.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static void replaceElementWithRange(@NotNull PsiElement toDelete, @NotNull PsiElement firstInRange, @NotNull PsiElement lastInRange) {
        if (toDelete == null) {
            SafeNavigationToMultipleIfsIntention.$$$reportNull$$$0(8);
        }
        if (firstInRange == null) {
            SafeNavigationToMultipleIfsIntention.$$$reportNull$$$0(9);
        }
        if (lastInRange == null) {
            SafeNavigationToMultipleIfsIntention.$$$reportNull$$$0(10);
        }
        ASTNode parentNode = toDelete.getParent().getNode();
        parentNode.addChildren(firstInRange.getNode(), lastInRange.getNode().getTreeNext(), toDelete.getNode());
        parentNode.removeRange(toDelete.getNode(), toDelete.getNode().getTreeNext());
    }

    @Override
    protected void processReplacement(@NotNull RDotReference deepest, @NotNull RDotReference topmost) {
        boolean wouldReplaceIf;
        RIfStatement ifStatement;
        if (deepest == null) {
            SafeNavigationToMultipleIfsIntention.$$$reportNull$$$0(11);
        }
        if (topmost == null) {
            SafeNavigationToMultipleIfsIntention.$$$reportNull$$$0(12);
        }
        if (topmost.getParent() instanceof RCondition && topmost.getParent().getParent() instanceof RIfStatement) {
            ifStatement = (RIfStatement)topmost.getParent().getParent();
            wouldReplaceIf = ifStatement.getElseBlock() == null && ifStatement.getElsifBlocks().isEmpty();
        } else {
            ifStatement = null;
            wouldReplaceIf = false;
        }
        Function internals = wouldReplaceIf ? lastVarName -> {
            RCompoundStatement thenBlock = ifStatement.getThenBlock();
            return "if " + lastVarName + "\n" + (thenBlock != null ? thenBlock.getText() : "") + "\n" + "end\n";
        } : lastVarName -> "";
        Object newExpression = SafeNavigationToMultipleIfsIntention.createExpressionString(deepest, topmost, (Function<String, String>)internals);
        if (!wouldReplaceIf) {
            newExpression = "(" + (String)newExpression + ")";
        }
        List elementsToSet = RubyElementFactoryCore.getNotEmptyTopLevelElements((PsiElement)topmost, (String)newExpression);
        RIfStatement elementToReplace = wouldReplaceIf ? ifStatement : topmost;
        SafeNavigationToMultipleIfsIntention.replaceElementWithRange((PsiElement)elementToReplace, (PsiElement)elementsToSet.get(0), (PsiElement)elementsToSet.get(elementsToSet.size() - 1));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6, 8, 9, 10, 11, 12 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/actions/intention/operators/SafeNavigationToMultipleIfsIntention";
                break;
            }
            case 2: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deepest";
                break;
            }
            case 3: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topmost";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "producerForInternals";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reservedNames";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "desiredName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toDelete";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstInRange";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lastInRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/actions/intention/operators/SafeNavigationToMultipleIfsIntention";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getUniqueVarName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createExpressionString";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getUniqueVarName";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "replaceElementWithRange";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "processReplacement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6, 8, 9, 10, 11, 12 -> new IllegalArgumentException(string);
        };
    }
}

