/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.actions.intention.operators;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ThreeState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.actions.intention.RubyMutablyNamedIntention;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.parser.bnf.TokenBNF;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactoryCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RBinaryExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RBoolMatchingExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.expressions.RBoolMatchingImpl;

public final class RubyFlipExpressionIntention
extends RubyMutablyNamedIntention<RBinaryExpression>
implements DumbAware {
    @NotNull
    public String getFamilyName() {
        String string = RBundle.message((String)"ruby.intentions.flip.expression");
        if (string == null) {
            RubyFlipExpressionIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        RBinaryExpression expression;
        if (project == null) {
            RubyFlipExpressionIntention.$$$reportNull$$$0(1);
        }
        if (editor == null) {
            RubyFlipExpressionIntention.$$$reportNull$$$0(2);
        }
        if (element == null) {
            RubyFlipExpressionIntention.$$$reportNull$$$0(3);
        }
        if ((expression = (RBinaryExpression)PsiTreeUtil.getParentOfType((PsiElement)element, RBinaryExpression.class)) instanceof RBoolMatchingExpression) {
            RubyFlipExpressionIntention.invokeMatchingExpression(element.getContainingFile(), (RBoolMatchingExpression)expression);
        } else if (expression != null) {
            RubyFlipExpressionIntention.invokeBinExpression(element.getContainingFile(), expression);
        }
    }

    @Override
    @Nullable
    protected String getTextForElement(@NotNull RBinaryExpression expression) {
        IElementType operation;
        if (expression == null) {
            RubyFlipExpressionIntention.$$$reportNull$$$0(4);
        }
        if (RubyFlipExpressionIntention.isCommutative(operation = expression.getOperationType())) {
            return RBundle.message((String)"ruby.intentions.flip", (Object[])new Object[]{operation});
        }
        IElementType reversedOperation = RBoolMatchingImpl.getReversedComparisonOperation((IElementType)operation);
        if (reversedOperation != null) {
            return RBundle.message((String)"ruby.intentions.flip.matching.operation", (Object[])new Object[]{operation.toString(), reversedOperation.toString()});
        }
        if (TokenBNF.tRANGE_TOKENS.contains(operation)) {
            return null;
        }
        return RBundle.message((String)"ruby.intentions.flip.changes.semantics", (Object[])new Object[]{operation});
    }

    @Override
    @Nullable
    protected RBinaryExpression findMatchingElement(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) {
        RBinaryExpression binaryExpression;
        if (project == null) {
            RubyFlipExpressionIntention.$$$reportNull$$$0(5);
        }
        if (editor == null) {
            RubyFlipExpressionIntention.$$$reportNull$$$0(6);
        }
        if (element == null) {
            RubyFlipExpressionIntention.$$$reportNull$$$0(7);
        }
        if ((binaryExpression = (RBinaryExpression)PsiTreeUtil.getParentOfType((PsiElement)element, RBinaryExpression.class)) != null && binaryExpression.getLeftOperand() != null && binaryExpression.getRightOperand() != null) {
            return binaryExpression;
        }
        return null;
    }

    private static boolean isCommutative(IElementType operation) {
        return RBoolMatchingImpl.isSymmetricOperation((IElementType)operation) == ThreeState.YES || operation == RubyTokenTypes.tPLUS || operation == RubyTokenTypes.tMULT || TokenBNF.tBIT_OPS.contains(operation);
    }

    private static void invokeBinExpression(@NotNull PsiFile file, @NotNull RBinaryExpression binExpression) {
        if (file == null) {
            RubyFlipExpressionIntention.$$$reportNull$$$0(8);
        }
        if (binExpression == null) {
            RubyFlipExpressionIntention.$$$reportNull$$$0(9);
        }
        if (binExpression.getRightOperand() == null) {
            return;
        }
        RubyFlipExpressionIntention.flipWithOperation(file, binExpression, binExpression.getOperation().getText());
    }

    private static void invokeMatchingExpression(@NotNull PsiFile file, @NotNull RBoolMatchingExpression matchingExpression) {
        if (file == null) {
            RubyFlipExpressionIntention.$$$reportNull$$$0(10);
        }
        if (matchingExpression == null) {
            RubyFlipExpressionIntention.$$$reportNull$$$0(11);
        }
        if (matchingExpression.getRightOperand() == null) {
            return;
        }
        if (RBoolMatchingImpl.isSymmetricOperation((IElementType)matchingExpression.getOperationType()) == ThreeState.YES) {
            RubyFlipExpressionIntention.flipWithOperation(file, (RBinaryExpression)matchingExpression, matchingExpression.getOperation().getText());
        } else {
            IElementType reversedOperation = RBoolMatchingImpl.getReversedComparisonOperation((IElementType)matchingExpression.getOperationType());
            if (reversedOperation == null) {
                reversedOperation = matchingExpression.getOperationType();
            }
            RubyFlipExpressionIntention.flipWithOperation(file, (RBinaryExpression)matchingExpression, reversedOperation.toString());
        }
    }

    private static void flipWithOperation(@NotNull PsiFile file, @NotNull RBinaryExpression binaryExpression, @NotNull String operationText) {
        if (file == null) {
            RubyFlipExpressionIntention.$$$reportNull$$$0(12);
        }
        if (binaryExpression == null) {
            RubyFlipExpressionIntention.$$$reportNull$$$0(13);
        }
        if (operationText == null) {
            RubyFlipExpressionIntention.$$$reportNull$$$0(14);
        }
        if (binaryExpression.getLeftOperand() == null || binaryExpression.getRightOperand() == null) {
            return;
        }
        RPsiElement generated = RubyElementFactoryCore.createElementFromText((PsiElement)file, (String)(binaryExpression.getRightOperand().getText() + " " + operationText + " " + binaryExpression.getLeftOperand().getText()));
        binaryExpression.replace((PsiElement)generated);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/actions/intention/operators/RubyFlipExpressionIntention";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 8: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binExpression";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchingExpression";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryExpression";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operationText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/actions/intention/operators/RubyFlipExpressionIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getTextForElement";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findMatchingElement";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "invokeBinExpression";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "invokeMatchingExpression";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "flipWithOperation";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14 -> new IllegalArgumentException(string);
        };
    }
}

