/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.actions.intention.i18n;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.BaseElementAtCaretIntentionAction;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.i18n.I18nTranslateCallType;
import org.jetbrains.plugins.ruby.i18n.dictionary.I18nDictionary;
import org.jetbrains.plugins.ruby.i18n.references.RailsI18nTranslateCallReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.RSymbol;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.basicTypes.RSymbolNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.basicTypes.stringLiterals.RBaseStringImpl;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.methodCall.RCallNavigator;

public final class RubyExpandLazyI18nKeyIntention
extends BaseElementAtCaretIntentionAction {
    @IntentionFamilyName
    @NotNull
    public String getFamilyName() {
        String string = RBundle.message((String)"ruby.intentions.i18n.expand.key");
        if (string == null) {
            RubyExpandLazyI18nKeyIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @IntentionName
    @NotNull
    public String getText() {
        String string = RBundle.message((String)"ruby.intentions.i18n.expand.key");
        if (string == null) {
            RubyExpandLazyI18nKeyIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            RubyExpandLazyI18nKeyIntention.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            RubyExpandLazyI18nKeyIntention.$$$reportNull$$$0(3);
        }
        if (element == null) {
            RubyExpandLazyI18nKeyIntention.$$$reportNull$$$0(4);
        }
        RPossibleCall call = RubyExpandLazyI18nKeyIntention.getCallByFirstSimpleArgument(element);
        assert (call != null);
        RailsI18nTranslateCallReference reference = (RailsI18nTranslateCallReference)ContainerUtil.findInstance((Object[])call.getReferences(), RailsI18nTranslateCallReference.class);
        assert (reference != null);
        I18nDictionary dictionary = I18nDictionary.forElement(element);
        assert (dictionary != null);
        List<String> keys = RubyExpandLazyI18nKeyIntention.getFullKeysWithoutScope(reference, dictionary);
        if (keys.size() == 1 || ApplicationManager.getApplication().isUnitTestMode()) {
            WriteAction.run(() -> RubyExpandLazyI18nKeyIntention.invoke(call, (String)keys.get(0)));
            return;
        }
        JBPopup popup = JBPopupFactory.getInstance().createPopupChooserBuilder(ContainerUtil.sorted(keys)).setRenderer((ListCellRenderer)new ColoredListCellRenderer<String>(){

            protected void customizeCellRenderer(@NotNull JList<? extends String> list, @NlsSafe String value, int index, boolean selected, boolean hasFocus) {
                if (list == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.setIcon(PlatformIcons.PROPERTY_ICON);
                this.append(value);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "org/jetbrains/plugins/ruby/ruby/actions/intention/i18n/RubyExpandLazyI18nKeyIntention$1", "customizeCellRenderer"));
            }
        }).setNamerForFiltering(Object::toString).setItemChosenCallback(key -> {
            @NlsSafe String commandName = StringUtil.toTitleCase((String)this.getText());
            WriteCommandAction.runWriteCommandAction((Project)project, (String)commandName, null, () -> RubyExpandLazyI18nKeyIntention.invoke(call, key), (PsiFile[])new PsiFile[0]);
        }).createPopup();
        popup.showInBestPositionFor(editor);
    }

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) {
        RPossibleCall call;
        if (project == null) {
            RubyExpandLazyI18nKeyIntention.$$$reportNull$$$0(5);
        }
        if (editor == null) {
            RubyExpandLazyI18nKeyIntention.$$$reportNull$$$0(6);
        }
        if (element == null) {
            RubyExpandLazyI18nKeyIntention.$$$reportNull$$$0(7);
        }
        if ((call = RubyExpandLazyI18nKeyIntention.getCallByFirstSimpleArgument(element)) == null || !(call.getCallType() instanceof I18nTranslateCallType)) {
            return false;
        }
        RailsI18nTranslateCallReference reference = (RailsI18nTranslateCallReference)ContainerUtil.findInstance((Object[])call.getReferences(), RailsI18nTranslateCallReference.class);
        if (reference == null || !reference.isLazilyScoped()) {
            return false;
        }
        I18nDictionary dictionary = I18nDictionary.forElement(element);
        return dictionary != null && !RubyExpandLazyI18nKeyIntention.getFullKeysWithoutScope(reference, dictionary).isEmpty();
    }

    public boolean startInWriteAction() {
        return false;
    }

    @Nullable
    private static RPossibleCall getCallByFirstSimpleArgument(@NotNull PsiElement element) {
        RPsiElement parent;
        if (element == null) {
            RubyExpandLazyI18nKeyIntention.$$$reportNull$$$0(8);
        }
        if ((parent = (RPsiElement)PsiTreeUtil.getParentOfType((PsiElement)element, RPsiElement.class)) == null) {
            return null;
        }
        RPsiElement argument = (RPsiElement)ObjectUtils.coalesce((Object)RSymbolNavigator.getSymbolByObjectOrStringContent((PsiElement)parent), (Object)parent);
        if (!RubyPsiUtil.isSimpleStringOrSymbol((PsiElement)argument)) {
            return null;
        }
        return RCallNavigator.getByFirstRArgument((PsiElement)argument);
    }

    @NotNull
    private static List<String> getFullKeysWithoutScope(@NotNull RailsI18nTranslateCallReference reference, @NotNull I18nDictionary dictionary) {
        if (reference == null) {
            RubyExpandLazyI18nKeyIntention.$$$reportNull$$$0(9);
        }
        if (dictionary == null) {
            RubyExpandLazyI18nKeyIntention.$$$reportNull$$$0(10);
        }
        Collection<String> validKeys = dictionary.getAllKeys();
        List<String> list = reference.getFullKeys().stream().filter(key -> validKeys.contains(key)).map(key -> !reference.isScoped() ? key : StringUtil.trimStart((String)key, (String)(reference.getScope() + "."))).collect(Collectors.toList());
        if (list == null) {
            RubyExpandLazyI18nKeyIntention.$$$reportNull$$$0(11);
        }
        return list;
    }

    private static void invoke(@NotNull RPossibleCall call, @NotNull String key) {
        if (call == null) {
            RubyExpandLazyI18nKeyIntention.$$$reportNull$$$0(12);
        }
        if (key == null) {
            RubyExpandLazyI18nKeyIntention.$$$reportNull$$$0(13);
        }
        RPsiElement argument = (RPsiElement)ContainerUtil.getFirstItem((List)call.getArguments());
        assert (argument instanceof RBaseStringImpl || argument instanceof RSymbol);
        if (!FileModificationService.getInstance().prepareFileForWrite(call.getContainingFile())) {
            return;
        }
        if (argument instanceof RBaseStringImpl) {
            ((RBaseStringImpl)argument).setName(key);
        } else {
            ((RSymbol)argument).setName(key);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 12, 13 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/actions/intention/i18n/RubyExpandLazyI18nKeyIntention";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dictionary";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/actions/intention/i18n/RubyExpandLazyI18nKeyIntention";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullKeysWithoutScope";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getCallByFirstSimpleArgument";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getFullKeysWithoutScope";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 12, 13 -> new IllegalArgumentException(string);
        };
    }
}

