/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.actions.intention.i18n;

import com.intellij.codeInsight.intention.AbstractIntentionAction;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationUtil;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.TestSourcesFilter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.util.BundlerUtil;
import org.jetbrains.plugins.ruby.i18n.I18nProvider;
import org.jetbrains.plugins.ruby.i18n.I18nTranslateCallType;
import org.jetbrains.plugins.ruby.i18n.dictionary.I18nDictionary;
import org.jetbrains.plugins.ruby.i18n.inspection.quickfixes.I18nCreatePropertyDialog;
import org.jetbrains.plugins.ruby.i18n.locales.LocaleEntry;
import org.jetbrains.plugins.ruby.i18n.references.I18nTranslateReference;
import org.jetbrains.plugins.ruby.i18n.references.RubyI18nTranslateReferenceUtil;
import org.jetbrains.plugins.ruby.ruby.lang.RubyLanguage;
import org.jetbrains.plugins.ruby.ruby.lang.parser.RubyElementTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactoryCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RExpressionSubstitution;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RRegexpLiteral;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RStringLiteral;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RWords;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.basicTypes.RSymbolNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.methodCall.RCallNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyFileCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.ruby19.basicTypes.stringLiterals.ROneCharacterString;
import org.jetbrains.plugins.ruby.templates.TemplateIntegrationUtils;
import org.jetbrains.plugins.ruby.utils.NamingConventions;

public final class I18nizeStringIntention
extends AbstractIntentionAction {
    private static final Logger LOG = Logger.getInstance(I18nizeStringIntention.class);

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile) {
        if (project == null) {
            I18nizeStringIntention.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            I18nizeStringIntention.$$$reportNull$$$0(1);
        }
        if (psiFile == null) {
            I18nizeStringIntention.$$$reportNull$$$0(2);
        }
        I18nizeStringIntention.getAvailableProcessors(editor, psiFile).findFirst().ifPresent(processor -> processor.invoke(project, editor, psiFile, true));
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.DIFF;
        if (intentionPreviewInfo == null) {
            I18nizeStringIntention.$$$reportNull$$$0(3);
        }
        return intentionPreviewInfo;
    }

    @NotNull
    public String getText() {
        String string = RBundle.message((String)"ruby.intentions.i18n");
        if (string == null) {
            I18nizeStringIntention.$$$reportNull$$$0(4);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile psiFile) {
        if (project == null) {
            I18nizeStringIntention.$$$reportNull$$$0(5);
        }
        if (BundlerUtil.isGemfile((PsiFileSystemItem)psiFile)) {
            return false;
        }
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile != null && TestSourcesFilter.isTestSources((VirtualFile)virtualFile, (Project)project)) {
            return false;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiFile);
        if (!I18nProvider.isI18nSupportEnabled(module)) {
            return false;
        }
        if (I18nProvider.getDictionary(module).getAllLocaleEntries().isEmpty()) {
            return false;
        }
        return I18nizeStringIntention.getAvailableProcessors(editor, psiFile).findAny().isPresent();
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile psiFile) throws IncorrectOperationException {
        if (project == null) {
            I18nizeStringIntention.$$$reportNull$$$0(6);
        }
        PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
        I18nizeStringIntention.getAvailableProcessors(editor, psiFile).findFirst().ifPresent(processor -> processor.invoke(project, editor, psiFile, false));
    }

    public boolean startInWriteAction() {
        return true;
    }

    @NotNull
    private static Stream<MyProcessor> getAvailableProcessors(@NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            I18nizeStringIntention.$$$reportNull$$$0(7);
        }
        if (file == null) {
            I18nizeStringIntention.$$$reportNull$$$0(8);
        }
        Stream<MyProcessor> stream = Holder.PROCESSORS.stream().filter(processor -> processor.isAvailable(editor, file));
        if (stream == null) {
            I18nizeStringIntention.$$$reportNull$$$0(9);
        }
        return stream;
    }

    private static void reportModuleError(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            I18nizeStringIntention.$$$reportNull$$$0(10);
        }
        if (editor == null) {
            I18nizeStringIntention.$$$reportNull$$$0(11);
        }
        if (file == null) {
            I18nizeStringIntention.$$$reportNull$$$0(12);
        }
        LOG.error("Could not find ruby module. project=" + String.valueOf(project) + "; editor=" + String.valueOf(editor) + "; file=" + String.valueOf(file));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 3: 
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/actions/intention/i18n/I18nizeStringIntention";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/actions/intention/i18n/I18nizeStringIntention";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "generatePreview";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableProcessors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "generatePreview";
                break;
            }
            case 3: 
            case 4: 
            case 9: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getAvailableProcessors";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "reportModuleError";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 9 -> new IllegalStateException(string);
        };
    }

    private static class Holder {
        private static final List<MyProcessor> PROCESSORS = Arrays.asList(new MyRubyProcessor(), new MyTemplateProcessor());

        private Holder() {
        }
    }

    private static interface MyProcessor {
        public boolean isAvailable(@NotNull Editor var1, @NotNull PsiFile var2);

        public void invoke(@NotNull Project var1, @NotNull Editor var2, @NotNull PsiFile var3, boolean var4);
    }

    private static class MyTemplateProcessor
    implements MyProcessor {
        private MyTemplateProcessor() {
        }

        @Override
        public boolean isAvailable(@NotNull Editor editor, @NotNull PsiFile file) {
            if (editor == null) {
                MyTemplateProcessor.$$$reportNull$$$0(0);
            }
            if (file == null) {
                MyTemplateProcessor.$$$reportNull$$$0(1);
            }
            return ModuleUtilCore.findModuleForPsiElement((PsiElement)file) != null && TemplateIntegrationUtils.getInstance().getTextForI18n(editor, file) != null;
        }

        @Override
        public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, boolean isPreview) {
            Module module;
            if (project == null) {
                MyTemplateProcessor.$$$reportNull$$$0(2);
            }
            if (editor == null) {
                MyTemplateProcessor.$$$reportNull$$$0(3);
            }
            if (file == null) {
                MyTemplateProcessor.$$$reportNull$$$0(4);
            }
            if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file)) == null) {
                I18nizeStringIntention.reportModuleError(project, editor, file);
                return;
            }
            String initialValue = StringUtil.unescapeXmlEntities((String)TemplateIntegrationUtils.getInstance().getTextForI18n(editor, file));
            I18nDictionary dictionary = I18nProvider.getDictionary(module);
            ArrayList<LocaleEntry> localeEntries = new ArrayList<LocaleEntry>(dictionary.getAllLocaleEntries());
            LOG.assertTrue(!localeEntries.isEmpty());
            if (isPreview) {
                MyTemplateProcessor.invokeForPreviewMode(editor, file, initialValue);
                return;
            }
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                MyTemplateProcessor.invokeForUnitTestMode(editor, file, initialValue, (LocaleEntry)localeEntries.get(0));
                return;
            }
            ApplicationUtil.showDialogAfterWriteAction(() -> {
                Map<String, LocaleEntry> presentationToLocaleEntries = I18nCreatePropertyDialog.createPresentationToLocaleEntries(localeEntries);
                I18nCreatePropertyDialog dialog = new I18nCreatePropertyDialog(project, dictionary, presentationToLocaleEntries, Collections.emptyList(), initialValue, null);
                if (dialog.showAndGet()) {
                    String key = dialog.getPropertyKey();
                    List<String> fullKeys = RubyI18nTranslateReferenceUtil.normaliseTranslateKey(key, (PsiElement)file);
                    LOG.assertTrue(!fullKeys.isEmpty());
                    WriteCommandAction.runWriteCommandAction((Project)project, (String)RBundle.message((String)"ruby.intentions.i18n"), null, () -> {
                        MyTemplateProcessor.doExtractI18nProperty(editor, file, key);
                        dialog.getLocaleTranslations().forEach((localeName, translation) -> {
                            LocaleEntry localeEntry = (LocaleEntry)presentationToLocaleEntries.get(localeName);
                            localeEntry.createI18nRecord((String)fullKeys.get(0), (String)translation);
                        });
                    }, (PsiFile[])new PsiFile[0]);
                }
            });
        }

        private static void invokeForPreviewMode(@NotNull Editor editor, @NotNull PsiFile file, @NotNull String initialValue) {
            String suggestedKey;
            if (editor == null) {
                MyTemplateProcessor.$$$reportNull$$$0(5);
            }
            if (file == null) {
                MyTemplateProcessor.$$$reportNull$$$0(6);
            }
            if (initialValue == null) {
                MyTemplateProcessor.$$$reportNull$$$0(7);
            }
            String key = StringUtil.isNotEmpty((String)(suggestedKey = I18nCreatePropertyDialog.getSuggestedKey(initialValue))) ? suggestedKey : "example";
            MyTemplateProcessor.doExtractI18nProperty(editor, file, key);
        }

        private static void invokeForUnitTestMode(@NotNull Editor editor, @NotNull PsiFile file, @NotNull String initialValue, @NotNull LocaleEntry localeEntry) {
            String suggestedKey;
            if (editor == null) {
                MyTemplateProcessor.$$$reportNull$$$0(8);
            }
            if (file == null) {
                MyTemplateProcessor.$$$reportNull$$$0(9);
            }
            if (initialValue == null) {
                MyTemplateProcessor.$$$reportNull$$$0(10);
            }
            if (localeEntry == null) {
                MyTemplateProcessor.$$$reportNull$$$0(11);
            }
            String key = StringUtil.isNotEmpty((String)(suggestedKey = I18nCreatePropertyDialog.getSuggestedKey(initialValue))) ? suggestedKey : "example";
            MyTemplateProcessor.doExtractI18nProperty(editor, file, key);
            localeEntry.createI18nRecord(key, initialValue);
        }

        private static void doExtractI18nProperty(@NotNull Editor editor, @NotNull PsiFile file, @NotNull String key) {
            if (editor == null) {
                MyTemplateProcessor.$$$reportNull$$$0(12);
            }
            if (file == null) {
                MyTemplateProcessor.$$$reportNull$$$0(13);
            }
            if (key == null) {
                MyTemplateProcessor.$$$reportNull$$$0(14);
            }
            RExpression expression = RubyElementFactoryCore.createExpressionFromText((PsiElement)file, (String)("t('" + key + "')"));
            TemplateIntegrationUtils.getInstance().replaceTextWithI18n(editor, file, expression);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: 
                case 4: 
                case 6: 
                case 9: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 7: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "initialValue";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "localeEntry";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/actions/intention/i18n/I18nizeStringIntention$MyTemplateProcessor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isAvailable";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "invoke";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "invokeForPreviewMode";
                    break;
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[2] = "invokeForUnitTestMode";
                    break;
                }
                case 12: 
                case 13: 
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doExtractI18nProperty";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyRubyProcessor
    implements MyProcessor {
        private static final Class<?>[] BLACKLISTED_STRING_CLASSES = new Class[]{ROneCharacterString.class, RRegexpLiteral.class, RWords.class};
        private static final String DEFAULT_SUBSTITUTION_NAME = "var";
        private static final Pattern I18N_VARIABLE_PATTERN = Pattern.compile("\\w+");
        private static final String I18N_VARIABLE_INTERPOLATION_START = "%{";
        private static final String I18N_VARIABLE_INTERPOLATION_END = "}";

        private MyRubyProcessor() {
        }

        @Override
        public boolean isAvailable(@NotNull Editor editor, @NotNull PsiFile file) {
            RStringLiteral element;
            if (editor == null) {
                MyRubyProcessor.$$$reportNull$$$0(0);
            }
            if (file == null) {
                MyRubyProcessor.$$$reportNull$$$0(1);
            }
            if ((element = MyRubyProcessor.findStringLiteralAtCaret(editor, file)) == null) {
                return false;
            }
            if (ModuleUtilCore.findModuleForPsiElement((PsiElement)file) == null) {
                LOG.debug("Module is not available for ", new Object[]{file});
                return false;
            }
            RCall topCall = (RCall)PsiTreeUtil.getTopmostParentOfType((PsiElement)element, RCall.class);
            if (topCall != null && topCall.getCallType() instanceof RubyFileCallType) {
                return false;
            }
            RCall call = RCallNavigator.getByRArgument((PsiElement)element);
            if (call != null && call.getCallType() instanceof I18nTranslateCallType) {
                return false;
            }
            return !element.getContent().isEmpty();
        }

        @Override
        public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, boolean isPreview) {
            Module module;
            if (project == null) {
                MyRubyProcessor.$$$reportNull$$$0(2);
            }
            if (editor == null) {
                MyRubyProcessor.$$$reportNull$$$0(3);
            }
            if (file == null) {
                MyRubyProcessor.$$$reportNull$$$0(4);
            }
            if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file)) == null) {
                I18nizeStringIntention.reportModuleError(project, editor, file);
                return;
            }
            RStringLiteral element = MyRubyProcessor.findStringLiteralAtCaret(editor, file);
            LOG.assertTrue(element != null);
            List<String> initialSubstitutionNames = MyRubyProcessor.getInitialSubstitutionNames(element);
            String initialValue = MyRubyProcessor.getInitialValue(element, initialSubstitutionNames);
            I18nDictionary dictionary = I18nProvider.getDictionary(module);
            ArrayList<LocaleEntry> localeEntries = new ArrayList<LocaleEntry>(dictionary.getAllLocaleEntries());
            LOG.assertTrue(!localeEntries.isEmpty());
            if (isPreview) {
                MyRubyProcessor.invokeForPreviewMode(file, element, initialValue, initialSubstitutionNames);
                return;
            }
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                MyRubyProcessor.invokeForUnitTestMode(file, element, (LocaleEntry)localeEntries.get(0), initialValue, initialSubstitutionNames);
                return;
            }
            ApplicationUtil.showDialogAfterWriteAction(() -> {
                Map<String, LocaleEntry> presentationToLocaleEntries = I18nCreatePropertyDialog.createPresentationToLocaleEntries(localeEntries);
                I18nCreatePropertyDialog dialog = new I18nCreatePropertyDialog(project, dictionary, presentationToLocaleEntries, Collections.emptyList(), initialValue, initialSubstitutionNames);
                if (dialog.showAndGet()) {
                    WriteCommandAction.runWriteCommandAction((Project)project, (String)RBundle.message((String)"ruby.intentions.i18n"), null, () -> {
                        String key = dialog.getPropertyKey();
                        List<String> fullKeys = RubyI18nTranslateReferenceUtil.normaliseTranslateKey(key, (PsiElement)element);
                        List<String> variables = dialog.getVariables();
                        LOG.assertTrue(!fullKeys.isEmpty());
                        MyRubyProcessor.replaceStringWithTranslateCall(file, element, key, variables);
                        dialog.getLocaleTranslations().forEach((localeName, translation) -> {
                            LocaleEntry localeEntry = (LocaleEntry)presentationToLocaleEntries.get(localeName);
                            localeEntry.createI18nRecord((String)fullKeys.get(0), (String)translation);
                        });
                    }, (PsiFile[])new PsiFile[0]);
                }
            });
        }

        private static void invokeForPreviewMode(@NotNull PsiFile file, @NotNull RStringLiteral element, @NotNull String initialValue, @NotNull List<String> initialSubstitutionNames) {
            String suggestedKey;
            if (file == null) {
                MyRubyProcessor.$$$reportNull$$$0(5);
            }
            if (element == null) {
                MyRubyProcessor.$$$reportNull$$$0(6);
            }
            if (initialValue == null) {
                MyRubyProcessor.$$$reportNull$$$0(7);
            }
            if (initialSubstitutionNames == null) {
                MyRubyProcessor.$$$reportNull$$$0(8);
            }
            String key = StringUtil.isNotEmpty((String)(suggestedKey = I18nCreatePropertyDialog.getSuggestedKey(initialValue))) ? suggestedKey : "example";
            MyRubyProcessor.replaceStringWithTranslateCall(file, element, key, initialSubstitutionNames);
        }

        private static void invokeForUnitTestMode(@NotNull PsiFile file, @NotNull RStringLiteral element, @NotNull LocaleEntry localeEntry, @NotNull String initialValue, @NotNull List<String> initialSubstitutionNames) {
            String suggestedKey;
            if (file == null) {
                MyRubyProcessor.$$$reportNull$$$0(9);
            }
            if (element == null) {
                MyRubyProcessor.$$$reportNull$$$0(10);
            }
            if (localeEntry == null) {
                MyRubyProcessor.$$$reportNull$$$0(11);
            }
            if (initialValue == null) {
                MyRubyProcessor.$$$reportNull$$$0(12);
            }
            if (initialSubstitutionNames == null) {
                MyRubyProcessor.$$$reportNull$$$0(13);
            }
            String key = StringUtil.isNotEmpty((String)(suggestedKey = I18nCreatePropertyDialog.getSuggestedKey(initialValue))) ? suggestedKey : "test";
            MyRubyProcessor.replaceStringWithTranslateCall(file, element, key, initialSubstitutionNames);
            localeEntry.createI18nRecord(key, initialValue);
        }

        private static void replaceStringWithTranslateCall(@NotNull PsiFile file, @NotNull RStringLiteral element, @NotNull String key, @NotNull List<String> variables) {
            if (file == null) {
                MyRubyProcessor.$$$reportNull$$$0(14);
            }
            if (element == null) {
                MyRubyProcessor.$$$reportNull$$$0(15);
            }
            if (key == null) {
                MyRubyProcessor.$$$reportNull$$$0(16);
            }
            if (variables == null) {
                MyRubyProcessor.$$$reportNull$$$0(17);
            }
            StringBuilder sb = new StringBuilder();
            if (PsiUtilCore.getTemplateLanguageFile((PsiElement)element).getLanguage() == RubyLanguage.INSTANCE && !key.startsWith(".")) {
                sb.append("I18n.");
            }
            sb.append("t('").append(key).append("'");
            ArrayList<String> substitutionNames = new ArrayList<String>(variables);
            for (RExpressionSubstitution expression : element.getExpressionSubstitutions()) {
                String substitutionName = (String)substitutionNames.remove(0);
                RCompoundStatement statement = expression.getCompoundStatement();
                if (statement == null) continue;
                sb.append(", ").append(substitutionName).append(": ");
                sb.append((String)(statement.getStatements().size() > 1 ? "(" + statement.getText() + ")" : statement.getText()));
            }
            sb.append(")");
            element.replace((PsiElement)RubyElementFactoryCore.createElementFromText((PsiElement)file, (String)sb.toString()));
        }

        @Nullable
        private static RStringLiteral findStringLiteralAtCaret(@NotNull Editor editor, @NotNull PsiFile file) {
            SelectionModel selectionModel;
            if (editor == null) {
                MyRubyProcessor.$$$reportNull$$$0(18);
            }
            if (file == null) {
                MyRubyProcessor.$$$reportNull$$$0(19);
            }
            if ((selectionModel = editor.getSelectionModel()).hasSelection()) {
                return null;
            }
            int offset = editor.getCaretModel().getOffset();
            RStringLiteral literal = (RStringLiteral)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)offset, RStringLiteral.class, (boolean)false);
            if (literal == null) {
                return null;
            }
            if (PsiTreeUtil.instanceOf((Object)literal, (Class[])BLACKLISTED_STRING_CLASSES) || RSymbolNavigator.getSymbolByObjectOrStringContent((PsiElement)literal) != null) {
                return null;
            }
            if (InjectedLanguageManager.getInstance((Project)file.getProject()).findInjectedElementAt(file, offset) != null) {
                return null;
            }
            return literal;
        }

        @NotNull
        private static String getInitialValue(@NotNull RStringLiteral element, @NotNull List<String> substitutionNames) {
            if (element == null) {
                MyRubyProcessor.$$$reportNull$$$0(20);
            }
            if (substitutionNames == null) {
                MyRubyProcessor.$$$reportNull$$$0(21);
            }
            if (!element.hasExpressionSubstitutions()) {
                String string = element.getContent();
                if (string == null) {
                    MyRubyProcessor.$$$reportNull$$$0(22);
                }
                return string;
            }
            ArrayList<String> names = new ArrayList<String>(substitutionNames);
            String string = element.getPsiContent().stream().map(content -> {
                if (PsiUtilCore.getElementType((PsiElement)content) == RubyElementTypes.EXPR_SUBTITUTION) {
                    return I18N_VARIABLE_INTERPOLATION_START + (String)names.remove(0) + I18N_VARIABLE_INTERPOLATION_END;
                }
                return content.getText();
            }).collect(Collectors.joining());
            if (string == null) {
                MyRubyProcessor.$$$reportNull$$$0(23);
            }
            return string;
        }

        @NotNull
        private static List<String> getInitialSubstitutionNames(@NotNull RStringLiteral element) {
            if (element == null) {
                MyRubyProcessor.$$$reportNull$$$0(24);
            }
            ArrayList<String> substitutionNames = new ArrayList<String>();
            for (RExpressionSubstitution substitution : element.getExpressionSubstitutions()) {
                int suffix;
                String desiredName = MyRubyProcessor.getDesiredSubstitutionName(substitution);
                if (!substitutionNames.contains(desiredName) && !I18nTranslateReference.OPTIONS.contains(desiredName)) {
                    substitutionNames.add(desiredName);
                    continue;
                }
                int n = suffix = I18nTranslateReference.OPTIONS.contains(desiredName) ? 1 : 2;
                while (substitutionNames.contains(desiredName + suffix)) {
                    ++suffix;
                }
                substitutionNames.add(desiredName + suffix);
            }
            ArrayList<String> arrayList = substitutionNames;
            if (arrayList == null) {
                MyRubyProcessor.$$$reportNull$$$0(25);
            }
            return arrayList;
        }

        @NotNull
        private static String getDesiredSubstitutionName(@NotNull RExpressionSubstitution substitution) {
            String command;
            String name;
            RPsiElement statement;
            RCompoundStatement compoundStatement;
            if (substitution == null) {
                MyRubyProcessor.$$$reportNull$$$0(26);
            }
            if ((compoundStatement = substitution.getCompoundStatement()) != null && !compoundStatement.getStatements().isEmpty() && (statement = (RPsiElement)ContainerUtil.getLastItem((List)compoundStatement.getStatements())) instanceof RPossibleCall && (name = (String)ObjectUtils.doIfNotNull((Object)(command = ((RPossibleCall)statement).getCommand()), NamingConventions::toUnderscoreCase)) != null && I18N_VARIABLE_PATTERN.matcher(name).matches()) {
                String string = name;
                if (string == null) {
                    MyRubyProcessor.$$$reportNull$$$0(27);
                }
                return string;
            }
            return DEFAULT_SUBSTITUTION_NAME;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 22, 23, 25, 27 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: 
                case 4: 
                case 5: 
                case 9: 
                case 14: 
                case 19: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 6: 
                case 10: 
                case 15: 
                case 20: 
                case 24: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 7: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "initialValue";
                    break;
                }
                case 8: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "initialSubstitutionNames";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "localeEntry";
                    break;
                }
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variables";
                    break;
                }
                case 21: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "substitutionNames";
                    break;
                }
                case 22: 
                case 23: 
                case 25: 
                case 27: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/actions/intention/i18n/I18nizeStringIntention$MyRubyProcessor";
                    break;
                }
                case 26: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "substitution";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/actions/intention/i18n/I18nizeStringIntention$MyRubyProcessor";
                    break;
                }
                case 22: 
                case 23: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInitialValue";
                    break;
                }
                case 25: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInitialSubstitutionNames";
                    break;
                }
                case 27: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDesiredSubstitutionName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "isAvailable";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "invokeForPreviewMode";
                    break;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "invokeForUnitTestMode";
                    break;
                }
                case 14: 
                case 15: 
                case 16: 
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "replaceStringWithTranslateCall";
                    break;
                }
                case 18: 
                case 19: {
                    objectArray = objectArray;
                    objectArray[2] = "findStringLiteralAtCaret";
                    break;
                }
                case 20: 
                case 21: {
                    objectArray = objectArray;
                    objectArray[2] = "getInitialValue";
                    break;
                }
                case 22: 
                case 23: 
                case 25: 
                case 27: {
                    break;
                }
                case 24: {
                    objectArray = objectArray;
                    objectArray[2] = "getInitialSubstitutionNames";
                    break;
                }
                case 26: {
                    objectArray = objectArray;
                    objectArray[2] = "getDesiredSubstitutionName";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 22, 23, 25, 27 -> new IllegalStateException(string);
            };
        }
    }
}

