/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.actions.intention.erb;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.erb.ErbLanguage;
import org.jetbrains.plugins.ruby.erb.psi.ErbCodeInjectionTag;

public final class ErbCommentConvertIntention
implements IntentionAction,
DumbAware {
    private static final String ERB_COMMENT_PREFIX = "<%#";
    private static final String ERB_COMMENT_POSTFIX = "%>";

    @NotNull
    public String getText() {
        String string = ErbCommentConvertIntention.getMessage();
        if (string == null) {
            ErbCommentConvertIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = ErbCommentConvertIntention.getMessage();
        if (string == null) {
            ErbCommentConvertIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile psiFile) {
        if (project == null) {
            ErbCommentConvertIntention.$$$reportNull$$$0(2);
        }
        if (!(psiFile.getViewProvider().getBaseLanguage() instanceof ErbLanguage)) {
            return false;
        }
        PsiElement elementAt = psiFile.getViewProvider().findElementAt(editor.getCaretModel().getOffset(), (Language)ErbLanguage.INSTANCE);
        ErbCodeInjectionTag injectionTag = (ErbCodeInjectionTag)PsiTreeUtil.getParentOfType((PsiElement)elementAt, ErbCodeInjectionTag.class);
        if (injectionTag == null) {
            return false;
        }
        String text = injectionTag.getTagText().trim();
        return text.startsWith("#") && !text.contains("\n");
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile psiFile) throws IncorrectOperationException {
        PsiElement elementAt;
        ErbCodeInjectionTag element;
        if (project == null) {
            ErbCommentConvertIntention.$$$reportNull$$$0(3);
        }
        if ((element = (ErbCodeInjectionTag)PsiTreeUtil.getParentOfType((PsiElement)(elementAt = psiFile.getViewProvider().findElementAt(editor.getCaretModel().getOffset(), (Language)ErbLanguage.INSTANCE)), ErbCodeInjectionTag.class)) == null) {
            return;
        }
        String text = element.getTagText();
        TextRange range = element.getTextRange();
        Document document = editor.getDocument();
        document.replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)(ERB_COMMENT_PREFIX + text.substring(text.indexOf("#") + 1) + ERB_COMMENT_POSTFIX));
        PsiDocumentManager.getInstance((Project)project).commitDocument(document);
    }

    public boolean startInWriteAction() {
        return true;
    }

    @IntentionName
    public static String getMessage() {
        return RBundle.message((String)"ruby.intentions.erb.convert.name");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/actions/intention/erb/ErbCommentConvertIntention";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/actions/intention/erb/ErbCommentConvertIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3 -> new IllegalArgumentException(string);
        };
    }
}

