/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.actions.intention.declarations;

import com.intellij.codeInsight.intention.BaseElementAtCaretIntentionAction;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.templateLanguages.TemplateLanguageUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.lang.documentation.RubyCommentsUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactoryCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.names.RName;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.controlStructures.classes.RClassNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.controlStructures.modules.RModuleNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.holders.utils.RContainerUtilCore;

public final class RubyExpandNamespaceIntention
extends BaseElementAtCaretIntentionAction
implements DumbAware {
    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = RBundle.message((String)"ruby.intentions.expand.namespace");
        if (string == null) {
            RubyExpandNamespaceIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @IntentionName
    @NotNull
    public String getText() {
        String string = RBundle.message((String)"ruby.intentions.expand.namespace.changes.semantics");
        if (string == null) {
            RubyExpandNamespaceIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            RubyExpandNamespaceIntention.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            RubyExpandNamespaceIntention.$$$reportNull$$$0(3);
        }
        if (element == null) {
            RubyExpandNamespaceIntention.$$$reportNull$$$0(4);
        }
        RName name = (RName)PsiTreeUtil.getParentOfType((PsiElement)element, RName.class);
        assert (name != null);
        RContainer container = (RContainer)ObjectUtils.coalesce((Object)RClassNavigator.getByName((RName)name), (Object)RModuleNavigator.getByName((RName)name));
        assert (container != null);
        FQN fqn = name.getFQN();
        FQN callerFqn = fqn.getCallerFQN();
        name.getFirstChild().replace((PsiElement)RubyElementFactoryCore.createElementFromText((PsiElement)element, (String)fqn.getShortName()));
        String text = callerFqn.asStream().map(parent -> "module " + parent + "\n").collect(Collectors.joining()) + container.getText() + StringUtil.repeat((String)"\nend", (int)callerFqn.asList().size());
        RContainer newContainer = (RContainer)container.replace((PsiElement)RubyElementFactoryCore.createElementFromText((PsiElement)container, (String)text));
        RContainer classOrModule = RContainerUtilCore.getContainerByName((RContainer)newContainer, (String)fqn.getShortName(), (boolean)true);
        if (classOrModule != null) {
            List comments = RubyCommentsUtilCore.getPsiComments((PsiElement)newContainer);
            if (!comments.isEmpty()) {
                PsiComment firstComment = (PsiComment)ContainerUtil.getFirstItem((List)comments);
                PsiComment lastComment = (PsiComment)ContainerUtil.getLastItem((List)comments);
                assert (firstComment != null);
                newContainer.getParent().deleteChildRange((PsiElement)firstComment, (PsiElement)lastComment);
                classOrModule.getParent().addRangeBefore((PsiElement)firstComment, (PsiElement)lastComment, (PsiElement)classOrModule);
            }
            editor.getCaretModel().moveToOffset(classOrModule.getNavigationElement().getTextOffset());
        }
    }

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            RubyExpandNamespaceIntention.$$$reportNull$$$0(5);
        }
        if (editor == null) {
            RubyExpandNamespaceIntention.$$$reportNull$$$0(6);
        }
        if (element == null) {
            RubyExpandNamespaceIntention.$$$reportNull$$$0(7);
        }
        if (TemplateLanguageUtil.isInsideTemplateFile((PsiElement)element)) {
            return false;
        }
        RName name = (RName)PsiTreeUtil.getParentOfType((PsiElement)element, RName.class);
        if (name == null) {
            return false;
        }
        RContainer container = (RContainer)ObjectUtils.coalesce((Object)RClassNavigator.getByName((RName)name), (Object)RModuleNavigator.getByName((RName)name));
        if (container == null) {
            return false;
        }
        FQN fqn = name.getFQN();
        return fqn.getCallerFQN() != FQN.INVALID && !fqn.isToplevel();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/actions/intention/declarations/RubyExpandNamespaceIntention";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/actions/intention/declarations/RubyExpandNamespaceIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6, 7 -> new IllegalArgumentException(string);
        };
    }
}

