/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.actions.intention.controlFlow;

import com.intellij.codeInsight.intention.BaseElementAtCaretIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.templateLanguages.TemplateLanguageUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import java.util.Objects;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactoryCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RIfStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RElseBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RElsifBlock;

public final class RubySplitElsifIntention
extends BaseElementAtCaretIntentionAction
implements DumbAware {
    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = RBundle.message((String)"ruby.intentions.split.else.if");
        if (string == null) {
            RubySplitElsifIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getText() {
        String string = RBundle.message((String)"ruby.intentions.split.else.if");
        if (string == null) {
            RubySplitElsifIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            RubySplitElsifIntention.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            RubySplitElsifIntention.$$$reportNull$$$0(3);
        }
        if (element == null) {
            RubySplitElsifIntention.$$$reportNull$$$0(4);
        }
        RElsifBlock elsifBlock = (RElsifBlock)PsiTreeUtil.getParentOfType((PsiElement)element, RElsifBlock.class);
        assert (elsifBlock != null);
        StringBuilder sb = new StringBuilder();
        sb.append(StringUtil.trimStart((String)elsifBlock.getText(), (String)"els")).append("\n");
        RIfStatement ifStatement = (RIfStatement)elsifBlock.getParent();
        for (RElsifBlock block : ifStatement.getElsifBlocks()) {
            if (RubyPsiUtilCore.isBefore((PsiElement)block, (PsiElement)elsifBlock)) continue;
            sb.append(block.getText()).append("\n");
            RubySplitElsifIntention.deleteElementWithTrailingNewline((RPsiElement)block);
        }
        RElseBlock elseBlock = ifStatement.getElseBlock();
        if (elseBlock != null) {
            sb.append(elseBlock.getText()).append("\n");
            RubySplitElsifIntention.deleteElementWithTrailingNewline((RPsiElement)elseBlock);
        }
        sb.append("end");
        RIfStatement newIfStatement = (RIfStatement)RubyElementFactoryCore.createElementFromText((PsiElement)element, (String)("if _\nelse\n" + String.valueOf(sb) + "\nend"));
        elsifBlock.replace((PsiElement)Objects.requireNonNull(newIfStatement.getElseBlock()));
    }

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            RubySplitElsifIntention.$$$reportNull$$$0(5);
        }
        if (editor == null) {
            RubySplitElsifIntention.$$$reportNull$$$0(6);
        }
        if (element == null) {
            RubySplitElsifIntention.$$$reportNull$$$0(7);
        }
        if (PsiUtilCore.getElementType((PsiElement)element) != RubyTokenTypes.kELSIF || TemplateLanguageUtil.isInsideTemplateFile((PsiElement)element)) {
            return false;
        }
        return PsiTreeUtil.getParentOfType((PsiElement)element, RElsifBlock.class) != null;
    }

    private static void deleteElementWithTrailingNewline(@NotNull RPsiElement element) {
        PsiElement sibling;
        if (element == null) {
            RubySplitElsifIntention.$$$reportNull$$$0(8);
        }
        if ((sibling = element.getNextSibling()) != null && StringUtil.isEmptyOrSpaces((String)sibling.getText())) {
            element.getParent().deleteChildRange((PsiElement)element, sibling);
        } else {
            element.delete();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6, 7, 8 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/actions/intention/controlFlow/RubySplitElsifIntention";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/actions/intention/controlFlow/RubySplitElsifIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "deleteElementWithTrailingNewline";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6, 7, 8 -> new IllegalArgumentException(string);
        };
    }
}

