/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.actions.intention.controlFlow;

import com.intellij.codeInsight.intention.BaseElementAtCaretIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.templateLanguages.TemplateLanguageUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.extractMethod.SimpleMatch;
import com.intellij.refactoring.util.AbstractVariableData;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactoryCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RCondition;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RConditionalStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RIfStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RElsifBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RBoolBinExpression;
import org.jetbrains.plugins.ruby.ruby.refactoring.RubyReplaceExpressionUtil;
import org.jetbrains.plugins.ruby.ruby.refactoring.extractMethod.RubyDuplicatesFinder;

public final class RubyMergeSequentialIfsIntention
extends BaseElementAtCaretIntentionAction
implements DumbAware {
    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = RBundle.message((String)"ruby.intentions.merge.sequential.ifs");
        if (string == null) {
            RubyMergeSequentialIfsIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getText() {
        String string = RBundle.message((String)"ruby.intentions.merge.sequential.ifs");
        if (string == null) {
            RubyMergeSequentialIfsIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            RubyMergeSequentialIfsIntention.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            RubyMergeSequentialIfsIntention.$$$reportNull$$$0(3);
        }
        if (element == null) {
            RubyMergeSequentialIfsIntention.$$$reportNull$$$0(4);
        }
        RIfStatement ifStatement = (RIfStatement)PsiTreeUtil.getParentOfType((PsiElement)element, RIfStatement.class);
        assert (ifStatement != null);
        RConditionalStatement conditionalStatement = (RConditionalStatement)PsiTreeUtil.getParentOfType((PsiElement)element, RConditionalStatement.class);
        assert (conditionalStatement != null);
        RElsifBlock nextElsifBlock = RubyMergeSequentialIfsIntention.getNextElsifBlock(ifStatement, element);
        assert (nextElsifBlock != null);
        RCondition firstCondition = conditionalStatement.getCondition();
        RCondition secondCondition = nextElsifBlock.getCondition();
        assert (firstCondition != null && secondCondition != null);
        firstCondition.getFirstChild().replace((PsiElement)RubyMergeSequentialIfsIntention.createDisjunctionCondition(firstCondition, secondCondition));
        RubyMergeSequentialIfsIntention.deleteElementWithTrailingNewline((RPsiElement)nextElsifBlock);
    }

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            RubyMergeSequentialIfsIntention.$$$reportNull$$$0(5);
        }
        if (editor == null) {
            RubyMergeSequentialIfsIntention.$$$reportNull$$$0(6);
        }
        if (element == null) {
            RubyMergeSequentialIfsIntention.$$$reportNull$$$0(7);
        }
        if (!Holder.IF_ELSIF_ELEMENT_TYPES.contains(PsiUtilCore.getElementType((PsiElement)element)) || TemplateLanguageUtil.isInsideTemplateFile((PsiElement)element)) {
            return false;
        }
        RIfStatement ifStatement = (RIfStatement)PsiTreeUtil.getParentOfType((PsiElement)element, RIfStatement.class);
        if (ifStatement == null) {
            return false;
        }
        RConditionalStatement conditionalStatement = (RConditionalStatement)PsiTreeUtil.getParentOfType((PsiElement)element, RConditionalStatement.class);
        if (conditionalStatement == null || conditionalStatement.getCondition() == null) {
            return false;
        }
        RCompoundStatement body = RubyMergeSequentialIfsIntention.getCompoundStatement(conditionalStatement);
        if (body == null) {
            return false;
        }
        RElsifBlock nextElsifBlock = RubyMergeSequentialIfsIntention.getNextElsifBlock(ifStatement, element);
        if (nextElsifBlock == null || nextElsifBlock.getCondition() == null) {
            return false;
        }
        RCompoundStatement nextElsifBody = nextElsifBlock.getBody();
        if (!RubyMergeSequentialIfsIntention.areCompoundStatementsEquivalent(element.getContainingFile(), body, nextElsifBody)) {
            return false;
        }
        return PsiTreeUtil.getChildOfType((PsiElement)nextElsifBody, PsiComment.class) == null;
    }

    private static boolean areCompoundStatementsEquivalent(@NotNull PsiFile file, @NotNull RCompoundStatement first, @NotNull RCompoundStatement second) {
        if (file == null) {
            RubyMergeSequentialIfsIntention.$$$reportNull$$$0(8);
        }
        if (first == null) {
            RubyMergeSequentialIfsIntention.$$$reportNull$$$0(9);
        }
        if (second == null) {
            RubyMergeSequentialIfsIntention.$$$reportNull$$$0(10);
        }
        List firstStatements = first.getStatements();
        List secondStatements = second.getStatements();
        if (firstStatements.isEmpty() || secondStatements.isEmpty()) {
            return firstStatements.isEmpty() && secondStatements.isEmpty();
        }
        RubyDuplicatesFinder finder = new RubyDuplicatesFinder(file, (PsiElement)firstStatements.get(0), (PsiElement)ContainerUtil.getLastItem((List)firstStatements), Holder.EMPTY_ABSTRACT_VARIABLE_DATA);
        RPsiElement dummyMethod = RubyElementFactoryCore.createElementFromText((PsiElement)file, (String)"def foo; end");
        SimpleMatch duplicate = (SimpleMatch)ContainerUtil.getOnlyItem((Collection)finder.findDuplicates(Collections.singletonList(second), (PsiElement)dummyMethod));
        if (duplicate == null) {
            return false;
        }
        return ((RPsiElement)secondStatements.get(0)).equals(duplicate.getStartElement()) && ((RPsiElement)ContainerUtil.getLastItem((List)secondStatements)).equals(duplicate.getEndElement());
    }

    @NotNull
    private static RPsiElement createDisjunctionCondition(@NotNull RCondition first, @NotNull RCondition second) {
        if (first == null) {
            RubyMergeSequentialIfsIntention.$$$reportNull$$$0(11);
        }
        if (second == null) {
            RubyMergeSequentialIfsIntention.$$$reportNull$$$0(12);
        }
        RPsiElement firstElement = (RPsiElement)ObjectUtils.coalesce((Object)((RPsiElement)ObjectUtils.tryCast((Object)first.getFirstChild(), RPsiElement.class)), (Object)first);
        RPsiElement secondElement = (RPsiElement)ObjectUtils.coalesce((Object)((RPsiElement)ObjectUtils.tryCast((Object)second.getFirstChild(), RPsiElement.class)), (Object)second);
        RBoolBinExpression newCondition = (RBoolBinExpression)RubyElementFactoryCore.createElementFromText((PsiElement)first, (String)"a || b");
        RPsiElement leftOperand = newCondition.getLeftOperand();
        if (RubyReplaceExpressionUtil.isNeedParenthesis(leftOperand, firstElement)) {
            leftOperand.replace((PsiElement)RubyElementFactoryCore.createElementFromText((PsiElement)first, (String)("(" + firstElement.getText() + ")")));
        } else {
            leftOperand.replace((PsiElement)firstElement);
        }
        RPsiElement rightOperand = newCondition.getRightOperand();
        assert (rightOperand != null);
        if (RubyReplaceExpressionUtil.isNeedParenthesis(rightOperand, secondElement)) {
            rightOperand.replace((PsiElement)RubyElementFactoryCore.createElementFromText((PsiElement)first, (String)("(" + secondElement.getText() + ")")));
        } else {
            rightOperand.replace((PsiElement)secondElement);
        }
        RBoolBinExpression rBoolBinExpression = newCondition;
        if (rBoolBinExpression == null) {
            RubyMergeSequentialIfsIntention.$$$reportNull$$$0(13);
        }
        return rBoolBinExpression;
    }

    private static void deleteElementWithTrailingNewline(@NotNull RPsiElement element) {
        PsiElement sibling;
        if (element == null) {
            RubyMergeSequentialIfsIntention.$$$reportNull$$$0(14);
        }
        if (StringUtil.isEmptyOrSpaces((String)(sibling = element.getNextSibling()).getText())) {
            element.getParent().deleteChildRange((PsiElement)element, sibling);
        } else {
            element.delete();
        }
    }

    @Nullable
    private static RCompoundStatement getCompoundStatement(@NotNull RConditionalStatement conditionalStatement) {
        if (conditionalStatement == null) {
            RubyMergeSequentialIfsIntention.$$$reportNull$$$0(15);
        }
        if (conditionalStatement instanceof RIfStatement) {
            return ((RIfStatement)conditionalStatement).getThenBlock();
        }
        if (conditionalStatement instanceof RElsifBlock) {
            return ((RElsifBlock)conditionalStatement).getBody();
        }
        return null;
    }

    @Nullable
    private static RElsifBlock getNextElsifBlock(@NotNull RIfStatement ifStatement, @NotNull PsiElement anchor) {
        if (ifStatement == null) {
            RubyMergeSequentialIfsIntention.$$$reportNull$$$0(16);
        }
        if (anchor == null) {
            RubyMergeSequentialIfsIntention.$$$reportNull$$$0(17);
        }
        return (RElsifBlock)ContainerUtil.find((Iterable)ifStatement.getElsifBlocks(), elsifBlock -> !RubyPsiUtilCore.isBefore((PsiElement)elsifBlock, (PsiElement)anchor));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 14, 15, 16, 17 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/actions/intention/controlFlow/RubyMergeSequentialIfsIntention";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: 
            case 7: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conditionalStatement";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ifStatement";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/actions/intention/controlFlow/RubyMergeSequentialIfsIntention";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createDisjunctionCondition";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "areCompoundStatementsEquivalent";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createDisjunctionCondition";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "deleteElementWithTrailingNewline";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getCompoundStatement";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getNextElsifBlock";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 14, 15, 16, 17 -> new IllegalArgumentException(string);
        };
    }

    private static class Holder {
        private static final AbstractVariableData[] EMPTY_ABSTRACT_VARIABLE_DATA = new AbstractVariableData[0];
        private static final List<IElementType> IF_ELSIF_ELEMENT_TYPES = List.of(RubyTokenTypes.kIF, RubyTokenTypes.kELSIF);

        private Holder() {
        }
    }
}

