/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.actions.intention.blocks;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.intention.BaseElementAtCaretIntentionAction;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.lang.Language;
import com.intellij.model.Symbol;
import com.intellij.model.psi.PsiSymbolReference;
import com.intellij.model.psi.PsiSymbolReferenceService;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.ScopeHolder;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.ScopeUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.RubyLanguage;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RCodeBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RDoCodeBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RIdentifier;
import org.jetbrains.plugins.ruby.ruby.lang.psi.visitors.RubyRecursiveElementVisitor;
import org.jetbrains.plugins.ruby.ruby.model.impl.RubyNumberedParameterSymbol;

public final class RubyConvertNumberedParametersToNamedIntention
extends BaseElementAtCaretIntentionAction
implements DumbAware {
    private static final Comparator<PsiSymbolReference> REFERENCE_COMPARATOR = Comparator.comparingInt(it -> it.getAbsoluteRange().getStartOffset());
    private static final String VAR_PREFIX = "NUMBERED_PARAMETER_";
    private static final String SINGLE_PARAMETER_NAME = "it";
    private static final String PARAMETER_NAME = "p";

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = RBundle.message((String)"ruby.intention.convert.numbered.parameters.to.named");
        if (string == null) {
            RubyConvertNumberedParametersToNamedIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getText() {
        String string = RBundle.message((String)"ruby.intention.convert.numbered.parameters.to.named");
        if (string == null) {
            RubyConvertNumberedParametersToNamedIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            RubyConvertNumberedParametersToNamedIntention.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            RubyConvertNumberedParametersToNamedIntention.$$$reportNull$$$0(3);
        }
        if (element == null) {
            RubyConvertNumberedParametersToNamedIntention.$$$reportNull$$$0(4);
        }
        RIdentifier identifier = (RIdentifier)PsiTreeUtil.getParentOfType((PsiElement)element, RIdentifier.class);
        assert (identifier != null);
        ScopeHolder scopeHolder = ScopeUtilCore.findScopeHolder((PsiElement)identifier);
        assert (scopeHolder instanceof RCodeBlock);
        List numberedParameters = ContainerUtil.mapNotNull((Collection)scopeHolder.getScope().getNumberedParameters((PsiElement)scopeHolder), it -> {
            String name = it.isNumberedParameterAlias() ? "1" : StringUtil.trimStart((String)it.getText(), (String)"_");
            return new RubyNumberedParameterSymbol(scopeHolder, name);
        });
        if (numberedParameters.isEmpty()) {
            return;
        }
        TemplateManager manager = TemplateManager.getInstance((Project)project);
        Template template = RubyConvertNumberedParametersToNamedIntention.createTemplate(editor, manager, (RCodeBlock)scopeHolder, identifier, numberedParameters);
        TextRange range = scopeHolder.getTextRange();
        editor.getCaretModel().moveToOffset(range.getStartOffset());
        editor.getDocument().replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)"");
        manager.startTemplate(editor, template);
    }

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) {
        RIdentifier identifier;
        if (project == null) {
            RubyConvertNumberedParametersToNamedIntention.$$$reportNull$$$0(5);
        }
        if (editor == null) {
            RubyConvertNumberedParametersToNamedIntention.$$$reportNull$$$0(6);
        }
        if (element == null) {
            RubyConvertNumberedParametersToNamedIntention.$$$reportNull$$$0(7);
        }
        if ((identifier = (RIdentifier)PsiTreeUtil.getParentOfType((PsiElement)element, RIdentifier.class)) == null || !identifier.isNumberedParameter()) {
            return false;
        }
        ScopeHolder scopeHolder = ScopeUtilCore.findScopeHolder((PsiElement)identifier);
        return scopeHolder instanceof RCodeBlock && !RubyPsiUtil.hasBlockOrLambdaArguments(scopeHolder);
    }

    @NotNull
    private static Template createTemplate(@NotNull Editor editor, @NotNull TemplateManager manager, @NotNull RCodeBlock scopeHolder, @NotNull RIdentifier identifier, @NotNull List<RubyNumberedParameterSymbol> numberedParameters) {
        if (editor == null) {
            RubyConvertNumberedParametersToNamedIntention.$$$reportNull$$$0(8);
        }
        if (manager == null) {
            RubyConvertNumberedParametersToNamedIntention.$$$reportNull$$$0(9);
        }
        if (scopeHolder == null) {
            RubyConvertNumberedParametersToNamedIntention.$$$reportNull$$$0(10);
        }
        if (identifier == null) {
            RubyConvertNumberedParametersToNamedIntention.$$$reportNull$$$0(11);
        }
        if (numberedParameters == null) {
            RubyConvertNumberedParametersToNamedIntention.$$$reportNull$$$0(12);
        }
        Template template = manager.createTemplate(RubyConvertNumberedParametersToNamedIntention.class.getSimpleName(), "Ruby");
        String text = scopeHolder.getText();
        int offset = scopeHolder.getFirstChild().getTextLength();
        template.addTextSegment(text.substring(0, offset));
        CommonCodeStyleSettings commonSettings = CodeStyle.getSettings((Editor)editor).getCommonSettings((Language)RubyLanguage.INSTANCE);
        if (scopeHolder instanceof RDoCodeBlock || commonSettings.SPACE_WITHIN_ARRAY_INITIALIZER_BRACES) {
            template.addTextSegment(" ");
        }
        template.addTextSegment("|");
        int parametersCount = numberedParameters.stream().mapToInt(it -> it.getIndex() + 1).max().orElse(0);
        for (int i = 1; i <= parametersCount; ++i) {
            String name = String.valueOf(i);
            if (parametersCount == 1) {
                template.addVariable(VAR_PREFIX + i, (Expression)new ConstantNode(SINGLE_PARAMETER_NAME), true);
            } else if (!ContainerUtil.exists(numberedParameters, parameter -> parameter.getName().equals(name))) {
                template.addVariable(VAR_PREFIX + i, (Expression)new ConstantNode("_"), false);
            } else {
                template.addVariable(VAR_PREFIX + i, (Expression)new ConstantNode(PARAMETER_NAME + i), true);
            }
            if (i == parametersCount) continue;
            template.addTextSegment(", ");
        }
        template.addTextSegment("|");
        for (PsiSymbolReference reference : ContainerUtil.sorted(RubyConvertNumberedParametersToNamedIntention.getNumberedParameterReferences(numberedParameters), REFERENCE_COMPARATOR)) {
            int index;
            String referenceText = PsiSymbolReference.getReferenceText((PsiSymbolReference)reference);
            boolean isIt = referenceText.equals(SINGLE_PARAMETER_NAME);
            int n = index = isIt ? 1 : Integer.parseInt(referenceText);
            if (index > 0) {
                template.addTextSegment(text.substring(offset, reference.getAbsoluteRange().getStartOffset() - scopeHolder.getTextOffset() - (isIt ? 0 : 1)));
                template.addVariableSegment(VAR_PREFIX + index);
                offset = reference.getAbsoluteRange().getEndOffset() - scopeHolder.getTextOffset();
            }
            if (!reference.getElement().equals(identifier)) continue;
            template.addEndVariable();
        }
        template.addTextSegment(text.substring(offset));
        template.setToIndent(false);
        template.setToReformat(false);
        Template template2 = template;
        if (template2 == null) {
            RubyConvertNumberedParametersToNamedIntention.$$$reportNull$$$0(13);
        }
        return template2;
    }

    @NotNull
    private static List<PsiSymbolReference> getNumberedParameterReferences(@NotNull List<RubyNumberedParameterSymbol> symbols) {
        if (symbols == null) {
            RubyConvertNumberedParametersToNamedIntention.$$$reportNull$$$0(14);
        }
        final ArrayList<PsiSymbolReference> references = new ArrayList<PsiSymbolReference>();
        for (final RubyNumberedParameterSymbol symbol : symbols) {
            symbol.getScopeHolder().acceptChildren((PsiElementVisitor)new RubyRecursiveElementVisitor(){

                public void visitRIdentifier(@NotNull RIdentifier identifier) {
                    if (identifier == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    for (PsiSymbolReference reference : PsiSymbolReferenceService.getService().getReferences((PsiElement)identifier)) {
                        if (!reference.resolvesTo((Symbol)symbol)) continue;
                        references.add(reference);
                    }
                }

                public void visitElement(@NotNull PsiElement element) {
                    if (element == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (!(element instanceof ScopeHolder)) {
                        super.visitElement(element);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "identifier";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "element";
                            break;
                        }
                    }
                    objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/actions/intention/blocks/RubyConvertNumberedParametersToNamedIntention$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitRIdentifier";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitElement";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
        ArrayList<PsiSymbolReference> arrayList = references;
        if (arrayList == null) {
            RubyConvertNumberedParametersToNamedIntention.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 14 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/actions/intention/blocks/RubyConvertNumberedParametersToNamedIntention";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeHolder";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "numberedParameters";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbols";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/actions/intention/blocks/RubyConvertNumberedParametersToNamedIntention";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createTemplate";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getNumberedParameterReferences";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createTemplate";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getNumberedParameterReferences";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 14 -> new IllegalArgumentException(string);
        };
    }
}

