/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.actions.execution;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.GenericProgramRunner;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.ide.actions.runAnything.execution.RunAnythingRunProfile;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Pair;
import com.intellij.util.net.NetUtils;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.RubyUtil;
import org.jetbrains.plugins.ruby.ruby.debugger.RubyDebugMode;
import org.jetbrains.plugins.ruby.ruby.debugger.RubyDebugRunner;
import org.jetbrains.plugins.ruby.ruby.debugger.RubyProcessDispatcher;
import org.jetbrains.plugins.ruby.ruby.debugger.impl.LocalPositionConverter;
import org.jetbrains.plugins.ruby.ruby.debugger.impl.RubyDebugProcess;
import org.jetbrains.plugins.ruby.ruby.debugger.settings.RubyDebuggerSettings;
import org.jetbrains.plugins.ruby.ruby.run.PortForwarding;
import org.jetbrains.plugins.ruby.ruby.run.RubyLocalRunner;
import org.jetbrains.plugins.ruby.ruby.run.configuration.DebugGemHelper;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RubyAbstractCommandLineState;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkAdditionalData;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;
import org.jetbrains.plugins.ruby.utils.OSUtil;
import org.rubyforge.debugcommons.RubyDebuggerProxy;

public final class RunAnythingDebugRunner
extends GenericProgramRunner {
    public static final String ID = "RunAnythingDebugRunner";
    private static final Logger LOG = Logger.getInstance(RunAnythingDebugRunner.class);
    private static final String DEBUGGER_CLI_DEBUG = "DEBUGGER_CLI_DEBUG";

    @NotNull
    public String getRunnerId() {
        return ID;
    }

    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        if (executorId == null) {
            RunAnythingDebugRunner.$$$reportNull$$$0(0);
        }
        if (profile == null) {
            RunAnythingDebugRunner.$$$reportNull$$$0(1);
        }
        return "Debug".equals(executorId) && profile instanceof RunAnythingRunProfile;
    }

    @Nullable
    protected RunContentDescriptor doExecute(final @NotNull RunProfileState state, final @NotNull ExecutionEnvironment environment) throws ExecutionException {
        if (state == null) {
            RunAnythingDebugRunner.$$$reportNull$$$0(2);
        }
        if (environment == null) {
            RunAnythingDebugRunner.$$$reportNull$$$0(3);
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        LOG.debug("Initializing debugger service");
        if (environment.getDataContext() == null) {
            throw new ExecutionException(RBundle.message((String)"dialog.message.module.should.be.passed.as.data.to.execution.environment"));
        }
        final Project project = environment.getProject();
        Module module = (Module)PlatformCoreDataKeys.MODULE.getData(environment.getDataContext());
        RubyLocalRunner rubyRunner = RubyLocalRunner.getRunner(module);
        Pair<PortForwarding, PortForwarding> pair = rubyRunner.getDebuggerForwardings();
        int debuggerPort = ((PortForwarding)pair.getFirst()).getLocalPort();
        int dispatcherPort = ((PortForwarding)pair.getSecond()).getLocalPort();
        String dispatcherHost = ((PortForwarding)pair.getSecond()).getLocalHostName();
        Sdk sdk = RModuleUtil.getInstance().findRubySdkForModule(module);
        if (sdk == null) {
            throw new ExecutionException(RBundle.message((String)"dialog.message.can.t.debug.without.sdk"));
        }
        final DebugGemHelper debugGemHelper = RubyAbstractCommandLineState.selectDebugGemHelper(sdk, module, RubyDebugMode.NORMAL_MODE);
        if (!debugGemHelper.isUsable()) {
            throw new ExecutionException(RBundle.message((String)"ruby.debugger.cannot.start.debug", (Object[])new Object[]{debugGemHelper.getErrorMsg()}));
        }
        if (debugGemHelper.needsDebugPreLoader()) {
            RunAnythingDebugRunner.applyDebugStarterToEnv(((RunAnythingRunProfile)environment.getRunProfile()).getCommandLine(), rubyRunner, debuggerPort, dispatcherPort, sdk, debugGemHelper);
        }
        final int timeout = RubyDebuggerSettings.getInstance().getState().getTimeout();
        boolean supportsNonSuspendedFramesReading = RubyDebugRunner.supportsNonSuspendedFramesReading(debugGemHelper, sdk);
        boolean supportsCatchpointRemoval = debugGemHelper.supportsCatchpointRemoval();
        boolean supportsLoadingFullValue = debugGemHelper.supportsLoadingFullValue();
        boolean supportsTypeRenderer = debugGemHelper.supportsTypeRenderers();
        String localHostString = NetUtils.getLocalHostString();
        final ExecutionResult executionResult = state.execute(environment.getExecutor(), environment.getRunner());
        if (executionResult == null) {
            throw new ExecutionException(RBundle.message((String)"dialog.message.unable.to.start.process"));
        }
        final ProcessHandler serverProcessHandler = executionResult.getProcessHandler();
        final RubyDebuggerProxy rubyDebuggerProxy = new RubyDebuggerProxy(timeout, supportsNonSuspendedFramesReading, false, supportsCatchpointRemoval, supportsLoadingFullValue, supportsTypeRenderer);
        final RubyProcessDispatcher acceptor = RubyDebugRunner.getAcceptor(supportsNonSuspendedFramesReading, localHostString, dispatcherHost, supportsCatchpointRemoval, supportsLoadingFullValue, supportsTypeRenderer, dispatcherPort, true);
        rubyDebuggerProxy.setDebugTarget(RubyDebugRunner.getDebugTarget(null, serverProcessHandler, debuggerPort, rubyDebuggerProxy, localHostString));
        final boolean enableFileFiltering = debugGemHelper.supportFileFiltering() && RubyDebuggerSettings.getInstance().getState().isStepIntoProjectOnly();
        final LocalPositionConverter converter = new LocalPositionConverter(project, !RubySdkUtil.isRuby18(sdk));
        XDebugProcessStarter processStarter = new XDebugProcessStarter(){

            @NotNull
            public XDebugProcess start(@NotNull XDebugSession session) {
                if (session == null) {
                    1.$$$reportNull$$$0(0);
                }
                return new RubyDebugProcess(session, state, serverProcessHandler, rubyDebuggerProxy, timeout, converter, environment, acceptor, debugGemHelper.pauseActionSupported(), false, enableFileFiltering, debugGemHelper.getSourceRoots(project), debugGemHelper.getExcludedDirs(project)){

                    @Override
                    @NotNull
                    public ExecutionConsole createConsole() {
                        ExecutionConsole executionConsole = executionResult.getExecutionConsole();
                        if (executionConsole == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return executionConsole;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/ruby/ruby/actions/execution/RunAnythingDebugRunner$1$1", "createConsole"));
                    }
                };
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "org/jetbrains/plugins/ruby/ruby/actions/execution/RunAnythingDebugRunner$1", "start"));
            }
        };
        XDebugSession debugSession = XDebuggerManager.getInstance((Project)project).startSession(environment, processStarter);
        LOG.debug("Debugger service initialized. Starting RubyDebugProcess");
        return debugSession.getRunContentDescriptor();
    }

    private static void applyDebugStarterToEnv(@NotNull GeneralCommandLine commandLine, @NotNull RubyLocalRunner rubyRunner, int debuggerPort, int dispatcherPort, @NotNull Sdk sdk, @NotNull DebugGemHelper debugGemHelper) {
        if (commandLine == null) {
            RunAnythingDebugRunner.$$$reportNull$$$0(4);
        }
        if (rubyRunner == null) {
            RunAnythingDebugRunner.$$$reportNull$$$0(5);
        }
        if (sdk == null) {
            RunAnythingDebugRunner.$$$reportNull$$$0(6);
        }
        if (debugGemHelper == null) {
            RunAnythingDebugRunner.$$$reportNull$$$0(7);
        }
        Map env = commandLine.getEnvironment();
        String gemsPath = RubyUtil.getScriptFullPath("rb/gems");
        assert (gemsPath != null);
        RubySdkAdditionalData data = RubySdkUtil.getRubySdkAdditionalData(sdk);
        String rubyLib = OSUtil.prependToRUBYLIBEnvVariable(data.getSdkSystemAccessor(), (String)env.get("RUBYLIB"), RubySdkUtil.convertToRemote(sdk, rubyRunner.getModule(), gemsPath));
        env.put("RUBYLIB", rubyLib);
        env.put("RUBYMINE_DEBUG_PORT", String.valueOf(debuggerPort));
        env.put(DEBUGGER_CLI_DEBUG, String.valueOf(RubyDebuggerSettings.getInstance().getState().isVerboseOutput()));
        env.put("IDE_PROCESS_DISPATCHER", String.valueOf(dispatcherPort));
        debugGemHelper.configureEnvironment(env, data.getSdkSystemAccessor(), rubyRunner.addDefaultMappings(null));
        OSUtil.appendToEnvVariable("RUBYOPT", "-rrubymine_debug_anything.rb", env, " ");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executorId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rubyRunner";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugGemHelper";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/actions/execution/RunAnythingDebugRunner";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canRun";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "doExecute";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "applyDebugStarterToEnv";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

