/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.actions.editor;

import com.intellij.ide.actions.QualifiedNameProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.RubyFQNUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.ResolveUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.RElementWithFQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Types;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.cache.FQNCache;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RObjectClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modules.RModule;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RColonReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RConstant;
import org.jetbrains.plugins.ruby.ruby.presentation.RContainerPresentationUtil;

public final class RubyQualifiedNameProvider
implements QualifiedNameProvider {
    @Nullable
    public PsiElement adjustElementToCopy(@NotNull PsiElement element) {
        if (element == null) {
            RubyQualifiedNameProvider.$$$reportNull$$$0(0);
        }
        return null;
    }

    @Nullable
    public String getQualifiedName(@NotNull PsiElement element) {
        RColonReference reference;
        if (element == null) {
            RubyQualifiedNameProvider.$$$reportNull$$$0(1);
        }
        if (element instanceof RColonReference && !((reference = (RColonReference)element).getValue() instanceof RConstant)) {
            return null;
        }
        if (element instanceof RConstant || element instanceof RColonReference) {
            Symbol target = ResolveUtil.resolveToSymbolWithCaching(element.getReference());
            if (target == null) {
                return null;
            }
            return RContainerPresentationUtil.getHumanizedFQN((FQN)target.getFQNWithNesting());
        }
        if (!(element instanceof RElementWithFQN)) {
            return null;
        }
        RElementWithFQN elementWithFqn = (RElementWithFQN)element;
        FQN fqn = elementWithFqn.getFQNWithNesting();
        if (element instanceof RClass || element instanceof RModule) {
            return RContainerPresentationUtil.getHumanizedFQN((FQN)fqn, null, (PsiElement)element);
        }
        if (element instanceof RMethod) {
            String delimiter;
            FQN namespaceFQN = fqn.getCallerFQN();
            if ("$$SINGLETON$$".equals(namespaceFQN.getShortName())) {
                namespaceFQN = namespaceFQN.getCallerFQN();
                delimiter = ".";
            } else {
                delimiter = "#";
            }
            return (String)(namespaceFQN != FQN.INVALID ? namespaceFQN.getFullPath() + delimiter : "") + fqn.getShortName();
        }
        return null;
    }

    @Nullable
    public PsiElement qualifiedNameToElement(@NotNull String fqnString, @NotNull Project project) {
        int separatorIndex;
        boolean isConstant;
        if (fqnString == null) {
            RubyQualifiedNameProvider.$$$reportNull$$$0(2);
        }
        if (project == null) {
            RubyQualifiedNameProvider.$$$reportNull$$$0(3);
        }
        if (((String)fqnString).startsWith("singleton class of ")) {
            fqnString = ((String)fqnString).substring("singleton class of ".length()) + "::$$SINGLETON$$";
        }
        boolean bl = isConstant = (separatorIndex = StringUtil.lastIndexOfAny((CharSequence)(fqnString = StringUtil.replace((String)fqnString, (String)"<singleton class>", (String)"$$SINGLETON$$")), (String)"#:.")) + 1 < ((String)fqnString).length() && !Character.isLowerCase(((String)fqnString).charAt(separatorIndex + 1));
        if (isConstant) {
            FQN fqn = FQN.of((String)fqnString);
            Symbol symbol = SymbolUtil.findConstantByFQN(project, fqn, null);
            if (symbol != null) {
                return symbol.getPsiElement();
            }
            return FQNCache.getInstance(project).getAnyConstant(project, fqn, null);
        }
        boolean isSingletonMethod = false;
        if (separatorIndex != -1) {
            char separatorLastChar = ((String)fqnString).charAt(separatorIndex);
            isSingletonMethod = ":.".indexOf(separatorLastChar) != -1;
            switch (separatorLastChar) {
                case ':': {
                    fqnString = TextRange.create((int)Math.max(0, separatorIndex - 1), (int)(separatorIndex + 1)).replace((String)fqnString, ".");
                }
                case '#': {
                    fqnString = StringUtil.replace((String)fqnString, (String)"#", (String)".");
                }
            }
        }
        FQN fqn = FQN.of((String)fqnString);
        if (isSingletonMethod) {
            fqn = FQN.Builder.concat((FQN)RObjectClass.makeSingletonClassFQN((FQN)fqn.getCallerFQN()), (String)fqn.getShortName());
        }
        return RubyFQNUtil.findContainerByFQN(project, Types.METHODS_LIKE, fqn, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqnString";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/actions/editor/RubyQualifiedNameProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "adjustElementToCopy";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getQualifiedName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "qualifiedNameToElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

