/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.actions.editor;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.lang.RubyFileType;

public abstract class RubyEditorAction
extends AnAction
implements DumbAware {
    public final void execute(@Nullable Editor editor) {
        assert (editor != null);
        editor.getCaretModel().runForEachCaret(this::execute);
    }

    protected abstract void execute(@NotNull Caret var1);

    @NlsContexts.Command
    public abstract String getId();

    public abstract String @Nullable [] getFileTypes();

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            RubyEditorAction.$$$reportNull$$$0(0);
        }
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        PsiFile file = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        WriteCommandAction.runWriteCommandAction((Project)project, (String)this.getId(), null, () -> {
            if (file != null && project != null) {
                CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)file);
            }
            this.execute(editor);
        }, (PsiFile[])new PsiFile[0]);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            RubyEditorAction.$$$reportNull$$$0(1);
        }
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        PsiFile file = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        e.getPresentation().setEnabledAndVisible(this.isEnabled(project, editor, file));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            RubyEditorAction.$$$reportNull$$$0(2);
        }
        return actionUpdateThread;
    }

    protected boolean isEnabled(Project project, Editor editor, PsiFile file) {
        if (project == null || editor == null) {
            return false;
        }
        String[] fileTypes = this.getFileTypes();
        if (fileTypes != null) {
            if (file == null) {
                return false;
            }
            String name = file.getFileType().getName();
            for (String type : fileTypes) {
                if (!name.equals(type)) continue;
                return true;
            }
            return false;
        }
        return file == null || RubyFileType.RUBY == file.getFileType();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/actions/editor/RubyEditorAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/actions/editor/RubyEditorAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

