/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.actions;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.controlflow.ControlFlow;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandler;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerBase;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Consumer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.RControlFlow;
import org.jetbrains.plugins.ruby.ruby.lang.RubyLanguage;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlFlow.RControlFlowUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RBreakStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RNextStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RRedoStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RRetryStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RReturnStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RBodyStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modifierStatements.RModifierStatement;

public class RubyHighlightExitPointsHandler
extends HighlightUsagesHandlerBase<PsiElement>
implements DumbAware {
    private final PsiElement myTarget;

    public RubyHighlightExitPointsHandler(Editor editor, PsiFile file, PsiElement target) {
        super(editor, file);
        this.myTarget = target;
    }

    @NotNull
    public List<PsiElement> getTargets() {
        List<PsiElement> list = Collections.singletonList(this.myTarget);
        if (list == null) {
            RubyHighlightExitPointsHandler.$$$reportNull$$$0(0);
        }
        return list;
    }

    protected void selectTargets(@NotNull List<? extends PsiElement> targets, @NotNull Consumer<? super List<? extends PsiElement>> selectionConsumer) {
        if (targets == null) {
            RubyHighlightExitPointsHandler.$$$reportNull$$$0(1);
        }
        if (selectionConsumer == null) {
            RubyHighlightExitPointsHandler.$$$reportNull$$$0(2);
        }
        selectionConsumer.consume(targets);
    }

    public void computeUsages(@NotNull List<? extends PsiElement> targets) {
        PsiElement parent;
        if (targets == null) {
            RubyHighlightExitPointsHandler.$$$reportNull$$$0(3);
        }
        if (!((parent = this.myTarget.getParent()) instanceof RReturnStatement) && RubyHighlightExitPointsHandler.getMethodFromLastStatement(parent) == null) {
            return;
        }
        RMethod method = (RMethod)PsiTreeUtil.getParentOfType((PsiElement)this.myTarget, RMethod.class);
        if (method == null) {
            return;
        }
        this.highlightExitPoints(parent, method);
    }

    @Nullable
    private static PsiElement getExitTarget(PsiElement exitStatement) {
        if (exitStatement instanceof RReturnStatement) {
            return PsiTreeUtil.getParentOfType((PsiElement)exitStatement, RMethod.class);
        }
        if (exitStatement instanceof RBreakStatement) {
            return ((RBreakStatement)exitStatement).getLoop();
        }
        if (exitStatement instanceof RNextStatement) {
            return ((RNextStatement)exitStatement).getLoop();
        }
        if (exitStatement instanceof RRedoStatement) {
            return ((RRedoStatement)exitStatement).getLoop();
        }
        if (exitStatement instanceof RRetryStatement) {
            return ((RRetryStatement)exitStatement).getRetryContext();
        }
        return RubyHighlightExitPointsHandler.getMethodFromLastStatement(exitStatement);
    }

    static PsiElement getMethodFromLastStatement(PsiElement exitStatement) {
        if (exitStatement.getLanguage() != RubyLanguage.INSTANCE) {
            return null;
        }
        if (exitStatement.getNextSibling() == null) {
            PsiElement method;
            PsiElement parent = exitStatement.getParent();
            PsiElement body = parent != null ? parent.getParent() : null;
            PsiElement psiElement = method = body instanceof RBodyStatement ? body.getParent() : null;
            if (method instanceof RMethod) {
                return method;
            }
        }
        return null;
    }

    private void highlightExitPoints(PsiElement statement, RMethod method) {
        RControlFlow flow = method.getControlFlow();
        Collection<PsiElement> exitStatements = RubyHighlightExitPointsHandler.findReturnStatements(RControlFlowUtil.findExitPointsAndStatements((ControlFlow)flow));
        if (!exitStatements.contains(statement)) {
            return;
        }
        PsiElement originalTarget = RubyHighlightExitPointsHandler.getExitTarget(statement);
        for (PsiElement exitStatement : exitStatements) {
            if (RubyHighlightExitPointsHandler.getExitTarget(exitStatement) != originalTarget) continue;
            this.addOccurrence(exitStatement);
        }
        this.myStatusText = CodeInsightBundle.message((String)"status.bar.exit.points.highlighted.message", (Object[])new Object[]{exitStatements.size(), HighlightUsagesHandler.getShortcutText()});
    }

    private static Collection<PsiElement> findReturnStatements(Collection<? extends PsiElement> statements) {
        ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        for (PsiElement psiElement : statements) {
            if (psiElement instanceof RModifierStatement) {
                result.add((PsiElement)((RModifierStatement)psiElement).getCommand());
                continue;
            }
            result.add(psiElement);
        }
        return result;
    }

    @Nullable
    public String getFeatureId() {
        return "codeassists.highlight.return";
    }

    public boolean highlightReferences() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/actions/RubyHighlightExitPointsHandler";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targets";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectionConsumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargets";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/actions/RubyHighlightExitPointsHandler";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "selectTargets";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "computeUsages";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3 -> new IllegalArgumentException(string);
        };
    }
}

