/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby;

import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.ModuleAttachProcessor;
import com.intellij.projectImport.ProjectAttachProcessor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PairProcessor;
import com.intellij.util.PlatformUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RubyLanguageLevelService;
import org.jetbrains.plugins.ruby.ruby.module.RubyModuleSettings;
import org.jetbrains.plugins.ruby.ruby.module.RubyModuleTypeBase;
import org.jetbrains.plugins.ruby.ruby.sdk.LanguageLevel;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkType;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySupportProvider;
import org.jetbrains.plugins.ruby.settings.RSupportPerModuleSettings;

public final class RModuleUtil {
    private static final Logger LOG = Logger.getInstance(RModuleUtil.class);

    @Contract(value="null,_,_,_ -> null")
    @Nullable
    public static VirtualFile findFileInModuleRoot(@Nullable Module module, boolean doRefresh, boolean honorExclusion, String ... relativePaths) {
        if (relativePaths == null) {
            RModuleUtil.$$$reportNull$$$0(0);
        }
        Ref ref = Ref.create();
        RModuleUtil.processFilesInModuleRoot(module, doRefresh, honorExclusion, (PairProcessor<? super VirtualFile, ? super VirtualFile>)((PairProcessor)(file, root) -> {
            ProgressManager.checkCanceled();
            ref.set(file);
            return false;
        }), relativePaths);
        return (VirtualFile)ref.get();
    }

    public static void processFilesInModuleRoot(@Nullable Module module, boolean doRefresh, boolean honorExclusion, PairProcessor<? super VirtualFile, ? super VirtualFile> processor, String ... relativePaths) {
        if (relativePaths == null) {
            RModuleUtil.$$$reportNull$$$0(1);
        }
        if (module == null || module.isDisposed()) {
            return;
        }
        Project project = module.getProject();
        ProjectFileIndex fileIndex = ProjectFileIndex.getInstance((Project)project);
        for (VirtualFile root : RModuleUtil.getContentRoots(module)) {
            boolean isContinue;
            if (doRefresh) {
                root.refresh(false, false);
            }
            if (isContinue = ((Boolean)ReadAction.nonBlocking(() -> {
                for (String relativePath : relativePaths) {
                    ProgressManager.checkCanceled();
                    VirtualFile targetFile = root.findFileByRelativePath(FileUtil.toSystemIndependentName((String)relativePath));
                    if (targetFile == null || !targetFile.isValid() || honorExclusion && fileIndex.isExcluded(targetFile) || processor.process((Object)targetFile, (Object)root)) continue;
                    return false;
                }
                return true;
            }).executeSynchronously()).booleanValue()) continue;
            return;
        }
    }

    public static VirtualFile[] getContentRoots(@NotNull Module module) {
        Object[] roots;
        if (module == null) {
            RModuleUtil.$$$reportNull$$$0(2);
        }
        if ((roots = ModuleRootManager.getInstance((Module)module).getContentRoots()).length > 1) {
            Path moduleFile = module.getModuleNioFile();
            LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
            for (int i = 0; i < roots.length; ++i) {
                Path nioRoot;
                VirtualFile root = roots[i];
                if (root.getFileSystem() != localFileSystem || !moduleFile.equals(nioRoot = root.toNioPath()) && !moduleFile.startsWith(nioRoot)) continue;
                ArrayUtil.swap((Object[])roots, (int)0, (int)i);
                break;
            }
        }
        return roots;
    }

    public static RModuleUtil getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private RModuleUtil() {
    }

    public Module[] getAllModulesWithRubySupport(@NotNull Project project) {
        if (project == null) {
            RModuleUtil.$$$reportNull$$$0(3);
        }
        SmartList result = new SmartList();
        ApplicationManager.getApplication().runReadAction(() -> this.lambda$getAllModulesWithRubySupport$2(project, (List)result));
        return result.toArray(Module.EMPTY_ARRAY);
    }

    @Contract(value="null -> false")
    public boolean hasRubySupport(@Nullable Module module) {
        if (module == null || module.isDisposed()) {
            return false;
        }
        if (this.isRubyModule(module)) {
            return true;
        }
        for (RubySupportProvider rubySupportProvider : RubySupportProvider.EP_NAME.getExtensionList()) {
            if (!rubySupportProvider.hasRubySupport(module)) continue;
            return true;
        }
        return false;
    }

    public boolean isRubyModule(@Nullable Module module) {
        return module != null && this.isRubyModuleType(ModuleType.get((Module)module));
    }

    public boolean isRubyModuleType(@Nullable ModuleType moduleType) {
        return moduleType instanceof RubyModuleTypeBase;
    }

    @Contract(value="null -> null")
    @Nullable
    public VirtualFile getFirstContentRoot(@Nullable Module module) {
        return module == null || module.isDisposed() ? null : (VirtualFile)ArrayUtil.getFirstElement((Object[])ModuleRootManager.getInstance((Module)module).getContentRoots());
    }

    @Nullable
    public VirtualFile getFirstContentRoot(@NotNull ModuleRootModel rootModel) {
        if (rootModel == null) {
            RModuleUtil.$$$reportNull$$$0(4);
        }
        return (VirtualFile)ArrayUtil.getFirstElement((Object[])rootModel.getContentRoots());
    }

    public void refreshRubyModuleTypeContent(Module module) {
        try {
            ApplicationManager.getApplication().invokeAndWait(() -> {
                VirtualFile moduleRoot = this.getFirstContentRoot(module);
                if (moduleRoot != null) {
                    moduleRoot.refresh(false, true);
                }
            });
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    public RSupportPerModuleSettings getRubyModuleSettings(@NotNull Module module) {
        if (module == null) {
            RModuleUtil.$$$reportNull$$$0(5);
        }
        for (RubySupportProvider provider : RubySupportProvider.EP_NAME.getExtensionList()) {
            RSupportPerModuleSettings settings = provider.findRubySettings(module);
            if (settings == null) continue;
            return settings;
        }
        return RubyModuleSettings.getInstance(module);
    }

    @Nullable
    public Module getModule(@NotNull DataContext dataContext) {
        Module module;
        if (dataContext == null) {
            RModuleUtil.$$$reportNull$$$0(6);
        }
        if ((module = (Module)dataContext.getData(PlatformCoreDataKeys.MODULE)) != null) {
            return module;
        }
        Project project = (Project)dataContext.getData(CommonDataKeys.PROJECT);
        if (project != null) {
            return this.getModuleWithRubySupport(project);
        }
        return null;
    }

    @Deprecated
    @ApiStatus.Internal
    @Nullable
    public Module getModuleWithRubySupport(@NotNull Project project) {
        Module[] modules;
        if (project == null) {
            RModuleUtil.$$$reportNull$$$0(7);
        }
        if ((modules = this.getAllModulesWithRubySupport(project)).length == 1) {
            return modules[0];
        }
        if (ProjectAttachProcessor.canAttachToProject()) {
            return (Module)ReadAction.compute(() -> {
                if (project.isDisposed()) {
                    return null;
                }
                Module primaryModule = ModuleAttachProcessor.getPrimaryModule((Project)project);
                if (this.isRubyModule(primaryModule)) {
                    return primaryModule;
                }
                return null;
            });
        }
        return null;
    }

    public boolean changeModuleSdk(@Nullable Sdk sdk, @NotNull Module module) {
        if (module == null) {
            RModuleUtil.$$$reportNull$$$0(8);
        }
        if (this.isRubyModule(module)) {
            ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module);
            Sdk currentSdk = rootManager.getSdk();
            if (currentSdk != sdk) {
                ModuleRootModificationUtil.setModuleSdk((Module)module, (Sdk)sdk);
                return true;
            }
            return false;
        }
        for (RubySupportProvider rubySupportProvider : RubySupportProvider.EP_NAME.getExtensionList()) {
            if (!rubySupportProvider.updateFacetSdk(module, sdk)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public LanguageLevel getLanguageLevelByModule(Module module) {
        LanguageLevel languageLevel = RubyLanguageLevelService.getEffectiveLanguageLevel((Sdk)this.findRubySdkForModule(module));
        if (languageLevel == null) {
            RModuleUtil.$$$reportNull$$$0(9);
        }
        return languageLevel;
    }

    public boolean isMultiProject(@NotNull Project project) {
        if (project == null) {
            RModuleUtil.$$$reportNull$$$0(10);
        }
        return PlatformUtils.isRubyMine() && this.getAllModulesWithRubySupport(project).length > 1;
    }

    @Contract(value="null -> false")
    public boolean isInMultiProject(@Nullable Module module) {
        return module != null && this.isMultiProject(module.getProject());
    }

    @Nullable
    public Project getProject(@Nullable Module module) {
        return module != null ? module.getProject() : null;
    }

    @Nullable
    public Sdk findRubySdkForVirtualFile(@Nullable Project project, @Nullable VirtualFile virtualFile) {
        if (virtualFile == null || project == null) {
            return null;
        }
        return this.findRubySdkForModule(ScratchUtil.isScratch((VirtualFile)virtualFile) ? (Module)ContainerUtil.getFirstItem(Arrays.asList(this.getAllModulesWithRubySupport(project))) : ModuleUtilCore.findModuleForFile((VirtualFile)virtualFile, (Project)project));
    }

    @Contract(value="null -> null")
    @Nullable
    public Sdk findRubySdkForModule(@Nullable Module module) {
        Sdk sdk;
        if (module == null || module.isDisposed()) {
            return null;
        }
        if (this.isRubyModule(module) && (sdk = ModuleRootManager.getInstance((Module)module).getSdk()) != null && sdk.getSdkType() instanceof RubySdkType) {
            return sdk;
        }
        for (RubySupportProvider rubySupportProvider : RubySupportProvider.EP_NAME.getExtensionList()) {
            Sdk sdkFromProvider = rubySupportProvider.findRubySdk(module);
            if (sdkFromProvider == null) continue;
            return sdkFromProvider;
        }
        return null;
    }

    private /* synthetic */ void lambda$getAllModulesWithRubySupport$2(Project project, List result) {
        if (project.isDisposed()) {
            return;
        }
        Arrays.stream(ModuleManager.getInstance((Project)project).getModules()).filter(this::hasRubySupport).forEach(result::add);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePaths";
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootModel";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/RModuleUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/RModuleUtil";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageLevelByModule";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findFileInModuleRoot";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "processFilesInModuleRoot";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getContentRoots";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAllModulesWithRubySupport";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getFirstContentRoot";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getRubyModuleSettings";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getModule";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getModuleWithRubySupport";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "changeModuleSdk";
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isMultiProject";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9 -> new IllegalStateException(string);
        };
    }

    private static class SingletonHolder {
        private static final RModuleUtil INSTANCE = new RModuleUtil();

        private SingletonHolder() {
        }
    }
}

