/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.remote;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModel;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.impl.ProjectJdkImpl;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.CredentialsType;
import com.intellij.remote.RemoteConnectionCredentialsWrapper;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remote.RemoteSdkPropertiesHolder;
import com.intellij.remote.ext.CredentialsCase;
import com.intellij.remote.ext.CredentialsManager;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.ThrowableConsumer;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.jdom.Attribute;
import org.jdom.DataConversionException;
import org.jdom.Element;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.remote.RubyRemoteInterpreterManager;
import org.jetbrains.plugins.ruby.ruby.run.RubyRunner;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkAdditionalData;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkAdditionalDataBase;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkSystemAccessor;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkType;
import org.jetbrains.plugins.ruby.ruby.sdk.implementation.RubyImplementationHandler;
import org.jetbrains.plugins.ruby.ruby.sdk.jruby.JRubySdkUtil;
import org.jetbrains.plugins.ruby.utils.VirtualFileUtil;
import org.jetbrains.plugins.ruby.version.management.rvm.RVMSupportUtil;
import org.jetbrains.plugins.ruby.version.management.rvm.RvmSettings;

public final class RubyRemoteSdkAdditionalData
extends RubySdkAdditionalData
implements RemoteSdkAdditionalData {
    private static final Logger LOG = Logger.getInstance(RubyRemoteSdkAdditionalData.class);
    private static final int CURRENT_VERSION = 2;
    private static final String DATA_VERSION = "DATA-VERSION";
    private static final String AVAILABLE_FOR_NEW_PROJECTS_ATTRIBUTE_NAME = "AVAILABLE_FOR_NEW_PROJECTS";
    private static final String RUBYMINE_HELPERS = ".rubymine_helpers";
    private final RemoteConnectionCredentialsWrapper myWrapper;
    private final RemoteSdkPropertiesHolder myRemoteSdkProperties;
    private boolean myIsAvailableForNewProjects;
    private PathMappingSettings myGemsMappings;

    public RubyRemoteSdkAdditionalData(@NotNull String path) {
        if (path == null) {
            RubyRemoteSdkAdditionalData.$$$reportNull$$$0(0);
        }
        this.myWrapper = new RemoteConnectionCredentialsWrapper();
        this.myRemoteSdkProperties = new RemoteSdkPropertiesHolder(RUBYMINE_HELPERS);
        this.myIsAvailableForNewProjects = false;
        this.myGemsMappings = new PathMappingSettings();
        this.setInterpreterPath(path);
    }

    @NotNull
    public RemoteConnectionCredentialsWrapper connectionCredentials() {
        RemoteConnectionCredentialsWrapper remoteConnectionCredentialsWrapper = this.myWrapper;
        if (remoteConnectionCredentialsWrapper == null) {
            RubyRemoteSdkAdditionalData.$$$reportNull$$$0(1);
        }
        return remoteConnectionCredentialsWrapper;
    }

    public String getInterpreterDir() {
        return this.computeInterpreterDir(this.getInterpreterPath());
    }

    public String getInterpreterPath() {
        return this.myRemoteSdkProperties.getInterpreterPath();
    }

    public void setInterpreterPath(String interpreterPath) {
        this.assertWritable();
        this.myRemoteSdkProperties.setInterpreterPath(interpreterPath);
    }

    @Override
    @NotNull
    public String getInterpreterPath(@NotNull Sdk sdk) {
        SdkAdditionalData otherAdditionalData;
        if (sdk == null) {
            RubyRemoteSdkAdditionalData.$$$reportNull$$$0(2);
        }
        if (!this.equals(otherAdditionalData = sdk.getSdkAdditionalData())) {
            LOG.error("Wrong sdk - " + String.valueOf(sdk) + "; this: " + String.valueOf((Object)this) + "; other: " + String.valueOf(otherAdditionalData));
            throw new IllegalArgumentException("Wrong sdk - " + String.valueOf(sdk));
        }
        String string = this.getInterpreterPath();
        if (string == null) {
            RubyRemoteSdkAdditionalData.$$$reportNull$$$0(3);
        }
        return string;
    }

    public String getSdkId() {
        return RubyRemoteSdkAdditionalData.constructSdkID(this.myWrapper, this.myRemoteSdkProperties);
    }

    public void setSdkId(String sdkId) {
        this.assertWritable();
        this.myRemoteSdkProperties.setSdkId(sdkId);
    }

    public String getHelpersPath() {
        return this.myRemoteSdkProperties.getHelpersPath();
    }

    public void setHelpersPath(String helpersPath) {
        this.assertWritable();
        this.myRemoteSdkProperties.setHelpersPath(helpersPath);
    }

    public String getDefaultHelpersName() {
        return this.myRemoteSdkProperties.getDefaultHelpersName();
    }

    public boolean isRunAsRootViaSudo() {
        return this.myRemoteSdkProperties.isRunAsRootViaSudo();
    }

    public void setRunAsRootViaSudo(boolean runAsRootViaSudo) {
        this.assertWritable();
        this.myRemoteSdkProperties.setRunAsRootViaSudo(runAsRootViaSudo);
    }

    @Override
    public void checkValid(@NotNull SdkModel sdkModel) {
        if (sdkModel == null) {
            RubyRemoteSdkAdditionalData.$$$reportNull$$$0(4);
        }
    }

    @NotNull
    public PathMappingSettings getPathMappings() {
        PathMappingSettings pathMappingsCopy = new PathMappingSettings();
        pathMappingsCopy.addAll(this.myGemsMappings);
        PathMappingSettings pathMappingSettings = this.getRunner(null).customizePathMappings(pathMappingsCopy);
        if (pathMappingSettings == null) {
            RubyRemoteSdkAdditionalData.$$$reportNull$$$0(5);
        }
        return pathMappingSettings;
    }

    public void addPathMapping(@NotNull String localPath, @NotNull String remotePath) {
        if (localPath == null) {
            RubyRemoteSdkAdditionalData.$$$reportNull$$$0(6);
        }
        if (remotePath == null) {
            RubyRemoteSdkAdditionalData.$$$reportNull$$$0(7);
        }
        this.myGemsMappings.addMappingCheckUnique(localPath, remotePath);
    }

    @Override
    public void addLoadPathMappings(@NotNull Sdk sdk) {
        if (sdk == null) {
            RubyRemoteSdkAdditionalData.$$$reportNull$$$0(8);
        }
        ArrayList<String> mergedLoadPaths = new ArrayList<String>();
        RubyImplementationHandler.notNullFrom(sdk).getLoadPath().forEach(newPath -> {
            Iterator iterator = mergedLoadPaths.iterator();
            while (iterator.hasNext()) {
                String mergedPath = (String)iterator.next();
                if (StringUtil.startsWith((CharSequence)newPath, (CharSequence)mergedPath)) {
                    return;
                }
                if (!StringUtil.startsWith((CharSequence)mergedPath, (CharSequence)newPath)) continue;
                iterator.remove();
            }
            mergedLoadPaths.add((String)newPath);
        });
        String sdkCacheRoot = RubyRemoteSdkAdditionalData.getLocalGemsRootPath(sdk);
        mergedLoadPaths.forEach(it -> this.addPathMapping(new File(sdkCacheRoot, (String)it).toString(), (String)it));
    }

    @Override
    public Set<String> buildSdkLoadPath(@NotNull Sdk sdk) {
        if (sdk == null) {
            RubyRemoteSdkAdditionalData.$$$reportNull$$$0(9);
        }
        LinkedHashSet<String> urls = new LinkedHashSet<String>(this.getGemsRootUrls());
        PathMappingSettings mappings = RubyRunner.notNullFrom(sdk).addDefaultMappings(null);
        RubyImplementationHandler.notNullFrom(sdk).getLoadPath().forEach(it -> urls.add(VirtualFileUtil.constructLocalUrl(mappings.convertToLocal(it))));
        if (JRubySdkUtil.isJRubySDK(sdk)) {
            urls.add(JRubySdkUtil.getSourcesPathInJRubyJarFile(sdk, mappings));
        }
        RubySdkType.addRubyStubsUrls(urls, sdk);
        return urls;
    }

    public void setPathMappings(@Nullable PathMappingSettings pathMappings) {
        this.assertWritable();
        this.myGemsMappings = new PathMappingSettings();
        if (pathMappings != null) {
            this.myGemsMappings.addAll(pathMappings);
        }
    }

    public boolean isHelpersVersionChecked() {
        return this.myRemoteSdkProperties.isHelpersVersionChecked();
    }

    public void setHelpersVersionChecked(boolean helpersVersionChecked) {
        this.assertWritable();
        this.myRemoteSdkProperties.setHelpersVersionChecked(helpersVersionChecked);
    }

    public boolean isValid() {
        return this.myRemoteSdkProperties.isValid();
    }

    public void setValid(boolean valid) {
        this.assertWritable();
        this.myRemoteSdkProperties.setValid(valid);
    }

    @Override
    public void save(@NotNull Element rootElement) {
        if (rootElement == null) {
            RubyRemoteSdkAdditionalData.$$$reportNull$$$0(10);
        }
        super.save(rootElement);
        rootElement.setAttribute(DATA_VERSION, Integer.toString(2));
        this.myRemoteSdkProperties.save(rootElement);
        rootElement.setAttribute(AVAILABLE_FOR_NEW_PROJECTS_ATTRIBUTE_NAME, Boolean.toString(this.isAvailableForNewProjects()));
        PathMappingSettings.writeExternal((Element)rootElement, (PathMappingSettings)this.myGemsMappings);
        this.myWrapper.save(rootElement);
    }

    public static RubyRemoteSdkAdditionalData create(@NotNull String interpreterPath) {
        if (interpreterPath == null) {
            RubyRemoteSdkAdditionalData.$$$reportNull$$$0(11);
        }
        return new RubyRemoteSdkAdditionalData(interpreterPath);
    }

    @Override
    public String toString() {
        return "RubyRemoteSdkAdditionalData{myRemoteConnectionCredentialsWrapper=" + String.valueOf(this.myWrapper) + ", myRemoteSdkProperties=" + String.valueOf(this.myRemoteSdkProperties) + ", myIsAvailableForNewProjects=" + this.myIsAvailableForNewProjects + ", myGemsMappings=" + String.valueOf(this.myGemsMappings) + ", myPlatform=" + this.getPlatform() + ", additionalData=" + super.toString() + "}";
    }

    @Override
    @NotNull
    public RubyRunner getRunner(@Nullable Module module) {
        RubyRunner rubyRunner = RubyRemoteInterpreterManager.getInstance().getRunner(this, module);
        if (rubyRunner == null) {
            RubyRemoteSdkAdditionalData.$$$reportNull$$$0(12);
        }
        return rubyRunner;
    }

    @Override
    @NotNull
    public RubySdkSystemAccessor getSdkSystemAccessor() {
        RubySdkSystemAccessor rubySdkSystemAccessor = RubyRemoteInterpreterManager.getInstance().getRubySdkSystemAccessor(this);
        if (rubySdkSystemAccessor == null) {
            RubyRemoteSdkAdditionalData.$$$reportNull$$$0(13);
        }
        return rubySdkSystemAccessor;
    }

    @Override
    @NotNull
    public RvmSettings getRvmSettings() {
        return new RvmSettings(){

            @Override
            public boolean isRvmSupportEnabled() {
                return RVMSupportUtil.isRVMInterpreter(RubyRemoteSdkAdditionalData.this.getVersionManagerSdkAdditionalData());
            }

            @Override
            @NotNull
            public String getRvmHomePath() {
                assert (this.isRvmSupportEnabled());
                String string = FileUtilRt.toSystemIndependentName((String)new File(RubyRemoteSdkAdditionalData.this.getInterpreterPath()).getParentFile().getParentFile().getParentFile().getParent());
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/ruby/remote/RubyRemoteSdkAdditionalData$1", "getRvmHomePath"));
            }
        };
    }

    public <C> void setCredentials(Key<C> key, C credentials) {
        this.assertWritable();
        this.myWrapper.setCredentials(key, credentials);
    }

    public CredentialsType<?> getRemoteConnectionType() {
        return this.myWrapper.getRemoteConnectionType();
    }

    public void switchOnConnectionType(CredentialsCase ... cases) {
        this.myWrapper.switchType(cases);
    }

    public RemoteCredentials getRemoteCredentials(@Nullable Project project, boolean allowSynchronousInteraction) throws InterruptedException, ExecutionException {
        return RubyRemoteInterpreterManager.getInstance().getRemoteCredentials(this.myWrapper, project, allowSynchronousInteraction);
    }

    public void produceRemoteCredentials(@Nullable Project project, boolean allowSynchronousInteraction, @NotNull Consumer<RemoteCredentials> consumer) {
        if (consumer == null) {
            RubyRemoteSdkAdditionalData.$$$reportNull$$$0(14);
        }
        RubyRemoteInterpreterManager.getInstance().produceRemoteCredentials(this.myWrapper, project, allowSynchronousInteraction, consumer);
    }

    public Object getRemoteSdkDataKey() {
        return this.myWrapper.getConnectionKey();
    }

    @Override
    @NotNull
    public String getConnectionCredentialId() {
        String string = this.myWrapper.getId();
        if (string == null) {
            RubyRemoteSdkAdditionalData.$$$reportNull$$$0(15);
        }
        return string;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        RubyRemoteSdkAdditionalData data = (RubyRemoteSdkAdditionalData)((Object)o);
        if (!this.fieldsEqual((RubyRemoteSdkAdditionalData)((Object)o))) {
            return false;
        }
        return this.myWrapper.equals((Object)data.myWrapper);
    }

    @Override
    public int hashCode() {
        int result = super.fieldsHashCode();
        result = 31 * result + this.myWrapper.hashCode();
        return result;
    }

    public boolean isAvailableForNewProjects() {
        return this.myIsAvailableForNewProjects;
    }

    public void setAvailableForNewProjects(boolean availableForNewProjects) {
        this.assertWritable();
        this.myIsAvailableForNewProjects = availableForNewProjects;
    }

    @NotNull
    public static RubyRemoteSdkAdditionalData loadRemote(@NotNull String interpreterPath, @NotNull Sdk sdk, @NotNull Element element) {
        if (interpreterPath == null) {
            RubyRemoteSdkAdditionalData.$$$reportNull$$$0(16);
        }
        if (sdk == null) {
            RubyRemoteSdkAdditionalData.$$$reportNull$$$0(17);
        }
        if (element == null) {
            RubyRemoteSdkAdditionalData.$$$reportNull$$$0(18);
        }
        RubyRemoteSdkAdditionalData data = new RubyRemoteSdkAdditionalData(interpreterPath);
        data.myRemoteSdkProperties.load(element);
        data.setPathMappings(PathMappingSettings.readExternal((Element)element));
        Attribute availableAttribute = element.getAttribute(AVAILABLE_FOR_NEW_PROJECTS_ATTRIBUTE_NAME);
        if (availableAttribute != null) {
            try {
                data.setAvailableForNewProjects(availableAttribute.getBooleanValue());
            }
            catch (DataConversionException e) {
                LOG.warn((Throwable)e);
            }
        }
        RubyRemoteSdkAdditionalData.load(data, interpreterPath, sdk, element);
        CredentialsManager.getInstance().loadCredentials(interpreterPath, element, (RemoteSdkAdditionalData)data);
        CredentialsManager.updateOutdatedSdk((RemoteSdkAdditionalData)data, null);
        RubyRemoteInterpreterManager.getInstance().fullyLoadCredentials(data);
        if (sdk instanceof ProjectJdkImpl) {
            SdkModificator modificator = sdk.getSdkModificator();
            modificator.setHomePath(data.getSdkId());
            WriteAction.run(() -> modificator.commitChanges());
        }
        RubyRemoteSdkAdditionalData rubyRemoteSdkAdditionalData = data;
        if (rubyRemoteSdkAdditionalData == null) {
            RubyRemoteSdkAdditionalData.$$$reportNull$$$0(19);
        }
        return rubyRemoteSdkAdditionalData;
    }

    @Contract(value="null -> null")
    @Nullable
    public static RubyRemoteSdkAdditionalData from(@Nullable Sdk sdk) {
        RubyRemoteSdkAdditionalData remoteData;
        RubySdkAdditionalData rubySdkAdditionalData = RubySdkAdditionalData.from(sdk);
        return rubySdkAdditionalData instanceof RubyRemoteSdkAdditionalData ? (remoteData = (RubyRemoteSdkAdditionalData)rubySdkAdditionalData) : null;
    }

    @NotNull
    public static RubyRemoteSdkAdditionalData notNullFrom(@NotNull Sdk sdk) {
        if (sdk == null) {
            RubyRemoteSdkAdditionalData.$$$reportNull$$$0(20);
        }
        RubyRemoteSdkAdditionalData rubyRemoteSdkAdditionalData = Objects.requireNonNull(RubyRemoteSdkAdditionalData.from(sdk), () -> "Failed to extract remote sdk data from " + String.valueOf(sdk));
        if (rubyRemoteSdkAdditionalData == null) {
            RubyRemoteSdkAdditionalData.$$$reportNull$$$0(21);
        }
        return rubyRemoteSdkAdditionalData;
    }

    private static String constructSdkID(RemoteConnectionCredentialsWrapper wrapper, RemoteSdkPropertiesHolder properties) {
        return wrapper.getId() + properties.getInterpreterPath();
    }

    @NotNull
    public static String getLocalGemsRootPath(@NotNull Sdk sdk) {
        if (sdk == null) {
            RubyRemoteSdkAdditionalData.$$$reportNull$$$0(22);
        }
        return RubyRemoteSdkAdditionalData.getLocalGemsRootPath(RubyRemoteSdkAdditionalData.notNullFrom(sdk));
    }

    @NotNull
    public static String getLocalGemsRootPath(@NotNull RubyRemoteSdkAdditionalData data) {
        if (data == null) {
            RubyRemoteSdkAdditionalData.$$$reportNull$$$0(23);
        }
        String sdkIdHash = String.valueOf(FileUtil.toSystemIndependentName((String)data.getSdkId()).hashCode());
        String string = FileUtil.toCanonicalPath((String)FileUtil.join((String[])new String[]{RubyRemoteSdkAdditionalData.getLocalCacheRoot(), sdkIdHash}));
        if (string == null) {
            RubyRemoteSdkAdditionalData.$$$reportNull$$$0(24);
        }
        return string;
    }

    @NotNull
    public static String getLocalCacheRoot() {
        String string = FileUtil.join((String[])new String[]{PathManager.getSystemPath(), "ruby_stubs"});
        if (string == null) {
            RubyRemoteSdkAdditionalData.$$$reportNull$$$0(25);
        }
        return string;
    }

    public static <E extends Throwable> void modifyRemote(@Nullable Sdk sdk, @NotNull ThrowableConsumer<RubyRemoteSdkAdditionalData, E> modifier) throws E {
        if (modifier == null) {
            RubyRemoteSdkAdditionalData.$$$reportNull$$$0(26);
        }
        RubySdkAdditionalDataBase.modify((Sdk)sdk, modifier);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 5, 12, 13, 15, 19, 21, 24, 25 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 12: 
            case 13: 
            case 15: 
            case 19: 
            case 21: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/remote/RubyRemoteSdkAdditionalData";
                break;
            }
            case 2: 
            case 8: 
            case 9: 
            case 17: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkModel";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localPath";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remotePath";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootElement";
                break;
            }
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterPath";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/remote/RubyRemoteSdkAdditionalData";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "connectionCredentials";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterpreterPath";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathMappings";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunner";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkSystemAccessor";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getConnectionCredentialId";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "loadRemote";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "notNullFrom";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalGemsRootPath";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalCacheRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 12: 
            case 13: 
            case 15: 
            case 19: 
            case 21: 
            case 24: 
            case 25: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getInterpreterPath";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkValid";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addPathMapping";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addLoadPathMappings";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "buildSdkLoadPath";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "save";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "produceRemoteCredentials";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "loadRemote";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "notNullFrom";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getLocalGemsRootPath";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "modifyRemote";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 5, 12, 13, 15, 19, 21, 24, 25 -> new IllegalStateException(string);
        };
    }
}

