/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.remote;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.util.Key;
import com.intellij.remote.RemoteConnectionCredentialsWrapper;
import com.intellij.remote.RemoteCredentials;
import com.intellij.util.messages.Topic;
import java.util.Collection;
import java.util.function.Consumer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.remote.RubyRemoteSdkAdditionalData;
import org.jetbrains.plugins.ruby.remote.RubyRemoteSdkTransferListener;
import org.jetbrains.plugins.ruby.ruby.run.RubyRunner;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkSystemAccessor;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkType;

public abstract class RubyRemoteInterpreterManager {
    public static final Topic<RubyRemoteSdkTransferListener> RUBY_REMOTE_SDK_TRANSFER_LISTENER_TOPIC = new Topic("Sdk transfer state changed", RubyRemoteSdkTransferListener.class);
    protected static final Key<Boolean> RUBY_REMOTE_SDK_TRANSFER_STATE_KEY = new Key("RUBY_REMOTE_SDK_TRANSFER_STATE_KEY");

    @Nullable
    public abstract Sdk addRemoteSdk(@Nullable Project var1, @NotNull Collection<Sdk> var2, SdkType @NotNull [] var3);

    public abstract boolean isEnabled();

    public abstract boolean isRemoteSdk(@Nullable String var1);

    @Contract(value="null -> false")
    public static boolean isRemoteSdk(@Nullable Sdk sdk) {
        return sdk != null && sdk.getSdkType() instanceof RubySdkType && sdk.getSdkAdditionalData() instanceof RubyRemoteSdkAdditionalData;
    }

    public abstract boolean producesSshSdkCredentials(@NotNull Sdk var1);

    public abstract void updateGemsCopy(@NotNull Sdk var1, @Nullable Module var2, boolean var3);

    public abstract void updateHelpers(@NotNull Sdk var1);

    @NotNull
    public abstract RemoteCredentials getRemoteCredentials(@NotNull RemoteConnectionCredentialsWrapper var1, @Nullable Project var2, boolean var3) throws InterruptedException, ExecutionException;

    public abstract void produceRemoteCredentials(@NotNull RemoteConnectionCredentialsWrapper var1, @Nullable Project var2, boolean var3, @NotNull Consumer<RemoteCredentials> var4);

    @NotNull
    public abstract RubyRunner getRunner(@NotNull RubyRemoteSdkAdditionalData var1, @Nullable Module var2);

    @NotNull
    public abstract RubySdkSystemAccessor getRubySdkSystemAccessor(@NotNull RubyRemoteSdkAdditionalData var1);

    public abstract void fullyLoadCredentials(@NotNull RubyRemoteSdkAdditionalData var1);

    @NotNull
    public static RubyRemoteInterpreterManager getInstance() {
        RubyRemoteInterpreterManager rubyRemoteInterpreterManager = (RubyRemoteInterpreterManager)ApplicationManager.getApplication().getService(RubyRemoteInterpreterManager.class);
        if (rubyRemoteInterpreterManager == null) {
            RubyRemoteInterpreterManager.$$$reportNull$$$0(0);
        }
        return rubyRemoteInterpreterManager;
    }

    public static boolean isDownloading(@NotNull Sdk sdk) {
        if (sdk == null) {
            RubyRemoteInterpreterManager.$$$reportNull$$$0(1);
        }
        return sdk.getUserData(RUBY_REMOTE_SDK_TRANSFER_STATE_KEY) == Boolean.TRUE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/remote/RubyRemoteInterpreterManager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/remote/RubyRemoteInterpreterManager";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isDownloading";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

