/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rdoc.yard.references;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import java.util.Objects;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.codeInsight.references.RPsiPolyVariantReferenceBase;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.TypeSet;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Types;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactoryCore;

public class YARDReference
extends RPsiPolyVariantReferenceBase {
    @NotNull
    private final TextRange myRange;
    private final boolean myIsConstant;
    @NotNull
    private final Predicate<Symbol> myFilter;

    public YARDReference(@NotNull PsiElement element, @NotNull TextRange range, @NotNull RPsiElement container, boolean classModule) {
        if (element == null) {
            YARDReference.$$$reportNull$$$0(0);
        }
        if (range == null) {
            YARDReference.$$$reportNull$$$0(1);
        }
        if (container == null) {
            YARDReference.$$$reportNull$$$0(2);
        }
        super(element, container);
        this.myRange = range;
        this.myIsConstant = classModule;
        this.myFilter = Symbol.Filter.byTypes((TypeSet)(this.myIsConstant ? Types.MODULE_OR_CLASS : Types.EMPTY_CONTEXT_RESOLVE_TYPES));
    }

    @Override
    protected boolean isConstantReference() {
        return this.myIsConstant;
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        if (newElementName == null) {
            YARDReference.$$$reportNull$$$0(3);
        }
        String newElementText = this.myRange.replace(this.myElement.getText(), newElementName);
        RFile rubyFile = RubyElementFactoryCore.createRubyFile((Project)this.getProject(), (String)newElementText);
        return rubyFile == null ? this.myElement : this.myElement.replace(rubyFile.getFirstChild());
    }

    @Override
    protected String getName() {
        return this.myRange.substring(this.myElement.getText());
    }

    @Override
    @NotNull
    public TextRange getRangeInElement() {
        TextRange textRange = this.myRange;
        if (textRange == null) {
            YARDReference.$$$reportNull$$$0(4);
        }
        return textRange;
    }

    @Override
    @NotNull
    protected Predicate<Symbol> createFilter() {
        Predicate<Symbol> predicate = this.myFilter;
        if (predicate == null) {
            YARDReference.$$$reportNull$$$0(5);
        }
        return predicate;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        YARDReference reference = (YARDReference)o;
        return Objects.equals(this.myRange, reference.myRange) && Objects.equals(this.myFilter, reference.myFilter);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.myRange.hashCode();
        result = 31 * result + this.myFilter.hashCode();
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rdoc/yard/references/YARDReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rdoc/yard/references/YARDReference";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5 -> new IllegalStateException(string);
        };
    }
}

