/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rdoc.yard.references;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.IncorrectOperationException;
import java.util.Objects;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.references.RPsiPolyVariantReference;
import org.jetbrains.plugins.ruby.ruby.codeInsight.references.RQualifiedReference;
import org.jetbrains.plugins.ruby.ruby.codeInsight.references.RQualifiedReferenceBase;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.ResolveUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.TypeSet;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Types;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeFactory;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.impl.REmptyType;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactoryCore;

public class YARDQualifiedReference
extends RQualifiedReferenceBase {
    @Nullable
    private final RPsiPolyVariantReference myQualifierReference;
    @NotNull
    private final PsiElement myElement;
    @NotNull
    private final TextRange myRange;
    @NotNull
    private final Predicate<Symbol> myFilter;

    public YARDQualifiedReference(@NotNull PsiElement element, @Nullable RPsiPolyVariantReference qualifierReference, @NotNull String qualifier, @NotNull TextRange range, boolean classModuleOnly) {
        if (element == null) {
            YARDQualifiedReference.$$$reportNull$$$0(0);
        }
        if (qualifier == null) {
            YARDQualifiedReference.$$$reportNull$$$0(1);
        }
        if (range == null) {
            YARDQualifiedReference.$$$reportNull$$$0(2);
        }
        super(element.getProject(), qualifier, range.substring(element.getText()));
        this.myQualifierReference = qualifierReference;
        this.myElement = element;
        this.myRange = range;
        this.myFilter = classModuleOnly ? Symbol.Filter.byTypes((TypeSet)Types.MODULE_OR_CLASS) : RQualifiedReference.NAME_FILTER;
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        if (newElementName == null) {
            YARDQualifiedReference.$$$reportNull$$$0(3);
        }
        String newElementText = this.myRange.replace(this.myElement.getText(), newElementName);
        RFile rubyFile = RubyElementFactoryCore.createRubyFile((Project)this.getProject(), (String)newElementText);
        return rubyFile == null ? this.myElement : this.myElement.replace(rubyFile.getFirstChild());
    }

    @NotNull
    public TextRange getRangeInElement() {
        TextRange textRange = this.myRange;
        if (textRange == null) {
            YARDQualifiedReference.$$$reportNull$$$0(4);
        }
        return textRange;
    }

    @Override
    @NotNull
    protected Predicate<Symbol> createCompletionFilter(boolean getVariants) {
        Predicate<Symbol> predicate = this.myFilter;
        if (predicate == null) {
            YARDQualifiedReference.$$$reportNull$$$0(5);
        }
        return predicate;
    }

    @Override
    @NotNull
    public RType getRefObjectType() {
        Symbol symbol = ResolveUtil.resolveToSymbolWithCaching((PsiReference)this.myQualifierReference);
        if (symbol == null) {
            REmptyType rEmptyType = REmptyType.INSTANCE;
            if (rEmptyType == null) {
                YARDQualifiedReference.$$$reportNull$$$0(6);
            }
            return rEmptyType;
        }
        RType rType = RTypeFactory.createTypeBySymbol(symbol);
        if (rType == null) {
            YARDQualifiedReference.$$$reportNull$$$0(7);
        }
        return rType;
    }

    @NotNull
    public PsiElement getElement() {
        PsiElement psiElement = this.myElement;
        if (psiElement == null) {
            YARDQualifiedReference.$$$reportNull$$$0(8);
        }
        return psiElement;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.myQualifier + RubyTokenTypes.tCOLON2.toString() + this.myName;
        if (string == null) {
            YARDQualifiedReference.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        YARDQualifiedReference reference = (YARDQualifiedReference)o;
        return Objects.equals(this.myQualifierReference, reference.myQualifierReference) && Objects.equals(this.myElement, reference.myElement) && Objects.equals(this.myRange, reference.myRange) && Objects.equals(this.myFilter, reference.myFilter);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.myQualifierReference);
        result = 31 * result + this.myElement.hashCode();
        result = 31 * result + this.myRange.hashCode();
        result = 31 * result + this.myFilter.hashCode();
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rdoc/yard/references/YARDQualifiedReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rdoc/yard/references/YARDQualifiedReference";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createCompletionFilter";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRefObjectType";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7, 8, 9 -> new IllegalStateException(string);
        };
    }
}

