/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rdoc.yard.references;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactoryCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RArgument;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;

public class YARDParameterReference
extends PsiReferenceBase {
    private final List<RArgument> myArguments;
    private final String myName;

    public YARDParameterReference(PsiElement element, TextRange textRange, RMethod method) {
        super(element, textRange, true);
        this.myArguments = method.getArguments();
        this.myName = textRange.substring(element.getText());
    }

    public PsiElement resolve() {
        for (RArgument argument : this.myArguments) {
            if (!this.myName.equals(argument.getName())) continue;
            return argument.getIdentifier();
        }
        return null;
    }

    public Object @NotNull [] getVariants() {
        ArrayList<String> result = new ArrayList<String>();
        for (RArgument argument : this.myArguments) {
            result.add(argument.getName());
        }
        Object[] objectArray = ArrayUtil.toObjectArray(result);
        if (objectArray == null) {
            YARDParameterReference.$$$reportNull$$$0(0);
        }
        return objectArray;
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        if (newElementName == null) {
            YARDParameterReference.$$$reportNull$$$0(1);
        }
        String text = this.getElement().getText();
        TextRange range = this.getRangeInElement();
        String newElementText = text.substring(0, range.getStartOffset()) + newElementName + text.substring(range.getEndOffset());
        return this.myElement.replace(RubyElementFactoryCore.createRubyFile((Project)this.getElement().getProject(), (String)newElementText).getFirstChild());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rdoc/yard/references/YARDParameterReference";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rdoc/yard/references/YARDParameterReference";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

