/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rdoc.yard.model.psi.index;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.rdoc.yard.model.impl.YardMacroSymbol;
import org.jetbrains.plugins.ruby.rdoc.yard.model.psi.YardPsiSymbolDeclarationProvider;
import org.jetbrains.plugins.ruby.rdoc.yard.tags.YardMacroDirective;
import org.jetbrains.plugins.ruby.ruby.lang.RubyFileType;

public final class YardMacroNamesIndex
extends FileBasedIndexExtension<String, List<TextRange>> {
    public static final ID<String, List<TextRange>> KEY = ID.create((String)"yard.macro.names");

    public boolean dependsOnFileContent() {
        return true;
    }

    @NotNull
    public DataIndexer<String, List<TextRange>, FileContent> getIndexer() {
        return new DataIndexer<String, List<TextRange>, FileContent>(){

            @NotNull
            public Map<String, List<TextRange>> map(@NotNull FileContent inputData) {
                if (inputData == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!YardMacroDirective.containsMacroDirective((CharSequence)inputData.getContentAsText())) {
                    Map<String, List<TextRange>> map = Collections.emptyMap();
                    if (map == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return map;
                }
                final HashMap data = new HashMap();
                inputData.getPsiFile().accept((PsiElementVisitor)new PsiRecursiveElementVisitor(){

                    public void visitComment(@NotNull PsiComment comment) {
                        if (comment == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        YardPsiSymbolDeclarationProvider.getAllDeclarations((PsiElement)comment).forEach(declaration -> {
                            YardMacroSymbol symbol = (YardMacroSymbol)ObjectUtils.tryCast((Object)declaration.getSymbol(), YardMacroSymbol.class);
                            if (symbol != null) {
                                data.merge(symbol.getName(), List.of(declaration.getAbsoluteRange()), ContainerUtil::concat);
                            }
                        });
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comment", "org/jetbrains/plugins/ruby/rdoc/yard/model/psi/index/YardMacroNamesIndex$1$1", "visitComment"));
                    }
                });
                Map<String, List<TextRange>> map = Collections.unmodifiableMap(data);
                if (map == null) {
                    1.$$$reportNull$$$0(2);
                }
                return map;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "inputData";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/plugins/ruby/rdoc/yard/model/psi/index/YardMacroNamesIndex$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/plugins/ruby/rdoc/yard/model/psi/index/YardMacroNamesIndex$1";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "map";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "map";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1, 2 -> new IllegalStateException(string);
                };
            }
        };
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        return new DefaultFileTypeSpecificInputFilter(new FileType[]{RubyFileType.RUBY});
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
        if (enumeratorStringDescriptor == null) {
            YardMacroNamesIndex.$$$reportNull$$$0(0);
        }
        return enumeratorStringDescriptor;
    }

    @NotNull
    public ID<String, List<TextRange>> getName() {
        ID<String, List<TextRange>> iD = KEY;
        if (iD == null) {
            YardMacroNamesIndex.$$$reportNull$$$0(1);
        }
        return iD;
    }

    @NotNull
    public DataExternalizer<List<TextRange>> getValueExternalizer() {
        return new DataExternalizer<List<TextRange>>(){

            public void save(@NotNull DataOutput output2, @NotNull List<TextRange> value) throws IOException {
                if (output2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (value == null) {
                    2.$$$reportNull$$$0(1);
                }
                output2.writeInt(value.size());
                for (TextRange range : value) {
                    output2.writeInt(range.getStartOffset());
                    output2.writeInt(range.getEndOffset());
                }
            }

            @NotNull
            public List<TextRange> read(@NotNull DataInput input) throws IOException {
                if (input == null) {
                    2.$$$reportNull$$$0(2);
                }
                ArrayList<TextRange> ranges = new ArrayList<TextRange>();
                int size = input.readInt();
                for (int i = 0; i < size; ++i) {
                    ranges.add(new TextRange(input.readInt(), input.readInt()));
                }
                List<TextRange> list = Collections.unmodifiableList(ranges);
                if (list == null) {
                    2.$$$reportNull$$$0(3);
                }
                return list;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 3 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "output";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "value";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "input";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/plugins/ruby/rdoc/yard/model/psi/index/YardMacroNamesIndex$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/plugins/ruby/rdoc/yard/model/psi/index/YardMacroNamesIndex$2";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "read";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "save";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "read";
                        break;
                    }
                    case 3: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 3 -> new IllegalStateException(string);
                };
            }
        };
    }

    public int getVersion() {
        return 2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/plugins/ruby/rdoc/yard/model/psi/index/YardMacroNamesIndex";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyDescriptor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

