/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rdoc.yard.inspections;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import java.util.Optional;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.rdoc.yard.YARDUtil;
import org.jetbrains.plugins.ruby.rdoc.yard.tags.YARDReturnTag;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeWithNilability;
import org.jetbrains.plugins.ruby.ruby.inspections.RubyInspectionVisitor;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RSingletonMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.names.RName;

public final class MissingYardReturnTagInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            MissingYardReturnTagInspection.$$$reportNull$$$0(0);
        }
        Object object = !RubyPsiUtil.isRbiFile(holder.getFile()) ? new Visitor(holder) : PsiElementVisitor.EMPTY_VISITOR;
        if (object == null) {
            MissingYardReturnTagInspection.$$$reportNull$$$0(1);
        }
        return object;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rdoc/yard/inspections/MissingYardReturnTagInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rdoc/yard/inspections/MissingYardReturnTagInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    private static final class Visitor
    extends RubyInspectionVisitor {
        private Visitor(@NotNull ProblemsHolder holder) {
            if (holder == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super(holder);
        }

        public void visitRSingletonMethod(@NotNull RSingletonMethod method) {
            if (method == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            this.visitRMethod((RMethod)method);
        }

        public void visitRMethod(@NotNull RMethod method) {
            if (method == null) {
                Visitor.$$$reportNull$$$0(2);
            }
            if (ContainerUtil.exists((Iterable)method.getYARDTags(), it -> it instanceof YARDReturnTag)) {
                return;
            }
            RName methodName = method.getMethodName();
            if (methodName == null || methodName.getTextLength() == 0) {
                return;
            }
            this.myHolder.registerProblem((PsiElement)methodName, RBundle.message((String)"inspection.missing.yard.return.tag.method.not.annotated"), new LocalQuickFix[]{new AddYardReturnTagAnnotationQuickFix()});
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/ruby/rdoc/yard/inspections/MissingYardReturnTagInspection$Visitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRSingletonMethod";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRMethod";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class AddYardReturnTagAnnotationQuickFix
    implements LocalQuickFix {
        private AddYardReturnTagAnnotationQuickFix() {
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = RBundle.message((String)"inspection.missing.yard.return.tag.quickfix.name");
            if (string == null) {
                AddYardReturnTagAnnotationQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            RMethod method;
            if (project == null) {
                AddYardReturnTagAnnotationQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                AddYardReturnTagAnnotationQuickFix.$$$reportNull$$$0(2);
            }
            if ((method = RubyPsiUtil.getContainingRMethod(descriptor.getPsiElement())) == null) {
                return;
            }
            Document document = descriptor.getPsiElement().getContainingFile().getViewProvider().getDocument();
            if (document == null) {
                return;
            }
            RTypeWithNilability returnType = RTypeUtil.inferMethodTypeAndNilabilityByDoc(method, ThreeState.UNSURE);
            if (returnType.isEmpty()) {
                returnType = RTypeUtil.inferMethodTypeAndNilabilityByMethodBody(method);
            }
            String methodReturnType = YARDUtil.transformRTypeWithNilabilityToYardPresentableString(returnType);
            Template template = TemplateManager.getInstance((Project)project).createTemplate("", "");
            template.addTextSegment("# @return [");
            template.addVariable((Expression)new ConstantNode(methodReturnType), true);
            template.addTextSegment("]\n");
            int startOffset = method.getFirstChild().getTextOffset();
            Optional editorOptional = EditorFactory.getInstance().editors(document, project).findFirst();
            if (editorOptional.isPresent()) {
                Editor editor = (Editor)editorOptional.get();
                ApplicationManager.getApplication().runWriteAction(() -> {
                    editor.getCaretModel().moveToOffset(startOffset);
                    TemplateManager.getInstance((Project)project).startTemplate(editor, template);
                });
            } else {
                String templateText = template.getTemplateText();
                document.insertString(startOffset, (CharSequence)templateText);
                PsiDocumentManager.getInstance((Project)project).commitDocument(document);
                CodeStyleManager.getInstance((Project)project).reformatRange((PsiElement)method.getContainingFile(), startOffset, startOffset + templateText.length());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/rdoc/yard/inspections/MissingYardReturnTagInspection$AddYardReturnTagAnnotationQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/rdoc/yard/inspections/MissingYardReturnTagInspection$AddYardReturnTagAnnotationQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }
}

