/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rdoc.yard.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rdoc.RDocTokenTypes;
import org.jetbrains.plugins.ruby.rdoc.yard.YARDTag;
import org.jetbrains.plugins.ruby.rdoc.yard.YARDUtil;
import org.jetbrains.plugins.ruby.rdoc.yard.tags.YARDMethodDirective;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.RubyLookupElement;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.RubyTrackedCompletionProvider;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.lang.RubyLanguage;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RBodyStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RBlockArgumentList;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RAssignmentExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RConstantHolder;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyAttrCallTypeImpl;
import org.jetbrains.plugins.ruby.ruby.presentation.SymbolLookupUtil;

class YARDCompletionProvider
extends RubyTrackedCompletionProvider {
    static final YARDCompletionProvider INSTANCE = new YARDCompletionProvider();
    private static final int YARD_TAG_GROUPING = 10;
    private static final int YARD_DIRECTIVE_GROUPING = 0;

    private YARDCompletionProvider() {
        super((Language)RubyLanguage.INSTANCE);
    }

    @Override
    protected void addCompletionsTracked(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
        PsiElement element;
        if (parameters == null) {
            YARDCompletionProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            YARDCompletionProvider.$$$reportNull$$$0(1);
        }
        if (result == null) {
            YARDCompletionProvider.$$$reportNull$$$0(2);
        }
        if ((element = parameters.getOriginalPosition()) == null) {
            return;
        }
        int offset = parameters.getOffset() - element.getTextOffset();
        String text = element.getText();
        List<Pair<IElementType, TextRange>> lexerInfo = YARDUtil.getLexerInfo(text);
        int tokenIndexBeforeCaret = YARDUtil.findTokenIndexBeforeCaret(lexerInfo, offset);
        if (lexerInfo.stream().limit(tokenIndexBeforeCaret + 1).filter(it -> it.first == RDocTokenTypes.LBRACKET).count() == 1L && lexerInfo.stream().limit(tokenIndexBeforeCaret + 1).noneMatch(it -> it.first == RDocTokenTypes.RBRACKET)) {
            result.addElement((LookupElement)new RubyLookupElement("Boolean", null, null, false, SymbolLookupUtil.getLookupItemIcon(Type.CLASS, null), null));
        }
        if (tokenIndexBeforeCaret > 3 || tokenIndexBeforeCaret == 3 && lexerInfo.get((int)tokenIndexBeforeCaret).first == RDocTokenTypes.WHITESPACE) {
            return;
        }
        String originalPrefix = result.getPrefixMatcher().getPrefix();
        int prefixOffset = offset - originalPrefix.length();
        if (StringUtil.isChar((CharSequence)text, (int)(prefixOffset - 1), (char)'@')) {
            result = result.withPrefixMatcher(result.getPrefixMatcher().cloneWithPrefix("@" + originalPrefix));
        } else if (prefixOffset - 2 >= 0 && "@!".equals(text.substring(prefixOffset - 2, prefixOffset))) {
            result = result.withPrefixMatcher(result.getPrefixMatcher().cloneWithPrefix("@!" + originalPrefix));
        }
        RPsiElement containerForComment = YARDUtil.getContainerByYARDComment(element);
        YARDTag docContainerForComment = YARDUtil.getDocContainerByYARDComment(element);
        if (containerForComment instanceof RMethod || docContainerForComment != null) {
            if (containerForComment instanceof RMethod) {
                YARDCompletionProvider.addOverloadElement(result, containerForComment.getName());
            } else if (docContainerForComment instanceof YARDMethodDirective) {
                YARDCompletionProvider.addOverloadElement(result, ((YARDMethodDirective)docContainerForComment).getName());
            } else {
                YARDCompletionProvider.addOverloadElement(result, null);
            }
            YARDCompletionProvider.addAllElements(result, TokenSet.andNot((TokenSet)RDocTokenTypes.YARD_NOT_DEPRECATED_TAGS, (TokenSet)TokenSet.create((IElementType[])new IElementType[]{RDocTokenTypes.OVERLOAD})), 10);
        } else if (containerForComment instanceof RCall && ((RCall)containerForComment).getCallType() instanceof RubyAttrCallTypeImpl) {
            result.addElement(YARDCompletionProvider.createLookupElement(RDocTokenTypes.RETURN, 10));
        } else if (containerForComment instanceof RAssignmentExpression || containerForComment instanceof RBlockArgumentList) {
            result.addElement(YARDCompletionProvider.createLookupElement(RDocTokenTypes.TYPE_TAG, 10));
        }
        PsiElement parent = YARDCompletionProvider.getParentSkippingCompoundAndBody(element);
        if (parent instanceof RConstantHolder) {
            YARDCompletionProvider.addAllElements(result, RDocTokenTypes.YARD_DIRECTIVES, 0);
        }
    }

    @Nullable
    private static PsiElement getParentSkippingCompoundAndBody(@NotNull PsiElement element) {
        PsiElement parent;
        if (element == null) {
            YARDCompletionProvider.$$$reportNull$$$0(3);
        }
        if ((parent = element.getParent()) instanceof RCompoundStatement) {
            return YARDCompletionProvider.getParentSkippingCompoundAndBody(parent);
        }
        if (parent instanceof RBodyStatement) {
            return YARDCompletionProvider.getParentSkippingCompoundAndBody(parent);
        }
        return parent;
    }

    private static void addOverloadElement(@NotNull CompletionResultSet result, @Nullable String name) {
        if (result == null) {
            YARDCompletionProvider.$$$reportNull$$$0(4);
        }
        LookupElementBuilder element = LookupElementBuilder.create((String)RDocTokenTypes.OVERLOAD.toString()).withInsertHandler((context, item) -> {
            if (name == null) {
                return;
            }
            Editor editor = context.getEditor();
            editor.getDocument().insertString(context.getTailOffset(), (CharSequence)String.format(" %s()", name));
            editor.getCaretModel().moveToOffset(context.getTailOffset() - 1);
        });
        result.addElement(PrioritizedLookupElement.withGrouping((LookupElement)element, (int)10));
    }

    private static void addAllElements(@NotNull CompletionResultSet result, @NotNull TokenSet elements, int grouping) {
        if (result == null) {
            YARDCompletionProvider.$$$reportNull$$$0(5);
        }
        if (elements == null) {
            YARDCompletionProvider.$$$reportNull$$$0(6);
        }
        result.addAllElements((Iterable)ContainerUtil.map((Object[])elements.getTypes(), tag -> YARDCompletionProvider.createLookupElement(tag, grouping)));
    }

    @NotNull
    private static LookupElement createLookupElement(@NotNull IElementType tag, int grouping) {
        if (tag == null) {
            YARDCompletionProvider.$$$reportNull$$$0(7);
        }
        LookupElement lookupElement = PrioritizedLookupElement.withGrouping((LookupElement)LookupElementBuilder.create((String)tag.toString()), (int)grouping);
        if (lookupElement == null) {
            YARDCompletionProvider.$$$reportNull$$$0(8);
        }
        return lookupElement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rdoc/yard/completion/YARDCompletionProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rdoc/yard/completion/YARDCompletionProvider";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createLookupElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addCompletionsTracked";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getParentSkippingCompoundAndBody";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addOverloadElement";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addAllElements";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createLookupElement";
                break;
            }
            case 8: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8 -> new IllegalStateException(string);
        };
    }
}

