/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rdoc.yard;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rdoc.DocumentationMethodSymbol;
import org.jetbrains.plugins.ruby.rdoc.lexer.RDocLexer;
import org.jetbrains.plugins.ruby.rdoc.yard.YARDParser;
import org.jetbrains.plugins.ruby.rdoc.yard.YARDTag;
import org.jetbrains.plugins.ruby.rdoc.yard.psi.MethodNameFakePsiElement;
import org.jetbrains.plugins.ruby.rdoc.yard.psi.RangeInDocumentFakePsiElement;
import org.jetbrains.plugins.ruby.rdoc.yard.tags.YARDAttributeDirective;
import org.jetbrains.plugins.ruby.rdoc.yard.tags.YARDMethodDirective;
import org.jetbrains.plugins.ruby.rdoc.yard.tags.base.YARDSubMethodDirective;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeUtilCore;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeWithNilability;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.impl.RFrozenType;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RBodyStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RArgument;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RBlockArgumentList;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RAssignmentExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;

public final class YARDUtil {
    @Nullable
    public static RPsiElement getContainerByYARDComment(PsiElement element) {
        ASTNode node = element.getNode();
        if (node == null) {
            return null;
        }
        if (node.getElementType() != RubyTokenTypes.TLINE_COMMENT) {
            return null;
        }
        RPsiElement psiElement = (RPsiElement)PsiTreeUtil.getNextSiblingOfType((PsiElement)element, RPsiElement.class);
        if (psiElement instanceof RCompoundStatement || psiElement instanceof RBodyStatement) {
            List statements;
            List list = statements = psiElement instanceof RCompoundStatement ? ((RCompoundStatement)psiElement).getStatements() : ((RBodyStatement)psiElement).getCompoundStatement().getStatements();
            if (!statements.isEmpty()) {
                psiElement = (RPsiElement)statements.get(0);
            }
        }
        if (psiElement instanceof RMethod || psiElement instanceof RAssignmentExpression || psiElement instanceof RBlockArgumentList || psiElement instanceof RCall) {
            return psiElement;
        }
        return null;
    }

    @Nullable
    public static YARDTag getDocContainerByYARDComment(PsiElement element) {
        ASTNode node = element.getNode();
        if (node == null) {
            return null;
        }
        if (node.getElementType() != RubyTokenTypes.TLINE_COMMENT) {
            return null;
        }
        while (!(node instanceof RPsiElement)) {
            ASTNode treePrev = node.getTreePrev();
            if (treePrev == null) {
                return null;
            }
            if (treePrev.getElementType() == RubyTokenTypes.TLINE_COMMENT && treePrev.getText().contains("@!")) {
                PsiComment psiComment = (PsiComment)treePrev.getPsi();
                List tags = YARDParser.parse(Collections.singletonList(psiComment));
                for (YARDTag tag : tags) {
                    if (!(tag instanceof YARDMethodDirective) && !(tag instanceof YARDAttributeDirective)) continue;
                    return tag;
                }
                return null;
            }
            node = treePrev;
        }
        return null;
    }

    @Nullable
    public static YARDSubMethodDirective recreateTagByFakeMethodName(@NotNull MethodNameFakePsiElement element) {
        DocumentationMethodSymbol documentationMethod;
        if (element == null) {
            YARDUtil.$$$reportNull$$$0(0);
        }
        if ((documentationMethod = element.getDocumentationMethod()) != null && documentationMethod.getPsiElement() != null) {
            YARDTag tag = YARDUtil.recreateTagByFakeElement((RangeInDocumentFakePsiElement)documentationMethod.getPsiElement());
            return (YARDSubMethodDirective)ObjectUtils.tryCast((Object)tag, YARDSubMethodDirective.class);
        }
        return null;
    }

    @Nullable
    public static YARDTag recreateTagByFakeElement(@NotNull RangeInDocumentFakePsiElement element) {
        PsiFile file;
        if (element == null) {
            YARDUtil.$$$reportNull$$$0(1);
        }
        if ((file = element.getContainingFile()) == null) {
            return null;
        }
        PsiElement currentElement = file.findElementAt(element.getTextRange().getStartOffset());
        if (!(currentElement instanceof PsiComment)) {
            return null;
        }
        int endOffset = element.getTextRange().getEndOffset();
        ArrayList<PsiComment> comments = new ArrayList<PsiComment>();
        while (currentElement != null && currentElement.getTextRange().getEndOffset() <= endOffset) {
            if (currentElement instanceof PsiComment) {
                comments.add((PsiComment)currentElement);
            }
            currentElement = currentElement.getNextSibling();
        }
        List result = YARDParser.parse(comments);
        if (result.size() != 1) {
            return null;
        }
        return (YARDTag)result.iterator().next();
    }

    public static int findTokenIndexBeforeCaret(List<? extends Pair<IElementType, TextRange>> lexerInfo, int offset) {
        for (int i = 0; i < lexerInfo.size(); ++i) {
            Pair<IElementType, TextRange> pair = lexerInfo.get(i);
            if (((TextRange)pair.getSecond()).getEndOffset() < offset) continue;
            return i;
        }
        return lexerInfo.size() - 1;
    }

    public static List<Pair<IElementType, TextRange>> getLexerInfo(String text) {
        IElementType type;
        RDocLexer lexer = new RDocLexer(false, false);
        lexer.start((CharSequence)text);
        ArrayList<Pair<IElementType, TextRange>> result = new ArrayList<Pair<IElementType, TextRange>>();
        while ((type = lexer.getTokenType()) != null) {
            result.add((Pair<IElementType, TextRange>)Pair.create((Object)type, (Object)new TextRange(lexer.getTokenStart(), lexer.getTokenEnd())));
            lexer.advance();
        }
        return result;
    }

    @NotNull
    public static List<PsiComment> getCommentsWithoutYARD(@NotNull List<PsiComment> comments, @NotNull List<YARDTag> yardTags) {
        if (comments == null) {
            YARDUtil.$$$reportNull$$$0(2);
        }
        if (yardTags == null) {
            YARDUtil.$$$reportNull$$$0(3);
        }
        LinkedHashSet<PsiComment> set = new LinkedHashSet<PsiComment>(comments);
        for (YARDTag tag : yardTags) {
            PsiElement first;
            PsiElement tagPsiElement = tag.getPsiElement();
            if (!(tagPsiElement instanceof RangeInDocumentFakePsiElement)) continue;
            PsiElement parent = tagPsiElement.getParent();
            if (parent instanceof PsiComment) {
                set.remove(parent);
                continue;
            }
            PsiElement last = parent.findElementAt(tagPsiElement.getStartOffsetInParent() + tagPsiElement.getTextLength());
            if (first == null) continue;
            for (first = parent.findElementAt(tagPsiElement.getStartOffsetInParent()); first != last; first = first.getNextSibling()) {
                set.remove(first);
            }
            set.remove(last);
        }
        return new ArrayList<PsiComment>(set);
    }

    @NotNull
    public static String transformParameterTypeToYardPresentableString(@NotNull RArgument parameter) {
        String defaultValueType;
        if (parameter == null) {
            YARDUtil.$$$reportNull$$$0(4);
        }
        if (!(defaultValueType = Optional.of(parameter).filter(it -> it.getType().isOptional()).map(RArgument::getValue).map(RTypeWithNilability::fromPsiElement).filter(typeWithNullability -> !typeWithNullability.isEmpty()).map(YARDUtil::transformRTypeWithNilabilityToYardPresentableString).orElse("Object")).equals("Object")) {
            String string = defaultValueType;
            if (string == null) {
                YARDUtil.$$$reportNull$$$0(5);
            }
            return string;
        }
        String string = Optional.ofNullable(parameter.getIdentifier()).map(RTypeWithNilability::fromPsiElement).map(YARDUtil::transformRTypeWithNilabilityToYardPresentableString).orElse("Object");
        if (string == null) {
            YARDUtil.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public static String transformRTypeWithNilabilityToYardPresentableString(@NotNull RTypeWithNilability typeWithNullability) {
        if (typeWithNullability == null) {
            YARDUtil.$$$reportNull$$$0(7);
        }
        String typeOnly = YARDUtil.transformRTypeToYardPresentableString(typeWithNullability.getType());
        if (typeWithNullability.getCanBeNil() != ThreeState.YES) {
            String string = typeOnly;
            if (string == null) {
                YARDUtil.$$$reportNull$$$0(8);
            }
            return string;
        }
        Object object = RTypeUtilCore.isNullOrEmpty((RType)typeWithNullability.getType()) ? "nil" : typeOnly + ", nil";
        if (object == null) {
            YARDUtil.$$$reportNull$$$0(9);
        }
        return object;
    }

    @NotNull
    public static String transformRTypeToYardPresentableString(@NotNull RType type) {
        if (type == null) {
            YARDUtil.$$$reportNull$$$0(10);
        }
        if (RTypeUtilCore.isNullOrEmpty((RType)type)) {
            return "Object";
        }
        List presentableNames = ContainerUtil.map(RTypeUtil.flattenUnionAndIntersectionType(type), it -> RFrozenType.clearFrozenStatus(it).getPresentableName());
        return !presentableNames.isEmpty() ? String.join((CharSequence)", ", presentableNames) : "Object";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comments";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "yardTags";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rdoc/yard/YARDUtil";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeWithNullability";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rdoc/yard/YARDUtil";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "transformParameterTypeToYardPresentableString";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "transformRTypeWithNilabilityToYardPresentableString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "recreateTagByFakeMethodName";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "recreateTagByFakeElement";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getCommentsWithoutYARD";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "transformParameterTypeToYardPresentableString";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "transformRTypeWithNilabilityToYardPresentableString";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "transformRTypeToYardPresentableString";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 8, 9 -> new IllegalStateException(string);
        };
    }
}

