/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rdoc;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.rdoc.AccessType;
import org.jetbrains.plugins.ruby.rdoc.DocumentationMember;
import org.jetbrains.plugins.ruby.rdoc.DocumentationMethodImpl;
import org.jetbrains.plugins.ruby.rdoc.DocumentationSymbol;
import org.jetbrains.plugins.ruby.rdoc.yard.DocumentationSymbolProducer;
import org.jetbrains.plugins.ruby.rdoc.yard.YARDParser;
import org.jetbrains.plugins.ruby.rdoc.yard.YARDTag;
import org.jetbrains.plugins.ruby.rdoc.yard.psi.RangeInDocumentFakePsiElement;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.lang.documentation.CommentDescriptor;
import org.jetbrains.plugins.ruby.ruby.lang.documentation.RubyCommentsUtil;
import org.jetbrains.plugins.ruby.ruby.lang.documentation.RubyCommentsUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;

public final class RDocMembersUtil {
    private static final String METHOD = ":method:";
    private static final String SINGLETON_METHOD = ":singleton-method:";
    private static final String ATTR = ":attr:";
    private static final String ATTR_READER = ":attr_reader:";
    private static final String ATTR_WRITER = ":attr_writer:";
    private static final String ATTR_ACCESSOR = ":attr_accessor:";

    @NotNull
    public static Map<String, DocumentationSymbol<?>> collectDocumentationSymbols(@NotNull PsiElement container, @NotNull RCompoundStatement statement) {
        if (container == null) {
            RDocMembersUtil.$$$reportNull$$$0(0);
        }
        if (statement == null) {
            RDocMembersUtil.$$$reportNull$$$0(1);
        }
        LinkedHashSet result = new LinkedHashSet();
        for (CommentDescriptor commentDescriptor : RubyCommentsUtil.collectCommentDescriptorsFromStatement(statement)) {
            if (commentDescriptor.getAnchor() == null) {
                RDocMembersUtil.findRDocMembersInComments(result, commentDescriptor.getCommentLines());
            }
            if (commentDescriptor.getAnchor() instanceof RClass) continue;
            RDocMembersUtil.findYardMembersInComments(result, commentDescriptor.getCommentLines());
        }
        RDocMembersUtil.findYardMembersInComments(result, RubyCommentsUtilCore.getPsiComments((PsiElement)container));
        LinkedHashMap map = new LinkedHashMap();
        result.forEach(it -> map.put(it.getName(), (DocumentationSymbol<?>)it));
        LinkedHashMap linkedHashMap = map;
        if (linkedHashMap == null) {
            RDocMembersUtil.$$$reportNull$$$0(2);
        }
        return linkedHashMap;
    }

    private static void findYardMembersInComments(@NotNull Set<? super DocumentationSymbol> result, @NotNull List<? extends PsiComment> comments) {
        if (result == null) {
            RDocMembersUtil.$$$reportNull$$$0(3);
        }
        if (comments == null) {
            RDocMembersUtil.$$$reportNull$$$0(4);
        }
        List tagsFromComments = YARDParser.parse(comments);
        for (YARDTag tag : tagsFromComments) {
            if (!(tag instanceof DocumentationSymbolProducer)) continue;
            result.addAll(((DocumentationSymbolProducer)tag).createDocumentationSymbols());
        }
    }

    private static void findRDocMembersInComments(@NotNull Set<? super DocumentationSymbol> result, @NotNull Collection<? extends PsiComment> comments) {
        if (result == null) {
            RDocMembersUtil.$$$reportNull$$$0(5);
        }
        if (comments == null) {
            RDocMembersUtil.$$$reportNull$$$0(6);
        }
        for (PsiComment psiComment : comments) {
            String text = psiComment.getText().substring(1).trim();
            if (text.startsWith(METHOD)) {
                result.add((DocumentationSymbol)new DocumentationMethodImpl(RDocMembersUtil.getFakePsi(psiComment, METHOD), RDocMembersUtil.getRDocMemberName(text, METHOD), Type.INSTANCE_METHOD));
                continue;
            }
            if (text.startsWith(SINGLETON_METHOD)) {
                result.add((DocumentationSymbol)new DocumentationMethodImpl(RDocMembersUtil.getFakePsi(psiComment, SINGLETON_METHOD), RDocMembersUtil.getRDocMemberName(text, SINGLETON_METHOD), Type.CLASS_METHOD));
                continue;
            }
            if (text.startsWith(ATTR)) {
                result.add((DocumentationSymbol)new DocumentationMember(RDocMembersUtil.getFakePsi(psiComment, ATTR), RDocMembersUtil.getRDocMemberName(text, ATTR), Type.FIELD_READER, AccessType.READER));
                continue;
            }
            if (text.startsWith(ATTR_READER)) {
                result.add((DocumentationSymbol)new DocumentationMember(RDocMembersUtil.getFakePsi(psiComment, ATTR_READER), RDocMembersUtil.getRDocMemberName(text, ATTR_READER), Type.FIELD_READER, AccessType.READER));
                continue;
            }
            if (text.startsWith(ATTR_WRITER)) {
                result.add((DocumentationSymbol)new DocumentationMember(RDocMembersUtil.getFakePsi(psiComment, ATTR_WRITER), RDocMembersUtil.getRDocMemberName(text, ATTR_WRITER), Type.FIELD_WRITER, AccessType.WRITER));
                continue;
            }
            if (!text.startsWith(ATTR_ACCESSOR)) continue;
            result.add((DocumentationSymbol)new DocumentationMember(RDocMembersUtil.getFakePsi(psiComment, ATTR_ACCESSOR), RDocMembersUtil.getRDocMemberName(text, ATTR_ACCESSOR), Type.FIELD_READER, AccessType.ACCESSOR));
            result.add((DocumentationSymbol)new DocumentationMember(RDocMembersUtil.getFakePsi(psiComment, ATTR_ACCESSOR), RDocMembersUtil.getRDocMemberName(text, ATTR_ACCESSOR) + "=", Type.FIELD_WRITER, AccessType.ACCESSOR));
        }
    }

    @NotNull
    private static RangeInDocumentFakePsiElement getFakePsi(@NotNull PsiComment comment, String marker) {
        if (comment == null) {
            RDocMembersUtil.$$$reportNull$$$0(7);
        }
        String text = comment.getText();
        int offset = text.indexOf(marker) + marker.length() + 1;
        return new RangeInDocumentFakePsiElement((PsiElement)comment, TextRange.create((int)Math.min(offset, comment.getTextLength()), (int)comment.getTextLength()));
    }

    private static String getRDocMemberName(@NotNull String text, @NotNull String marker) {
        if (text == null) {
            RDocMembersUtil.$$$reportNull$$$0(8);
        }
        if (marker == null) {
            RDocMembersUtil.$$$reportNull$$$0(9);
        }
        return text.substring(marker.length()).trim();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rdoc/RDocMembersUtil";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comments";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "marker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rdoc/RDocMembersUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "collectDocumentationSymbols";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectDocumentationSymbols";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findYardMembersInComments";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findRDocMembersInComments";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getFakePsi";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getRDocMemberName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

