/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.testIntegration;

import com.intellij.navigation.ItemPresentation;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.testIntegration.TestCreator;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.bundler.actions.AbstractBundlerAction;
import org.jetbrains.plugins.ruby.gem.util.RubyProjectGemSearchService;
import org.jetbrains.plugins.ruby.rails.actions.generators.GeneratorsModuleCache;
import org.jetbrains.plugins.ruby.rails.actions.generators.GeneratorsOptionsPane;
import org.jetbrains.plugins.ruby.rails.actions.generators.actions.SimpleGeneratorAction;
import org.jetbrains.plugins.ruby.rails.codeInsight.symbols.v2.TestGenerator;
import org.jetbrains.plugins.ruby.rails.workspace.storage.ExtensionsKt;
import org.jetbrains.plugins.ruby.rails.workspace.storage.RailsGeneratorEntity;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.settings.RProjectUtil;

public final class RailsTestCreator
implements TestCreator,
ItemPresentation {
    public static final String NOTIFICATION_GROUP_ID = "Generate Rails test";
    private static final Logger LOG = Logger.getInstance(RailsTestCreator.class);

    public boolean isAvailable(Project project, Editor editor, PsiFile file) {
        Symbol symbol = RailsTestCreator.findScopeContextAtCaret(editor, file);
        return symbol instanceof TestGenerator && StringUtil.isNotEmpty((String)((TestGenerator)symbol).getShortName(file));
    }

    public void createTest(Project project, Editor editor, @NotNull PsiFile file) {
        Symbol symbol;
        if (file == null) {
            RailsTestCreator.$$$reportNull$$$0(0);
        }
        if (!((symbol = RailsTestCreator.findScopeContextAtCaret(editor, file)) instanceof TestGenerator)) {
            return;
        }
        Module module = symbol.getModule();
        String shortName = ((TestGenerator)symbol).getShortName(file);
        if (module == null || StringUtil.isEmpty((String)shortName)) {
            return;
        }
        RailsTestCreator.showPopup(module, (TestGenerator)symbol, shortName);
    }

    @Nullable
    public Icon getIcon(boolean unused) {
        return null;
    }

    @NotNull
    public String getPresentableText() {
        String string = RBundle.message((String)"rails.test.creator.name");
        if (string == null) {
            RailsTestCreator.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    private static Symbol findScopeContextAtCaret(@NotNull Editor editor, @NotNull PsiFile file) {
        PsiElement element;
        if (editor == null) {
            RailsTestCreator.$$$reportNull$$$0(2);
        }
        if (file == null) {
            RailsTestCreator.$$$reportNull$$$0(3);
        }
        if ((element = RailsTestCreator.findElementAtCaret(editor, file)) == null) {
            return null;
        }
        return SymbolUtil.getScopeContextWithCaching(element);
    }

    @Nullable
    private static PsiElement findElementAtCaret(@NotNull Editor editor, @NotNull PsiFile file) {
        int offset;
        PsiElement element;
        if (editor == null) {
            RailsTestCreator.$$$reportNull$$$0(4);
        }
        if (file == null) {
            RailsTestCreator.$$$reportNull$$$0(5);
        }
        if ((element = file.findElementAt(offset = editor.getCaretModel().getOffset())) != null) {
            return element;
        }
        return offset > 0 && offset == file.getTextLength() ? file.findElementAt(offset - 1) : null;
    }

    private static void showPopup(final @NotNull Module module, @NotNull TestGenerator testGenerator, final @NotNull String shortName) {
        if (module == null) {
            RailsTestCreator.$$$reportNull$$$0(6);
        }
        if (testGenerator == null) {
            RailsTestCreator.$$$reportNull$$$0(7);
        }
        if (shortName == null) {
            RailsTestCreator.$$$reportNull$$$0(8);
        }
        final Project project = module.getProject();
        final List generators = SequencesKt.toList(ExtensionsKt.getRailsGenerators(module));
        List generatorNames = ContainerUtil.map((Collection)generators, RailsGeneratorEntity::getName);
        final Map<String, String> nameToIds = testGenerator.getNameToIDs();
        final Map<String, String> nameToGems = testGenerator.getNameToGemsMap();
        final Map<String, Collection<String>> nameToOptions = testGenerator.getNameToOptionsMap();
        List availableNames = ContainerUtil.filter(nameToGems.keySet(), name -> generatorNames.contains(nameToIds.get(name)));
        final String generatorArgs = RailsTestCreator.getGeneratorArgs(module);
        BaseListPopupStep<String> generatorsPopupStep = new BaseListPopupStep<String>(RBundle.message((String)"tests.go.to.test.generate.tests.popup.title"), ContainerUtil.sorted((Collection)availableNames)){

            public PopupStep<?> onChosen(String generator, boolean finalChoice) {
                return this.doFinalStep(() -> {
                    String actualGeneratorName = (String)nameToIds.get(generator);
                    SimpleGeneratorAction generatorAction = this.findAction(actualGeneratorName);
                    String optionsString = String.join((CharSequence)" ", (Iterable)nameToOptions.get(generator));
                    Consumer generateTest = anAction -> anAction.invokeAction(shortName + generatorArgs + " " + optionsString, "development", module);
                    String gemName = (String)nameToGems.get(generator);
                    if (RubyProjectGemSearchService.Companion.findGem(module, gemName) == null) {
                        Runnable generateTestAction = () -> {
                            SimpleGeneratorAction action = this.findAction(actualGeneratorName);
                            if (action != null) {
                                ApplicationManager.getApplication().invokeLater(() -> generateTest.consume((Object)action));
                            } else {
                                GeneratorsModuleCache.getInstance(module).createGeneratorNotFoundNotification(actualGeneratorName).notify(project);
                                LOG.warn(actualGeneratorName + " generator isn't found along generators.");
                            }
                        };
                        RailsTestCreator.createGeneratorNotification(module, gemName, generateTestAction).notify(project);
                        return;
                    }
                    if (generatorAction != null) {
                        generateTest.consume((Object)generatorAction);
                        return;
                    }
                    LOG.warn("Despite the gem '" + gemName + "' available in the project the generator '" + generator + "' isn't found.");
                });
            }

            @Nullable
            private SimpleGeneratorAction findAction(@NotNull String selectedValue) {
                RailsGeneratorEntity generator;
                if (selectedValue == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((generator = (RailsGeneratorEntity)ContainerUtil.find((Iterable)generators, it -> it.getName().equals(selectedValue))) == null) {
                    return null;
                }
                return (SimpleGeneratorAction)((Object)ObjectUtils.tryCast((Object)ActionManager.getInstance().getAction(generator.getActionId()), SimpleGeneratorAction.class));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedValue", "org/jetbrains/plugins/ruby/rails/testIntegration/RailsTestCreator$1", "findAction"));
            }
        };
        Editor editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
        if (editor != null) {
            JBPopupFactory.getInstance().createListPopup((ListPopupStep)generatorsPopupStep).showInBestPositionFor(editor);
        }
    }

    @NotNull
    private static Notification createGeneratorNotification(@NotNull Module module, @NotNull String gemName, @NotNull Runnable generateTestAction) {
        if (module == null) {
            RailsTestCreator.$$$reportNull$$$0(9);
        }
        if (gemName == null) {
            RailsTestCreator.$$$reportNull$$$0(10);
        }
        if (generateTestAction == null) {
            RailsTestCreator.$$$reportNull$$$0(11);
        }
        Notification notification = new Notification(NOTIFICATION_GROUP_ID, RBundle.message((String)"tests.go.to.test.generate.tests.gem.not.found.title"), RBundle.message((String)"tests.go.to.test.generate.tests.gem.not.found", (Object[])new Object[]{gemName}), NotificationType.INFORMATION);
        BundleItAction bundleItAction = new BundleItAction(generateTestAction, gemName, module, notification);
        notification.addAction((AnAction)bundleItAction);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            bundleItAction.actionPerformed();
        }
        Notification notification2 = notification;
        if (notification2 == null) {
            RailsTestCreator.$$$reportNull$$$0(12);
        }
        return notification2;
    }

    @NotNull
    private static String getGeneratorArgs(@NotNull Module module) {
        if (module == null) {
            RailsTestCreator.$$$reportNull$$$0(13);
        }
        GeneratorsOptionsPane generatorsOptionsPane = new GeneratorsOptionsPane();
        generatorsOptionsPane.initPanel(RProjectUtil.getGeneratorsOptions(module.getProject()), module);
        String string = generatorsOptionsPane.getGeneratorArgs();
        if (string == null) {
            RailsTestCreator.$$$reportNull$$$0(14);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 12, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/testIntegration/RailsTestCreator";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 6: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testGenerator";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortName";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemName";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generateTestAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/testIntegration/RailsTestCreator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableText";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createGeneratorNotification";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getGeneratorArgs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createTest";
                break;
            }
            case 1: 
            case 12: 
            case 14: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findScopeContextAtCaret";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findElementAtCaret";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "showPopup";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createGeneratorNotification";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getGeneratorArgs";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 12, 14 -> new IllegalStateException(string);
        };
    }

    private static final class BundleItAction
    extends DumbAwareAction {
        @NotNull
        private final Runnable myGenerateTestAction;
        @NotNull
        @NlsSafe
        private final String myGemName;
        @NotNull
        private final Module myModule;
        @NotNull
        private final Notification myNotification;

        private BundleItAction(@NotNull Runnable generateTestAction, @NotNull String gemName, @NotNull Module module, @NotNull Notification notification) {
            if (generateTestAction == null) {
                BundleItAction.$$$reportNull$$$0(0);
            }
            if (gemName == null) {
                BundleItAction.$$$reportNull$$$0(1);
            }
            if (module == null) {
                BundleItAction.$$$reportNull$$$0(2);
            }
            if (notification == null) {
                BundleItAction.$$$reportNull$$$0(3);
            }
            super(RBundle.message((String)"tests.go.to.test.generate.tests.gem.not.found.action.bundle"));
            this.myGenerateTestAction = generateTestAction;
            this.myGemName = gemName;
            this.myModule = module;
            this.myNotification = notification;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                BundleItAction.$$$reportNull$$$0(4);
            }
            this.actionPerformed();
        }

        private void actionPerformed() {
            Runnable runnable = () -> {
                AnAction action = ActionManager.getInstance().getAction("org.jetbrains.plugins.ruby.gem.bundler.actions.RunBundlerInstallAction");
                if (!(action instanceof AbstractBundlerAction)) {
                    LOG.warn("Cannot find 'bundle install' action.");
                    return;
                }
                AbstractBundlerAction bundlerInstallAction = (AbstractBundlerAction)action;
                bundlerInstallAction.setPreFlightAction((Computable<Boolean>)((Computable)() -> GeneratorsModuleCache.appendGemToGemfile(this.myModule, this.myGemName)));
                bundlerInstallAction.setPostFlightAction(this.myGenerateTestAction);
                bundlerInstallAction.runBundlerAction(this.myModule);
                this.myNotification.expire();
            };
            CommandProcessor.getInstance().executeCommand(this.myModule.getProject(), runnable, RBundle.message((String)"rails.test.creator.bundle.install.command.name", (Object[])new Object[]{this.myGemName}), null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "generateTestAction";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "gemName";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "notification";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/ruby/rails/testIntegration/RailsTestCreator$BundleItAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

