/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.testIntegration;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.testIntegration.TestFinder;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.rails.model.RailsApp;
import org.jetbrains.plugins.ruby.rails.model.RailsController;
import org.jetbrains.plugins.ruby.rails.rspec.RailsRSpecUtil;
import org.jetbrains.plugins.ruby.testing.rspec.RSpecUtil;

public final class RailsRspecRequestTestFinder
implements TestFinder {
    public PsiElement findSourceElement(@NotNull PsiElement from) {
        if (from == null) {
            RailsRspecRequestTestFinder.$$$reportNull$$$0(0);
        }
        return from.getContainingFile();
    }

    @NotNull
    public Collection<PsiElement> findClassesForTest(@NotNull PsiElement element) {
        if (element == null) {
            RailsRspecRequestTestFinder.$$$reportNull$$$0(1);
        }
        Project project = element.getProject();
        RailsApp app = RailsApp.fromPsiElement(element);
        if (app == null) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                RailsRspecRequestTestFinder.$$$reportNull$$$0(2);
            }
            return list;
        }
        VirtualFile specRequestsRoot = app.getSpecTestsRequestsRoot();
        List<VirtualFile> controllersRoots = app.getPaths().findFiles("app/controllers");
        VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)element);
        if (specRequestsRoot == null || controllersRoots.isEmpty() || file == null || !VfsUtilCore.isAncestor((VirtualFile)specRequestsRoot, (VirtualFile)file, (boolean)false)) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                RailsRspecRequestTestFinder.$$$reportNull$$$0(3);
            }
            return list;
        }
        String name = "%s%s.rb".formatted(StringUtil.trimEnd((String)file.getName(), (String)"_spec.rb"), "_controller");
        VirtualFile controllerFile = RailsRSpecUtil.getMirroredFile(List.of(specRequestsRoot), controllersRoots, file, name);
        List list = ContainerUtil.createMaybeSingletonList((Object)((PsiElement)ObjectUtils.doIfNotNull((Object)controllerFile, arg_0 -> ((PsiManager)PsiManager.getInstance((Project)project)).findFile(arg_0))));
        if (list == null) {
            RailsRspecRequestTestFinder.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    public Collection<PsiElement> findTestsForClass(@NotNull PsiElement element) {
        if (element == null) {
            RailsRspecRequestTestFinder.$$$reportNull$$$0(5);
        }
        Project project = element.getProject();
        RailsController controller = (RailsController)ObjectUtils.doIfNotNull((Object)element.getContainingFile(), RailsController::fromFile);
        if (controller == null) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                RailsRspecRequestTestFinder.$$$reportNull$$$0(6);
            }
            return list;
        }
        VirtualFile routingSpec = controller.getRequestSpec();
        if (routingSpec == null) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                RailsRspecRequestTestFinder.$$$reportNull$$$0(7);
            }
            return list;
        }
        List list = ContainerUtil.createMaybeSingletonList((Object)PsiManager.getInstance((Project)project).findFile(routingSpec));
        if (list == null) {
            RailsRspecRequestTestFinder.$$$reportNull$$$0(8);
        }
        return list;
    }

    public boolean isTest(@NotNull PsiElement element) {
        if (element == null) {
            RailsRspecRequestTestFinder.$$$reportNull$$$0(9);
        }
        return RSpecUtil.isFileWithRSpecTestFileName(PsiUtilCore.getVirtualFile((PsiElement)element));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 6, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 1: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/testIntegration/RailsRspecRequestTestFinder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/testIntegration/RailsRspecRequestTestFinder";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findClassesForTest";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "findTestsForClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findSourceElement";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findClassesForTest";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findTestsForClass";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isTest";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 6, 7, 8 -> new IllegalStateException(string);
        };
    }
}

