/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.structure;

import com.intellij.icons.AllIcons;
import com.intellij.ide.util.FileStructureNodeProvider;
import com.intellij.ide.util.treeView.smartTree.ActionPresentation;
import com.intellij.ide.util.treeView.smartTree.ActionPresentationData;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.rails.model.ActiveRecordModel;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.assoc.RAssoc;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RBodyStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.visitors.RubyRecursiveElementVisitor;
import org.jetbrains.plugins.ruby.ruby.lang.structure.RubyStructureViewElement;

public class RailsModelValidationsNodeProvider
implements FileStructureNodeProvider<TreeElement> {
    public static final String ID = "SHOW_VALIDATIONS";
    public static final RailsModelValidationsNodeProvider INSTANCE = new RailsModelValidationsNodeProvider();
    private static final Set<String> VALIDATIONS = Set.of("validates", "validate", "validates!", "validates_each", "validates_with", "validates_absence_of", "validates_associated", "validates_length_of", "validates_numericality_of", "validates_presence_of", "validates_uniqueness_of");

    @NotNull
    public String getCheckBoxText() {
        String string = RBundle.message((String)"model.validations");
        if (string == null) {
            RailsModelValidationsNodeProvider.$$$reportNull$$$0(0);
        }
        return string;
    }

    public Shortcut @NotNull [] getShortcut() {
        if (Shortcut.EMPTY_ARRAY == null) {
            RailsModelValidationsNodeProvider.$$$reportNull$$$0(1);
        }
        return Shortcut.EMPTY_ARRAY;
    }

    @NotNull
    public Collection<TreeElement> provideNodes(@NotNull TreeElement node) {
        if (node == null) {
            RailsModelValidationsNodeProvider.$$$reportNull$$$0(2);
        }
        if (!(node instanceof RubyStructureViewElement)) {
            List<TreeElement> list = Collections.emptyList();
            if (list == null) {
                RailsModelValidationsNodeProvider.$$$reportNull$$$0(3);
            }
            return list;
        }
        RubyStructureViewElement rubyElement = (RubyStructureViewElement)node;
        ActiveRecordModel model = (ActiveRecordModel)ObjectUtils.doIfCast((Object)rubyElement.getValue(), RClass.class, ActiveRecordModel::fromClass);
        if (model == null) {
            List<TreeElement> list = Collections.emptyList();
            if (list == null) {
                RailsModelValidationsNodeProvider.$$$reportNull$$$0(4);
            }
            return list;
        }
        RClass modelClass = model.getRClass();
        final ArrayList validations = new ArrayList();
        modelClass.accept((PsiElementVisitor)new RubyRecursiveElementVisitor(){

            public void visitRCall(@NotNull RCall rCall) {
                if (rCall == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (RailsModelValidationsNodeProvider.isValidationCall(rCall)) {
                    validations.add(rCall);
                }
            }

            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(1);
                }
                ProgressManager.checkCanceled();
                if (element instanceof RBodyStatement || element instanceof RCompoundStatement || element instanceof RClass || element instanceof RBlockCall) {
                    element.acceptChildren((PsiElementVisitor)this);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "rCall";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/structure/RailsModelValidationsNodeProvider$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitRCall";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitElement";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        ArrayList<TreeElement> nodes = new ArrayList<TreeElement>();
        for (RCall validation : validations) {
            if (validation.getArguments().isEmpty()) continue;
            String attributes = String.join((CharSequence)", ", validation.getArguments().stream().filter(it -> !(it instanceof RAssoc)).map(PsiElement::getText).toList());
            nodes.add((TreeElement)new MyValidationStructureViewElement((RPsiElement)validation, validation.getCommand() + " " + attributes));
        }
        ArrayList<TreeElement> arrayList = nodes;
        if (arrayList == null) {
            RailsModelValidationsNodeProvider.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @NotNull
    public ActionPresentation getPresentation() {
        return new ActionPresentationData(RBundle.message((String)"show.model.validations"), null, AllIcons.Nodes.MethodReference);
    }

    @NotNull
    public String getName() {
        return ID;
    }

    private static boolean isValidationCall(@NotNull RCall call) {
        if (call == null) {
            RailsModelValidationsNodeProvider.$$$reportNull$$$0(6);
        }
        return VALIDATIONS.contains(call.getCommand());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/structure/RailsModelValidationsNodeProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCheckBoxText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortcut";
                break;
            }
            case 2: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/structure/RailsModelValidationsNodeProvider";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "provideNodes";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "provideNodes";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isValidationCall";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 6 -> new IllegalArgumentException(string);
        };
    }

    private static final class MyValidationStructureViewElement
    extends RubyStructureViewElement {
        @NotNull
        private final String myText;

        private MyValidationStructureViewElement(@Nullable RPsiElement element, @NotNull String text) {
            if (text == null) {
                MyValidationStructureViewElement.$$$reportNull$$$0(0);
            }
            super(element);
            this.myText = text;
        }

        @Override
        protected boolean canElementHaveChildren() {
            return false;
        }

        @Override
        @NotNull
        public ItemPresentation getPresentation() {
            return new ItemPresentation(){

                @NotNull
                public Icon getIcon(boolean unused) {
                    Icon icon = AllIcons.Nodes.MethodReference;
                    if (icon == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return icon;
                }

                @Nullable
                public String getLocationString() {
                    return null;
                }

                @NotNull
                public String getPresentableText() {
                    String string = myText;
                    if (string == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return string;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[2];
                    objectArray2[0] = "org/jetbrains/plugins/ruby/rails/structure/RailsModelValidationsNodeProvider$MyValidationStructureViewElement$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getIcon";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getPresentableText";
                            break;
                        }
                    }
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
                }
            };
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/plugins/ruby/rails/structure/RailsModelValidationsNodeProvider$MyValidationStructureViewElement", "<init>"));
        }
    }
}

