/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.structure;

import com.intellij.icons.AllIcons;
import com.intellij.ide.util.FileStructureNodeProvider;
import com.intellij.ide.util.treeView.smartTree.ActionPresentation;
import com.intellij.ide.util.treeView.smartTree.ActionPresentationData;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.rails.model.ActiveRecordModel;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.assoc.RAssoc;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RBodyStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBraceBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RDoBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.visitors.RubyRecursiveElementVisitor;
import org.jetbrains.plugins.ruby.ruby.lang.structure.RubyStructureViewElement;

public class RailsModelCallbacksNodeProvider
implements FileStructureNodeProvider<TreeElement> {
    public static final String ID = "SHOW_CALLBACKS";
    public static final RailsModelCallbacksNodeProvider INSTANCE = new RailsModelCallbacksNodeProvider();
    private static final Set<String> CALLBACKS = Set.of("after_initialize", "after_find", "after_touch", "before_validation", "after_validation", "before_save", "around_save", "after_save", "before_create", "around_create", "after_create", "before_update", "around_update", "after_update", "before_destroy", "around_destroy", "after_destroy", "after_commit", "after_rollback", "after_destroy_commit", "after_update_commit", "after_create_commit", "after_save_commit");

    @NotNull
    public String getCheckBoxText() {
        String string = RBundle.message((String)"model.callbacks");
        if (string == null) {
            RailsModelCallbacksNodeProvider.$$$reportNull$$$0(0);
        }
        return string;
    }

    public Shortcut @NotNull [] getShortcut() {
        if (Shortcut.EMPTY_ARRAY == null) {
            RailsModelCallbacksNodeProvider.$$$reportNull$$$0(1);
        }
        return Shortcut.EMPTY_ARRAY;
    }

    @NotNull
    public Collection<TreeElement> provideNodes(@NotNull TreeElement node) {
        if (node == null) {
            RailsModelCallbacksNodeProvider.$$$reportNull$$$0(2);
        }
        if (!(node instanceof RubyStructureViewElement)) {
            List<TreeElement> list = Collections.emptyList();
            if (list == null) {
                RailsModelCallbacksNodeProvider.$$$reportNull$$$0(3);
            }
            return list;
        }
        RubyStructureViewElement rubyElement = (RubyStructureViewElement)node;
        ActiveRecordModel model = (ActiveRecordModel)ObjectUtils.doIfCast((Object)rubyElement.getValue(), RClass.class, ActiveRecordModel::fromClass);
        if (model == null) {
            List<TreeElement> list = Collections.emptyList();
            if (list == null) {
                RailsModelCallbacksNodeProvider.$$$reportNull$$$0(4);
            }
            return list;
        }
        RClass modelClass = model.getRClass();
        final ArrayList callbacks = new ArrayList();
        modelClass.accept((PsiElementVisitor)new RubyRecursiveElementVisitor(){

            public void visitRBlockCall(@NotNull RBlockCall blockCall) {
                if (blockCall == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (RailsModelCallbacksNodeProvider.isCallbackCall((RPossibleCall)blockCall)) {
                    callbacks.add(blockCall);
                }
            }

            public void visitRCall(@NotNull RCall rCall) {
                if (rCall == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (RailsModelCallbacksNodeProvider.isCallbackCall((RPossibleCall)rCall)) {
                    callbacks.add(rCall);
                }
            }

            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(2);
                }
                ProgressManager.checkCanceled();
                if (element instanceof RBodyStatement || element instanceof RCompoundStatement || element instanceof RClass || element instanceof RBlockCall) {
                    element.acceptChildren((PsiElementVisitor)this);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "blockCall";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "rCall";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/structure/RailsModelCallbacksNodeProvider$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitRBlockCall";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitRCall";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitElement";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        ArrayList<TreeElement> nodes = new ArrayList<TreeElement>();
        for (RPossibleCall callback : callbacks) {
            if (callback.getCommand() == null) continue;
            if (callback instanceof RDoBlockCall) {
                nodes.add((TreeElement)new MyCallbackStructureViewElement((RPsiElement)callback, callback.getCommand()));
                continue;
            }
            if (!(callback instanceof RBraceBlockCall) && !(callback instanceof RCall)) continue;
            StringBuilder nodeText = new StringBuilder(callback.getCommand());
            if (!callback.getArguments().isEmpty()) {
                nodeText.append(" ");
                nodeText.append(callback.getArguments().stream().filter(it -> !(it instanceof RAssoc)).map(PsiElement::getText).collect(Collectors.joining(", ")));
            }
            if (callback instanceof RBraceBlockCall) {
                RBraceBlockCall blockCall = (RBraceBlockCall)callback;
                nodeText.append(" ");
                nodeText.append(blockCall.getBlock().getText());
            }
            nodes.add((TreeElement)new MyCallbackStructureViewElement((RPsiElement)callback, nodeText.toString()));
        }
        ArrayList<TreeElement> arrayList = nodes;
        if (arrayList == null) {
            RailsModelCallbacksNodeProvider.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @NotNull
    public ActionPresentation getPresentation() {
        return new ActionPresentationData(RBundle.message((String)"show.model.callbacks"), null, AllIcons.Nodes.MethodReference);
    }

    @NotNull
    public String getName() {
        return ID;
    }

    private static boolean isCallbackCall(@NotNull RPossibleCall call) {
        if (call == null) {
            RailsModelCallbacksNodeProvider.$$$reportNull$$$0(6);
        }
        return ContainerUtil.exists(CALLBACKS, callback -> call.getCommand() != null && call.getCommand().equals(callback));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/structure/RailsModelCallbacksNodeProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCheckBoxText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortcut";
                break;
            }
            case 2: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/structure/RailsModelCallbacksNodeProvider";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "provideNodes";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "provideNodes";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isCallbackCall";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 6 -> new IllegalArgumentException(string);
        };
    }

    private static final class MyCallbackStructureViewElement
    extends RubyStructureViewElement {
        @NotNull
        private final String myText;

        private MyCallbackStructureViewElement(@Nullable RPsiElement element, @NotNull String text) {
            if (text == null) {
                MyCallbackStructureViewElement.$$$reportNull$$$0(0);
            }
            super(element);
            this.myText = text;
        }

        @Override
        protected boolean canElementHaveChildren() {
            return false;
        }

        @Override
        @NotNull
        public ItemPresentation getPresentation() {
            return new ItemPresentation(){

                @NotNull
                public Icon getIcon(boolean unused) {
                    Icon icon = AllIcons.Nodes.MethodReference;
                    if (icon == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return icon;
                }

                @Nullable
                public String getLocationString() {
                    return null;
                }

                @NotNull
                public String getPresentableText() {
                    String string = myText;
                    if (string == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return string;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[2];
                    objectArray2[0] = "org/jetbrains/plugins/ruby/rails/structure/RailsModelCallbacksNodeProvider$MyCallbackStructureViewElement$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getIcon";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getPresentableText";
                            break;
                        }
                    }
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
                }
            };
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/plugins/ruby/rails/structure/RailsModelCallbacksNodeProvider$MyCallbackStructureViewElement", "<init>"));
        }
    }
}

