/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.structure;

import com.intellij.ide.util.FileStructureNodeProvider;
import com.intellij.ide.util.treeView.smartTree.ActionPresentation;
import com.intellij.ide.util.treeView.smartTree.ActionPresentationData;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.rails.RailsIcons;
import org.jetbrains.plugins.ruby.rails.database.MigrationField;
import org.jetbrains.plugins.ruby.rails.model.ActiveRecordModel;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.structure.RubyStructureViewElement;

public final class RailsDatabaseAttributesNodeProvider
implements FileStructureNodeProvider<TreeElement> {
    public static final String ID = "SHOW_MIGRATION_FIELDS";
    public static final RailsDatabaseAttributesNodeProvider INSTANCE = new RailsDatabaseAttributesNodeProvider();

    @NlsContexts.Checkbox
    @NotNull
    public String getCheckBoxText() {
        String string = RBundle.message((String)"migration.fields");
        if (string == null) {
            RailsDatabaseAttributesNodeProvider.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getName() {
        return ID;
    }

    @NotNull
    public ActionPresentation getPresentation() {
        return new ActionPresentationData(RBundle.message((String)"show.migration.fields"), null, RailsIcons.RAILS_MODEL_ATTRIBUTE_ICON);
    }

    public Shortcut @NotNull [] getShortcut() {
        if (Shortcut.EMPTY_ARRAY == null) {
            RailsDatabaseAttributesNodeProvider.$$$reportNull$$$0(1);
        }
        return Shortcut.EMPTY_ARRAY;
    }

    @NotNull
    public Collection<TreeElement> provideNodes(@NotNull TreeElement node) {
        if (node == null) {
            RailsDatabaseAttributesNodeProvider.$$$reportNull$$$0(2);
        }
        if (!(node instanceof RubyStructureViewElement)) {
            List<TreeElement> list = Collections.emptyList();
            if (list == null) {
                RailsDatabaseAttributesNodeProvider.$$$reportNull$$$0(3);
            }
            return list;
        }
        ActiveRecordModel model = (ActiveRecordModel)ObjectUtils.doIfCast((Object)((RubyStructureViewElement)node).getValue(), RClass.class, ActiveRecordModel::fromClass);
        if (model == null) {
            List<TreeElement> list = Collections.emptyList();
            if (list == null) {
                RailsDatabaseAttributesNodeProvider.$$$reportNull$$$0(4);
            }
            return list;
        }
        ArrayList<TreeElement> nodes = new ArrayList<TreeElement>();
        for (MigrationField field : (Collection)ObjectUtils.coalesce(model.getDBFields(), Collections.emptyList())) {
            PsiElement declaration = (PsiElement)ContainerUtil.getFirstItem(field.getDeclarations());
            String name = field.getName();
            if (!(declaration instanceof RPsiElement) || name == null) continue;
            nodes.add((TreeElement)new AttributeStructureViewElement((RPsiElement)declaration, name));
        }
        ArrayList<TreeElement> arrayList = nodes;
        if (arrayList == null) {
            RailsDatabaseAttributesNodeProvider.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/structure/RailsDatabaseAttributesNodeProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCheckBoxText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortcut";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/structure/RailsDatabaseAttributesNodeProvider";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "provideNodes";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "provideNodes";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2 -> new IllegalArgumentException(string);
        };
    }

    public static final class AttributeStructureViewElement
    extends RubyStructureViewElement {
        @Nls
        private final String myName;

        private AttributeStructureViewElement(@NotNull RPsiElement element, @NotNull @Nls String name) {
            if (element == null) {
                AttributeStructureViewElement.$$$reportNull$$$0(0);
            }
            if (name == null) {
                AttributeStructureViewElement.$$$reportNull$$$0(1);
            }
            super(element, false);
            this.myName = name;
        }

        @Override
        @NotNull
        public ItemPresentation getPresentation() {
            final String location = Optional.ofNullable(this.getOriginalElement()).map(NavigationItem::getPresentation).map(ItemPresentation::getLocationString).orElse(null);
            return new ItemPresentation(){

                @NotNull
                public Icon getIcon(boolean unused) {
                    Icon icon = RailsIcons.RAILS_MODEL_ATTRIBUTE_ICON;
                    if (icon == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return icon;
                }

                @Nullable
                public String getLocationString() {
                    return (String)ObjectUtils.doIfNotNull((Object)location, it -> UIUtil.upArrow((String)"^") + it);
                }

                @NotNull
                public String getPresentableText() {
                    String string = myName;
                    if (string == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return string;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[2];
                    objectArray2[0] = "org/jetbrains/plugins/ruby/rails/structure/RailsDatabaseAttributesNodeProvider$AttributeStructureViewElement$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getIcon";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getPresentableText";
                            break;
                        }
                    }
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
                }
            };
        }

        @Override
        protected boolean canElementHaveChildren() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/plugins/ruby/rails/structure/RailsDatabaseAttributesNodeProvider$AttributeStructureViewElement";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

