/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.settings.paths;

import com.intellij.application.options.ModuleAwareProjectConfigurable;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MasterDetailsComponent;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.ui.CommonActionsPanel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.rails.facet.RailsFacetUtil;
import org.jetbrains.plugins.ruby.rails.facet.configuration.RailsPaths;
import org.jetbrains.plugins.ruby.rails.facet.configuration.RailsPathsQuery;
import org.jetbrains.plugins.ruby.rails.settings.paths.RailsPathsConfigurable;
import org.jetbrains.plugins.ruby.rails.settings.paths.RailsPathsQueryModalTask;

public final class RailsPathsSettingsConfigurable
extends ModuleAwareProjectConfigurable<UnnamedConfigurable> {
    public RailsPathsSettingsConfigurable(@NotNull Project project) {
        if (project == null) {
            RailsPathsSettingsConfigurable.$$$reportNull$$$0(0);
        }
        super(project, RBundle.message((String)"rails.settings.paths.configurable.name"), null);
    }

    @NotNull
    protected UnnamedConfigurable createModuleConfigurable(@NotNull Module module) {
        if (module == null) {
            RailsPathsSettingsConfigurable.$$$reportNull$$$0(1);
        }
        return new MyModuleConfigurable(module);
    }

    protected boolean isSuitableForModule(@NotNull Module module) {
        if (module == null) {
            RailsPathsSettingsConfigurable.$$$reportNull$$$0(2);
        }
        return RailsFacetUtil.hasRailsSupport(module);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/rails/settings/paths/RailsPathsSettingsConfigurable";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createModuleConfigurable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isSuitableForModule";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class MyModuleConfigurable
    extends MasterDetailsComponent {
        private final Project myProject;
        private final Module myModule;
        private final JPanel myManagementPanel;
        private final JCheckBox myManagementCheckbox;
        private final String myRootUrl;

        private MyModuleConfigurable(@NotNull Module module) {
            if (module == null) {
                MyModuleConfigurable.$$$reportNull$$$0(0);
            }
            this.myManagementPanel = new JPanel(new FlowLayout(0));
            this.myManagementCheckbox = new JCheckBox(RBundle.message((String)"rails.settings.paths.configurable.panel.checkbox.managed.automatically.label"));
            this.myProject = module.getProject();
            this.myModule = module;
            this.myManagementPanel.add(this.myManagementCheckbox);
            this.myManagementCheckbox.setSelected(RailsPaths.getInstance(this.myModule).isManagedAutomatically());
            this.myManagementCheckbox.addActionListener(event -> {
                Iterator it = this.myRoot.children().asIterator();
                while (it.hasNext()) {
                    MasterDetailsComponent.MyNode node;
                    Object patt3650$temp;
                    Object patt3603$temp = it.next();
                    if (!(patt3603$temp instanceof MasterDetailsComponent.MyNode) || !((patt3650$temp = (node = (MasterDetailsComponent.MyNode)patt3603$temp).getUserObject()) instanceof RailsPathsConfigurable)) continue;
                    RailsPathsConfigurable configurable = (RailsPathsConfigurable)((Object)((Object)patt3650$temp));
                    this.ensureInitialized(configurable);
                    configurable.setManagedAutomatically(this.myManagementCheckbox.isSelected());
                }
            });
            this.myRootUrl = RailsFacetUtil.getRailsAppHomeDirUrl(module);
            JBSplitter splitter = (JBSplitter)this.getSplitter();
            splitter.setSplitterProportionKey(null);
            splitter.setProportion(0.3f);
            splitter.setAndLoadSplitterProportionKey(((Object)((Object)this)).getClass().getName() + ".splitter");
            this.initTree();
        }

        public void apply() throws ConfigurationException {
            super.apply();
            this.validate();
            RailsPaths.getInstance(this.myModule).setManagedAutomatically(this.myManagementCheckbox.isSelected());
            RailsPaths.getInstance(this.myModule).setUrls(this.getUrls());
        }

        @NotNull
        public String getDisplayName() {
            String string = RBundle.message((String)"rails.settings.paths.configurable.name");
            if (string == null) {
                MyModuleConfigurable.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean isModified() {
            return super.isModified() || this.myManagementCheckbox.isSelected() != RailsPaths.getInstance(this.myModule).isManagedAutomatically();
        }

        public void reset() {
            boolean isManagedAutomatically = RailsPaths.getInstance(this.myModule).isManagedAutomatically();
            this.myManagementCheckbox.setSelected(isManagedAutomatically);
            this.myRoot.removeAllChildren();
            for (Map.Entry<String, List<String>> entry : RailsPaths.getInstance(this.myModule).getUrls().entrySet()) {
                RailsPathsConfigurable configurable = new RailsPathsConfigurable(this.myProject, this.TREE_UPDATER, this.myRootUrl, entry.getKey(), entry.getValue(), isManagedAutomatically);
                this.addNode(new MasterDetailsComponent.MyNode((NamedConfigurable)configurable), this.myRoot);
            }
            super.reset();
        }

        @NotNull
        protected List<AnAction> createActions(boolean fromPopup) {
            List<AnAction> list = List.of(this.createAddAction(), this.createRemoveAction(), this.createImportFromRailsAction(), this.createRestoreDefaultsAction());
            if (list == null) {
                MyModuleConfigurable.$$$reportNull$$$0(2);
            }
            return list;
        }

        protected void initTree() {
            super.initTree();
            this.myTree.setCellRenderer((TreeCellRenderer)((Object)new MyColoredTreeCellRenderer()));
        }

        protected void reInitWholePanelIfNeeded() {
            if (!this.myToReInitWholePanel) {
                return;
            }
            super.reInitWholePanelIfNeeded();
            this.getMaster().setBorder(IdeBorderFactory.createBorder((int)11));
            this.myWholePanel.add((Component)this.myManagementPanel, "North");
        }

        @NotNull
        protected String getEmptySelectionString() {
            String string = RBundle.message((String)"rails.settings.paths.configurable.panel.empty.selection");
            if (string == null) {
                MyModuleConfigurable.$$$reportNull$$$0(3);
            }
            return string;
        }

        @NotNull
        private AnAction createAddAction() {
            return new AnAction(RBundle.messagePointer((String)"rails.settings.paths.configurable.panel.action.add"), AllIcons.General.Add){
                {
                    super(arg0, arg1);
                    this.registerCustomShortcutSet(CommonActionsPanel.getCommonShortcut((CommonActionsPanel.Buttons)CommonActionsPanel.Buttons.ADD), (JComponent)myTree);
                }

                public void actionPerformed(@NotNull AnActionEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (myManagementCheckbox.isSelected()) {
                        return;
                    }
                    RailsPathsConfigurable configurable = new RailsPathsConfigurable(myProject, TREE_UPDATER, myRootUrl, "", Collections.emptyList(), RailsPaths.getInstance(myModule).isManagedAutomatically());
                    configurable.setManagedAutomatically(false);
                    MasterDetailsComponent.MyNode node = new MasterDetailsComponent.MyNode((NamedConfigurable)configurable);
                    this.addNode(node, myRoot);
                    this.selectNodeInTree((DefaultMutableTreeNode)node);
                }

                @NotNull
                public ActionUpdateThread getActionUpdateThread() {
                    ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
                    if (actionUpdateThread == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return actionUpdateThread;
                }

                public void update(@NotNull AnActionEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    event.getPresentation().setEnabled(!myManagementCheckbox.isSelected());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n) {
                        default -> 3;
                        case 1 -> 2;
                    }];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "event";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "org/jetbrains/plugins/ruby/rails/settings/paths/RailsPathsSettingsConfigurable$MyModuleConfigurable$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "org/jetbrains/plugins/ruby/rails/settings/paths/RailsPathsSettingsConfigurable$MyModuleConfigurable$1";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getActionUpdateThread";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "actionPerformed";
                            break;
                        }
                        case 1: {
                            break;
                        }
                        case 2: {
                            objectArray = objectArray;
                            objectArray[2] = "update";
                            break;
                        }
                    }
                    String string = String.format(v0, objectArray);
                    throw switch (n) {
                        default -> new IllegalArgumentException(string);
                        case 1 -> new IllegalStateException(string);
                    };
                }
            };
        }

        @NotNull
        private AnAction createImportFromRailsAction() {
            return new AnAction(RBundle.messagePointer((String)"rails.settings.paths.configurable.panel.action.import.from.rails"), AllIcons.ToolbarDecorator.Import){

                public void actionPerformed(@NotNull AnActionEvent event) {
                    if (event == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    ProgressManager.getInstance().run((Task)new RailsPathsQueryModalTask(myProject, myModule, myWholePanel){

                        @Override
                        void onSuccess(@NotNull Map<String, List<String>> urls) {
                            if (urls == null) {
                                MyModuleConfigurable.1.$$$reportNull$$$0(0);
                            }
                            this.recreateNodes(urls);
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "urls", "org/jetbrains/plugins/ruby/rails/settings/paths/RailsPathsSettingsConfigurable$MyModuleConfigurable$2$1", "onSuccess"));
                        }
                    });
                }

                @NotNull
                public ActionUpdateThread getActionUpdateThread() {
                    ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
                    if (actionUpdateThread == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    return actionUpdateThread;
                }

                public void update(@NotNull AnActionEvent event) {
                    if (event == null) {
                        2.$$$reportNull$$$0(2);
                    }
                    event.getPresentation().setEnabled(RailsPathsQuery.isAvailable(myModule));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n) {
                        default -> 3;
                        case 1 -> 2;
                    }];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "event";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "org/jetbrains/plugins/ruby/rails/settings/paths/RailsPathsSettingsConfigurable$MyModuleConfigurable$2";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "org/jetbrains/plugins/ruby/rails/settings/paths/RailsPathsSettingsConfigurable$MyModuleConfigurable$2";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getActionUpdateThread";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "actionPerformed";
                            break;
                        }
                        case 1: {
                            break;
                        }
                        case 2: {
                            objectArray = objectArray;
                            objectArray[2] = "update";
                            break;
                        }
                    }
                    String string = String.format(v0, objectArray);
                    throw switch (n) {
                        default -> new IllegalArgumentException(string);
                        case 1 -> new IllegalStateException(string);
                    };
                }
            };
        }

        @NotNull
        private AnAction createRemoveAction() {
            return new AnAction(RBundle.messagePointer((String)"rails.settings.paths.configurable.panel.action.remove"), AllIcons.General.Remove){
                {
                    super(arg0, arg1);
                    this.registerCustomShortcutSet(CommonActionsPanel.getCommonShortcut((CommonActionsPanel.Buttons)CommonActionsPanel.Buttons.REMOVE), (JComponent)myTree);
                }

                public void actionPerformed(@NotNull AnActionEvent event) {
                    if (event == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    if (myManagementCheckbox.isSelected()) {
                        return;
                    }
                    Object[] paths = myTree.getSelectionPaths();
                    if (paths != null) {
                        this.removeNodes(ContainerUtil.mapNotNull((Object[])paths, it -> (MasterDetailsComponent.MyNode)ObjectUtils.tryCast((Object)it.getLastPathComponent(), MasterDetailsComponent.MyNode.class)));
                    }
                }

                @NotNull
                public ActionUpdateThread getActionUpdateThread() {
                    ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
                    if (actionUpdateThread == null) {
                        3.$$$reportNull$$$0(1);
                    }
                    return actionUpdateThread;
                }

                public void update(@NotNull AnActionEvent event) {
                    if (event == null) {
                        3.$$$reportNull$$$0(2);
                    }
                    event.getPresentation().setEnabled(!myManagementCheckbox.isSelected() && myTree.getSelectionPaths() != null);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n) {
                        default -> 3;
                        case 1 -> 2;
                    }];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "event";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "org/jetbrains/plugins/ruby/rails/settings/paths/RailsPathsSettingsConfigurable$MyModuleConfigurable$3";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "org/jetbrains/plugins/ruby/rails/settings/paths/RailsPathsSettingsConfigurable$MyModuleConfigurable$3";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getActionUpdateThread";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "actionPerformed";
                            break;
                        }
                        case 1: {
                            break;
                        }
                        case 2: {
                            objectArray = objectArray;
                            objectArray[2] = "update";
                            break;
                        }
                    }
                    String string = String.format(v0, objectArray);
                    throw switch (n) {
                        default -> new IllegalArgumentException(string);
                        case 1 -> new IllegalStateException(string);
                    };
                }
            };
        }

        @NotNull
        private AnAction createRestoreDefaultsAction() {
            return new AnAction(RBundle.messagePointer((String)"rails.settings.paths.configurable.panel.action.restore.defaults"), AllIcons.Actions.Rollback){

                public void actionPerformed(@NotNull AnActionEvent event) {
                    if (event == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    if (myManagementCheckbox.isSelected()) {
                        return;
                    }
                    this.recreateNodes(RailsPaths.getDefaultUrls(myModule));
                }

                @NotNull
                public ActionUpdateThread getActionUpdateThread() {
                    ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
                    if (actionUpdateThread == null) {
                        4.$$$reportNull$$$0(1);
                    }
                    return actionUpdateThread;
                }

                public void update(@NotNull AnActionEvent event) {
                    if (event == null) {
                        4.$$$reportNull$$$0(2);
                    }
                    event.getPresentation().setEnabled(!myManagementCheckbox.isSelected());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n) {
                        default -> 3;
                        case 1 -> 2;
                    }];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "event";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "org/jetbrains/plugins/ruby/rails/settings/paths/RailsPathsSettingsConfigurable$MyModuleConfigurable$4";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "org/jetbrains/plugins/ruby/rails/settings/paths/RailsPathsSettingsConfigurable$MyModuleConfigurable$4";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getActionUpdateThread";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "actionPerformed";
                            break;
                        }
                        case 1: {
                            break;
                        }
                        case 2: {
                            objectArray = objectArray;
                            objectArray[2] = "update";
                            break;
                        }
                    }
                    String string = String.format(v0, objectArray);
                    throw switch (n) {
                        default -> new IllegalArgumentException(string);
                        case 1 -> new IllegalStateException(string);
                    };
                }
            };
        }

        @NotNull
        private Map<String, List<String>> getUrls() {
            TreeMap urls = new TreeMap();
            Enumeration children = this.myRoot.children();
            while (children.hasMoreElements()) {
                MasterDetailsComponent.MyNode node;
                NamedConfigurable namedConfigurable;
                Object e = children.nextElement();
                if (!(e instanceof MasterDetailsComponent.MyNode) || !((namedConfigurable = (node = (MasterDetailsComponent.MyNode)e).getConfigurable()) instanceof RailsPathsConfigurable)) continue;
                RailsPathsConfigurable configurable = (RailsPathsConfigurable)namedConfigurable;
                urls.put(configurable.getDisplayName(), List.copyOf(configurable.getEditableObject()));
            }
            Map<String, List<String>> map = Collections.unmodifiableMap(urls);
            if (map == null) {
                MyModuleConfigurable.$$$reportNull$$$0(4);
            }
            return map;
        }

        private void recreateNodes(@NotNull Map<String, List<String>> urls) {
            if (urls == null) {
                MyModuleConfigurable.$$$reportNull$$$0(5);
            }
            TreeMap<String, List<String>> mutableUrls = new TreeMap<String, List<String>>(urls);
            Enumeration children = this.myRoot.children();
            ArrayList<MasterDetailsComponent.MyNode> toRemove = new ArrayList<MasterDetailsComponent.MyNode>();
            while (children.hasMoreElements()) {
                MasterDetailsComponent.MyNode node;
                NamedConfigurable namedConfigurable;
                Object e = children.nextElement();
                if (!(e instanceof MasterDetailsComponent.MyNode) || !((namedConfigurable = (node = (MasterDetailsComponent.MyNode)e).getConfigurable()) instanceof RailsPathsConfigurable)) continue;
                RailsPathsConfigurable configurable = (RailsPathsConfigurable)namedConfigurable;
                this.ensureInitialized(configurable);
                List defaultUrls = (List)ObjectUtils.coalesce((Object)((List)mutableUrls.remove(configurable.getDisplayName())), Collections.emptyList());
                if (defaultUrls.isEmpty()) {
                    toRemove.add(node);
                    continue;
                }
                configurable.setUrls(defaultUrls);
            }
            this.removeNodes(toRemove);
            for (Map.Entry entry : mutableUrls.entrySet()) {
                RailsPathsConfigurable configurable = new RailsPathsConfigurable(this.myProject, this.TREE_UPDATER, this.myRootUrl, "", Collections.emptyList(), RailsPaths.getInstance(this.myModule).isManagedAutomatically());
                this.ensureInitialized(configurable);
                configurable.setDisplayName((String)entry.getKey());
                configurable.setUrls((List)entry.getValue());
                configurable.setManagedAutomatically(this.myManagementCheckbox.isSelected());
                this.addNode(new MasterDetailsComponent.MyNode((NamedConfigurable)configurable), this.myRoot);
            }
            ((DefaultTreeModel)this.myTree.getModel()).reload((TreeNode)this.myRoot);
            if (this.myRoot.children().hasMoreElements()) {
                this.myTree.addSelectionRow(0);
            }
        }

        private void validate() throws ConfigurationException {
            for (MasterDetailsComponent.MyNode node : TreeUtil.treeNodeTraverser((TreeNode)this.myRoot).filter(MasterDetailsComponent.MyNode.class)) {
                RailsPathsConfigurable configurable;
                NamedConfigurable namedConfigurable = node.getConfigurable();
                if (!(namedConfigurable instanceof RailsPathsConfigurable) || !this.isInitialized(configurable = (RailsPathsConfigurable)namedConfigurable) || !configurable.isModified()) continue;
                configurable.validate();
            }
            HashSet<String> keys = new HashSet<String>();
            for (MasterDetailsComponent.MyNode node : TreeUtil.treeNodeTraverser((TreeNode)this.myRoot).filter(MasterDetailsComponent.MyNode.class)) {
                NamedConfigurable configurable = node.getConfigurable();
                String name = configurable.getDisplayName();
                if (keys.add(name)) continue;
                ConfigurationException exception = new ConfigurationException(RBundle.message((String)"rails.settings.paths.configurable.panel.error.duplicate.path.name", (Object[])new Object[]{name}));
                exception.setOriginator((Configurable)configurable);
                throw exception;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/rails/settings/paths/RailsPathsSettingsConfigurable$MyModuleConfigurable";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "urls";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/rails/settings/paths/RailsPathsSettingsConfigurable$MyModuleConfigurable";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDisplayName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createActions";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEmptySelectionString";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUrls";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "recreateNodes";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 3, 4 -> new IllegalStateException(string);
            };
        }
    }

    private static final class MyColoredTreeCellRenderer
    extends MasterDetailsComponent.MyColoredTreeCellRenderer {
        private static final Color MODIFIED_ITEM_FOREGROUND = JBColor.namedColor((String)"ComboBox.modifiedItemForeground", (Color)JBColor.BLUE);

        private MyColoredTreeCellRenderer() {
        }

        @NotNull
        protected SimpleTextAttributes getAdditionalAttributes(@NotNull MasterDetailsComponent.MyNode node) {
            if (node == null) {
                MyColoredTreeCellRenderer.$$$reportNull$$$0(0);
            }
            if (!node.getConfigurable().isModified()) {
                SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
                if (simpleTextAttributes == null) {
                    MyColoredTreeCellRenderer.$$$reportNull$$$0(1);
                }
                return simpleTextAttributes;
            }
            SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES.derive(-1, MODIFIED_ITEM_FOREGROUND, null, null);
            if (simpleTextAttributes == null) {
                MyColoredTreeCellRenderer.$$$reportNull$$$0(2);
            }
            return simpleTextAttributes;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/rails/settings/paths/RailsPathsSettingsConfigurable$MyColoredTreeCellRenderer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/rails/settings/paths/RailsPathsSettingsConfigurable$MyColoredTreeCellRenderer";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAdditionalAttributes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getAdditionalAttributes";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }
}

