/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.settings.paths;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionToolbarPosition;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SortedListModel;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import com.intellij.util.IconUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;

final class RailsPathsConfigurable
extends NamedConfigurable<List<String>> {
    private final Project myProject;
    private final Runnable myTreeUpdater;
    @Nullable
    private final String myRootUrl;
    private final Map<String, Icon> myUrlIcons;
    @Nullable
    private JPanel myPanel;
    @Nullable
    private JBList<String> myList;
    @Nullable
    private SortedListModel<String> myListModel;
    @Nls
    private String myInitialName;
    private List<String> myInitialUrls;
    private boolean myInitialIsManagedAutomatically;
    @Nls
    private String myName;
    private List<String> myUrls;
    private boolean myIsManagedAutomatically;

    RailsPathsConfigurable(@NotNull Project project, @NotNull Runnable treeUpdater, @Nullable String rootUrl, @Nls @NotNull String name, @NotNull List<String> initialUrls, boolean isManagedAutomatically) {
        if (project == null) {
            RailsPathsConfigurable.$$$reportNull$$$0(0);
        }
        if (treeUpdater == null) {
            RailsPathsConfigurable.$$$reportNull$$$0(1);
        }
        if (name == null) {
            RailsPathsConfigurable.$$$reportNull$$$0(2);
        }
        if (initialUrls == null) {
            RailsPathsConfigurable.$$$reportNull$$$0(3);
        }
        super(true, treeUpdater);
        this.myUrlIcons = new ConcurrentHashMap<String, Icon>();
        this.myPanel = null;
        this.myList = null;
        this.myListModel = null;
        this.myProject = project;
        this.myTreeUpdater = treeUpdater;
        this.myRootUrl = rootUrl;
        this.myInitialName = name;
        this.myInitialUrls = List.copyOf(initialUrls);
        this.myInitialIsManagedAutomatically = isManagedAutomatically;
        this.myName = name;
        this.myUrls = new ArrayList<String>(initialUrls);
        this.myIsManagedAutomatically = isManagedAutomatically;
        this.computeUrlIcons();
        this.setNameFieldShown(!isManagedAutomatically);
    }

    public void apply() {
        this.myInitialName = this.myName;
        this.myInitialUrls = List.copyOf(this.myUrls);
        this.myInitialIsManagedAutomatically = this.myIsManagedAutomatically;
    }

    @NotNull
    public JComponent createOptionsPanel() {
        if (this.myPanel == null) {
            this.myListModel = new SortedListModel(Comparator.naturalOrder());
            this.myListModel.addAll(this.myUrls);
            this.myList = new JBList(this.myListModel);
            this.myList.setCellRenderer((ListCellRenderer)new ColoredListCellRenderer<String>(){

                protected void customizeCellRenderer(@NotNull JList<? extends String> list, @Nullable String url, int index, boolean selected, boolean hasFocus) {
                    if (list == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (url == null) {
                        return;
                    }
                    Icon icon = RailsPathsConfigurable.this.myUrlIcons.computeIfAbsent(url, __ -> {
                        VirtualFile file = VirtualFileManager.getInstance().findFileByUrl(url);
                        return file != null ? IconUtil.getIcon((VirtualFile)file, (int)2, (Project)RailsPathsConfigurable.this.myProject) : AllIcons.FileTypes.Unknown;
                    });
                    this.setIcon(icon);
                    String path = RailsPathsConfigurable.this.myRootUrl != null ? FileUtil.getRelativePath((String)RailsPathsConfigurable.this.myRootUrl, (String)url, (char)'/') : null;
                    this.append(FileUtil.toSystemDependentName((String)((String)ObjectUtils.coalesce((Object)path, (Object)VfsUtilCore.urlToPath((String)url)))));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "org/jetbrains/plugins/ruby/rails/settings/paths/RailsPathsConfigurable$1", "customizeCellRenderer"));
                }
            });
            this.myPanel = ToolbarDecorator.createDecorator(this.myList).setToolbarPosition(ActionToolbarPosition.TOP).setAddAction(this.createAddAction()).setAddActionUpdater(event -> !this.myIsManagedAutomatically).setRemoveAction(this.createRemoveAction()).setRemoveActionUpdater(event -> !this.myIsManagedAutomatically && this.myList != null && !this.myList.getSelectedValuesList().isEmpty()).disableUpDownActions().createPanel();
            this.myPanel.setBorder(BorderFactory.createCompoundBorder((Border)JBUI.Borders.empty((int)0, (int)8), this.myPanel.getBorder()));
        }
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            RailsPathsConfigurable.$$$reportNull$$$0(4);
        }
        return jPanel;
    }

    @NotNull
    public String getBannerSlogan() {
        String string = this.myName;
        if (string == null) {
            RailsPathsConfigurable.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = this.myName;
        if (string == null) {
            RailsPathsConfigurable.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public List<String> getEditableObject() {
        List<String> list = Collections.unmodifiableList(this.myUrls);
        if (list == null) {
            RailsPathsConfigurable.$$$reportNull$$$0(7);
        }
        return list;
    }

    @NotNull
    public Icon getIcon(boolean expanded) {
        for (String url : this.myUrls) {
            Icon icon = this.myUrlIcons.get(url);
            if (icon == null || icon == AllIcons.FileTypes.Unknown) continue;
            Icon icon2 = icon;
            if (icon2 == null) {
                RailsPathsConfigurable.$$$reportNull$$$0(8);
            }
            return icon2;
        }
        Icon icon = AllIcons.FileTypes.Unknown;
        if (icon == null) {
            RailsPathsConfigurable.$$$reportNull$$$0(9);
        }
        return icon;
    }

    public boolean isModified() {
        return this.myInitialName.isBlank() || !this.myName.equals(this.myInitialName) || !this.myUrls.equals(this.myInitialUrls);
    }

    public void reset() {
        this.myName = this.myInitialName;
        this.myUrls = new ArrayList<String>(this.myInitialUrls);
        this.myIsManagedAutomatically = this.myInitialIsManagedAutomatically;
        if (this.myListModel != null) {
            this.myListModel.clear();
            this.myListModel.addAll(this.myInitialUrls);
        }
        this.computeUrlIcons();
        this.setNameFieldShown(!this.myIsManagedAutomatically);
    }

    public void setDisplayName(@NotNull String name) {
        if (name == null) {
            RailsPathsConfigurable.$$$reportNull$$$0(10);
        }
        this.myName = name;
    }

    public void setManagedAutomatically(boolean isManagedAutomatically) {
        this.myIsManagedAutomatically = isManagedAutomatically;
        this.setNameFieldShown(!isManagedAutomatically);
    }

    public void setUrls(@NotNull List<String> urls) {
        if (urls == null) {
            RailsPathsConfigurable.$$$reportNull$$$0(11);
        }
        this.myUrls = new ArrayList<String>(urls);
        if (this.myListModel != null) {
            this.myListModel.clear();
            this.myListModel.addAll(urls);
        }
        this.computeUrlIcons();
    }

    public void validate() throws ConfigurationException {
        if (this.myName.isBlank()) {
            ConfigurationException exception = new ConfigurationException(RBundle.message((String)"rails.settings.paths.configurable.panel.error.blank.path.name"));
            exception.setOriginator((Configurable)this);
            throw exception;
        }
    }

    @NotNull
    private AnActionButtonRunnable createAddAction() {
        return new AnActionButtonRunnable(){

            public void run(@NotNull AnActionButton button) {
                if (button == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (RailsPathsConfigurable.this.myIsManagedAutomatically || RailsPathsConfigurable.this.myList == null || RailsPathsConfigurable.this.myListModel == null) {
                    return;
                }
                FileChooserDescriptor descriptor = new FileChooserDescriptor(true, true, false, false, false, true);
                VirtualFile selectedFile = this.getSelectedFile();
                FileChooser.chooseFiles((FileChooserDescriptor)descriptor, (Project)RailsPathsConfigurable.this.myProject, RailsPathsConfigurable.this.myList, (VirtualFile)selectedFile, this::onFilesSelected);
            }

            @Nullable
            private VirtualFile getSelectedFile() {
                VirtualFileManager manager = VirtualFileManager.getInstance();
                List files = ContainerUtil.mapNotNull(RailsPathsConfigurable.this.myUrls, arg_0 -> ((VirtualFileManager)manager).findFileByUrl(arg_0));
                if (!files.isEmpty()) {
                    return VfsUtil.getCommonAncestor((Collection)files);
                }
                return (VirtualFile)ObjectUtils.doIfNotNull((Object)RailsPathsConfigurable.this.myRootUrl, arg_0 -> ((VirtualFileManager)manager).findFileByUrl(arg_0));
            }

            private void onFilesSelected(@NotNull List<? extends VirtualFile> files) {
                if (files == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (RailsPathsConfigurable.this.myList == null || RailsPathsConfigurable.this.myListModel == null || files.isEmpty()) {
                    return;
                }
                IntArrayList indicies = new IntArrayList();
                for (VirtualFile virtualFile : files) {
                    String url = virtualFile.getUrl();
                    if (RailsPathsConfigurable.this.myUrls.contains(url)) continue;
                    int index = RailsPathsConfigurable.this.myListModel.add((Object)url);
                    RailsPathsConfigurable.this.myUrls.add(index, url);
                    indicies.add(index);
                }
                RailsPathsConfigurable.this.computeUrlIcons();
                if (!indicies.isEmpty()) {
                    RailsPathsConfigurable.this.myList.setSelectedIndices(indicies.toIntArray());
                }
                RailsPathsConfigurable.this.myTreeUpdater.run();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "button";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "files";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/settings/paths/RailsPathsConfigurable$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "run";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onFilesSelected";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @NotNull
    private AnActionButtonRunnable createRemoveAction() {
        return new AnActionButtonRunnable(){

            public void run(@NotNull AnActionButton button) {
                if (button == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (RailsPathsConfigurable.this.myIsManagedAutomatically || RailsPathsConfigurable.this.myList == null || RailsPathsConfigurable.this.myListModel == null) {
                    return;
                }
                int[] indices = RailsPathsConfigurable.this.myList.getSelectedIndices();
                for (String url : RailsPathsConfigurable.this.myList.getSelectedValuesList()) {
                    RailsPathsConfigurable.this.myUrls.remove(url);
                    RailsPathsConfigurable.this.myListModel.remove((Object)url);
                }
                RailsPathsConfigurable.this.computeUrlIcons();
                if (indices.length > 0) {
                    RailsPathsConfigurable.this.myList.setSelectedIndex(indices[0]);
                }
                RailsPathsConfigurable.this.myTreeUpdater.run();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "button", "org/jetbrains/plugins/ruby/rails/settings/paths/RailsPathsConfigurable$3", "run"));
            }
        };
    }

    private void computeUrlIcons() {
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            for (String url : this.myUrls) {
                this.myUrlIcons.computeIfAbsent(url, __ -> {
                    VirtualFile file = VirtualFileManager.getInstance().findFileByUrl(url);
                    return file != null ? IconUtil.getIcon((VirtualFile)file, (int)2, (Project)this.myProject) : AllIcons.FileTypes.Unknown;
                });
            }
            ApplicationManager.getApplication().invokeLater(this.myTreeUpdater);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeUpdater";
                break;
            }
            case 2: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialUrls";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/settings/paths/RailsPathsConfigurable";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urls";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/settings/paths/RailsPathsConfigurable";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createOptionsPanel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getBannerSlogan";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditableObject";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setDisplayName";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setUrls";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7, 8, 9 -> new IllegalStateException(string);
        };
    }
}

